/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.sts;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.namespace.QName;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.config.federation.STSType;
import org.picketlink.config.federation.parsers.STSConfigParser;
import org.picketlink.identity.federation.core.interfaces.ProtocolContext;
import org.picketlink.identity.federation.core.interfaces.SecurityTokenProvider;
import org.picketlink.identity.federation.core.sts.STSCoreConfig;
import org.picketlink.identity.federation.core.sts.SecurityActions;
import org.picketlink.identity.federation.core.wstrust.PicketLinkSTSConfiguration;
import org.picketlink.identity.federation.core.wstrust.STSConfiguration;

public class PicketLinkCoreSTS {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    public static final RuntimePermission rte = new RuntimePermission("org.picketlink.sts");
    protected STSCoreConfig configuration;
    private static PicketLinkCoreSTS _instance = null;
    private static final String SEPARATOR = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("file.separator");
        }
    });
    private static final String STS_CONFIG_DIR = "picketlink-store" + SEPARATOR + "sts" + SEPARATOR;

    protected PicketLinkCoreSTS() {
    }

    public static PicketLinkCoreSTS instance() {
        if (_instance == null) {
            _instance = new PicketLinkCoreSTS();
        }
        return _instance;
    }

    public void initialize(STSCoreConfig config) {
        if (this.configuration != null) {
            this.configuration.copy(config);
        } else {
            this.configuration = config;
        }
    }

    public void installDefaultConfiguration(String ... configFileName) {
        String fileName = "core-sts.xml";
        if (configFileName != null && configFileName.length > 0) {
            fileName = configFileName[0];
        }
        if (this.configuration == null) {
            logger.trace("[InstallDefaultConfiguration] Configuration is null. Creating a new configuration");
            this.configuration = new PicketLinkSTSConfiguration();
        }
        try {
            logger.trace("[InstallDefaultConfiguration] Configuration file name=" + fileName);
            STSConfiguration config = this.getConfiguration(fileName);
            this.configuration.copy(config);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public void issueToken(ProtocolContext protocolContext) throws ProcessingException {
        SecurityTokenProvider provider;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(rte);
        }
        if ((provider = this.getProvider(protocolContext)) == null) {
            throw logger.stsNoTokenProviderError(this.configuration.toString(), protocolContext.toString());
        }
        logger.debug("issueToken::provider=" + provider);
        provider.issueToken(protocolContext);
    }

    public void renewToken(ProtocolContext protocolContext) throws ProcessingException {
        SecurityTokenProvider provider;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(rte);
        }
        if ((provider = null) == null) {
            provider = this.getProviderBasedOnQName(protocolContext);
        }
        if (provider == null) {
            throw logger.stsNoTokenProviderError(this.configuration.toString(), protocolContext.toString());
        }
        logger.debug("renewToken::provider=" + provider);
        provider.renewToken(protocolContext);
    }

    public void cancelToken(ProtocolContext protocolContext) throws ProcessingException {
        SecurityTokenProvider provider;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(rte);
        }
        if ((provider = null) == null) {
            provider = this.getProviderBasedOnQName(protocolContext);
        }
        if (provider == null) {
            throw logger.stsNoTokenProviderError("", protocolContext.toString());
        }
        logger.debug("cancelToken::provider=" + provider);
        provider.cancelToken(protocolContext);
    }

    public void validateToken(ProtocolContext protocolContext) throws ProcessingException {
        SecurityTokenProvider provider;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(rte);
        }
        if ((provider = null) == null) {
            provider = this.getProviderBasedOnQName(protocolContext);
        }
        if (provider == null) {
            throw logger.stsNoTokenProviderError(this.configuration.toString(), protocolContext.toString());
        }
        logger.debug("validateToken::provider=" + provider);
        provider.validateToken(protocolContext);
    }

    private SecurityTokenProvider getProvider(ProtocolContext protocolContext) {
        String tokenType;
        if (this.configuration == null) {
            throw new RuntimeException("PL00014: Configuration is not set");
        }
        SecurityTokenProvider provider = null;
        String serviceName = protocolContext.serviceName();
        if (serviceName != null) {
            provider = this.configuration.getProviderForService(serviceName);
        }
        if (provider == null && (tokenType = protocolContext.tokenType()) != null) {
            provider = this.configuration.getProviderForTokenType(protocolContext.tokenType());
        }
        return provider;
    }

    private SecurityTokenProvider getProviderBasedOnQName(ProtocolContext protocolContext) throws ProcessingException {
        SecurityTokenProvider provider = null;
        QName qname = null;
        if (provider == null) {
            qname = protocolContext.getQName();
            if (qname == null) {
                throw new ProcessingException("PL00092: Null Value:QName of the token type");
            }
            provider = this.configuration.getProviderForTokenElementNS(protocolContext.family(), qname);
        }
        if (provider == null) {
            throw new ProcessingException("PL00013: No Security Token Provider found in configuration:[" + qname.getNamespaceURI() + ":" + qname.getLocalPart());
        }
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected STSConfiguration getConfiguration(String fileName) throws ConfigurationException {
        URL configurationFileURL = null;
        try {
            String configurationFilePath = System.getProperty("user.home") + SEPARATOR + STS_CONFIG_DIR + fileName;
            File configurationFile = new File(configurationFilePath);
            configurationFileURL = configurationFile.exists() ? configurationFile.toURI().toURL() : SecurityActions.loadResource(this.getClass(), fileName);
            if (configurationFileURL == null) {
                logger.stsConfigurationFileNotFoundTCL(fileName);
                ClassLoader clazzLoader = SecurityActions.getClassLoader(this.getClass());
                configurationFileURL = clazzLoader.getResource(fileName);
            }
            if (configurationFileURL == null) {
                logger.stsConfigurationFileNotFoundClassLoader(fileName);
                try {
                    configurationFileURL = new URL(fileName);
                }
                catch (Exception e) {
                    PicketLinkSTSConfiguration picketLinkSTSConfiguration = new PicketLinkSTSConfiguration();
                    return picketLinkSTSConfiguration;
                }
                finally {
                    if (configurationFileURL == null) {
                        logger.stsUsingDefaultConfiguration(fileName);
                        return new PicketLinkSTSConfiguration();
                    }
                }
            }
            InputStream stream = configurationFileURL.openStream();
            STSType stsConfig = (STSType)new STSConfigParser().parse(stream);
            PicketLinkSTSConfiguration configuration = new PicketLinkSTSConfiguration(stsConfig);
            logger.stsConfigurationFileLoaded(fileName);
            return configuration;
        }
        catch (Exception e) {
            throw logger.stsConfigurationFileParsingError((Throwable)e);
        }
    }

    public STSCoreConfig getConfiguration() {
        return this.configuration;
    }
}

