/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.core.wstrust.SecurityActions;

public class STSClientConfig {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    public static final String DEFAULT_CONFIG_FILE = "sts-client.properties";
    public static final String SERVICE_NAME = "serviceName";
    public static final String PORT_NAME = "portName";
    public static final String ENDPOINT_ADDRESS = "endpointAddress";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String TOKEN_TYPE = "tokenType";
    public static final String WSA_ISSUER = "wsaIssuer";
    public static final String WSP_APPLIES_TO = "wspAppliesTo";
    public static final String IS_BATCH = "isBatch";
    public static final String REQUEST_TYPE = "requestType";
    public static final String SOAP_BINDING = "soapBinding";
    private final String serviceName;
    private final String portName;
    private final String endpointAddress;
    private final String username;
    private final String password;
    private final String wsaIssuer;
    private final String wspAppliesTo;
    private boolean isBatch = false;
    private final String requestType;
    private final String soapBinding;

    private STSClientConfig(Builder builder) {
        this.serviceName = builder.serviceName;
        this.portName = builder.portName;
        this.endpointAddress = builder.endpointAddress;
        this.username = builder.username;
        this.password = builder.password;
        this.isBatch = builder.isBatch;
        this.wsaIssuer = builder.wsaIssuer;
        this.wspAppliesTo = builder.wspAppliesTo;
        this.requestType = builder.requestType;
        this.soapBinding = builder.soapBinding;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getPortName() {
        return this.portName;
    }

    public String getEndPointAddress() {
        return this.endpointAddress;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getWsaIssuer() {
        return this.wsaIssuer;
    }

    public String getWspAppliesTo() {
        return this.wspAppliesTo;
    }

    public boolean isBatch() {
        return this.isBatch;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public String getSoapBinding() {
        return this.soapBinding;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[serviceName=" + this.serviceName + ", portName=" + this.portName + ", endpointAddress=" + this.endpointAddress + "]";
    }

    private static InputStream getResource(String resource) throws IOException {
        InputStream is;
        File file = new File(resource);
        if (file.exists() && !file.isDirectory()) {
            return new FileInputStream(file);
        }
        URL url = SecurityActions.loadResource(STSClientConfig.class, resource);
        if (url != null && (is = url.openStream()) != null) {
            return is;
        }
        return null;
    }

    public static class Builder {
        private String serviceName;
        private String portName;
        private String endpointAddress;
        private String username;
        private String password;
        private String wsaIssuer;
        private String wspAppliesTo;
        private boolean isBatch;
        private String requestType = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue";
        private String soapBinding = "http://schemas.xmlsoap.org/wsdl/soap/http";

        public Builder() {
        }

        public Builder(String configFile) {
            this.populate(configFile);
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder portName(String portName) {
            this.portName = portName;
            return this;
        }

        public Builder endpointAddress(String address) {
            this.endpointAddress = address;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder wsaIssuer(String wsa) {
            this.wsaIssuer = wsa;
            return this;
        }

        public Builder wspAppliesTo(String wsp) {
            this.wspAppliesTo = wsp;
            return this;
        }

        public Builder requestType(String requestType) {
            this.requestType = requestType;
            return this;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getPortName() {
            return this.portName;
        }

        public String getEndpointAddress() {
            return this.endpointAddress;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean isBatch() {
            return this.isBatch;
        }

        public void setBatch(boolean isBatch) {
            this.isBatch = isBatch;
        }

        public STSClientConfig build() {
            this.validate(this);
            return new STSClientConfig(this);
        }

        private void populate(String configFile) {
            block14: {
                InputStream in = null;
                try {
                    in = STSClientConfig.getResource(configFile);
                    if (in == null) {
                        throw logger.nullValueError("properties file " + configFile);
                    }
                    Properties properties = new Properties();
                    properties.load(in);
                    this.serviceName = properties.getProperty(STSClientConfig.SERVICE_NAME);
                    this.portName = properties.getProperty(STSClientConfig.PORT_NAME);
                    this.endpointAddress = properties.getProperty(STSClientConfig.ENDPOINT_ADDRESS);
                    this.username = properties.getProperty(STSClientConfig.USERNAME);
                    this.password = properties.getProperty(STSClientConfig.PASSWORD);
                    this.wsaIssuer = properties.getProperty(STSClientConfig.WSA_ISSUER);
                    this.wspAppliesTo = properties.getProperty(STSClientConfig.WSP_APPLIES_TO);
                    String batchStr = properties.getProperty(STSClientConfig.IS_BATCH);
                    this.isBatch = StringUtil.isNotNull((String)batchStr) ? Boolean.parseBoolean(batchStr) : false;
                    this.requestType = properties.getProperty(STSClientConfig.REQUEST_TYPE);
                    if (!StringUtil.isNullOrEmpty((String)properties.getProperty(STSClientConfig.SOAP_BINDING))) {
                        this.soapBinding = properties.getProperty(STSClientConfig.SOAP_BINDING);
                    }
                    if (!this.password.startsWith("MASK-")) break block14;
                    String salt = properties.getProperty("salt");
                    int iterationCount = Integer.parseInt(properties.getProperty("iterationCount"));
                    try {
                        this.password = StringUtil.decode((String)this.password, (String)salt, (int)iterationCount);
                    }
                    catch (Exception e) {
                        throw logger.unableToDecodePasswordError(this.password);
                    }
                }
                catch (IOException e) {
                    throw logger.couldNotLoadProperties(configFile);
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException ignored) {
                        ignored.printStackTrace();
                    }
                }
            }
        }

        private void validate(Builder builder) {
            logger.trace("Checkin ServiceName:");
            this.checkPropertyShowValue(STSClientConfig.SERVICE_NAME, this.serviceName);
            logger.trace("Checkin portName:");
            this.checkPropertyShowValue(STSClientConfig.PORT_NAME, this.portName);
            logger.trace("Checkin endpointAddress:");
            this.checkPropertyShowValue(STSClientConfig.ENDPOINT_ADDRESS, this.endpointAddress);
            logger.trace("Checkin username:");
            this.checkProperty(STSClientConfig.USERNAME, this.username);
            logger.trace("password portName:");
            this.checkProperty(STSClientConfig.PASSWORD, this.password);
        }

        private void checkPropertyShowValue(String propertyName, String propertyValue) {
            if (propertyValue == null || propertyValue.equals("")) {
                throw logger.nullValueError(propertyName + " : was:" + propertyValue);
            }
        }

        private void checkProperty(String propertyName, String propertyValue) {
            if (propertyValue == null || propertyValue.equals("")) {
                throw logger.nullValueError(propertyValue);
            }
        }
    }
}

