/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust;

import org.picketlink.identity.federation.core.wstrust.STSClient;
import org.picketlink.identity.federation.core.wstrust.STSClientConfig;
import org.picketlink.identity.federation.core.wstrust.STSClientCreationCallBack;
import org.picketlink.identity.federation.core.wstrust.STSClientPool;

public final class STSClientFactory {
    private STSClientPool stsClientPool = new STSClientPool();

    private STSClientFactory() {
    }

    public static STSClientFactory getInstance() {
        return LazySTSClientFactory.INSTANCE;
    }

    public static STSClientFactory getInstance(int maxClientsInPool) {
        LazySTSClientFactory.INSTANCE.stsClientPool.initializePool(maxClientsInPool);
        return LazySTSClientFactory.INSTANCE;
    }

    @Deprecated
    public STSClient create(STSClientConfig config) {
        return new STSClient(config);
    }

    public void createPool(STSClientConfig config) {
        this.createPool(0, config);
    }

    public void createPool(int initialNumberOfClients, STSClientConfig config) {
        if (!this.stsClientPool.isPoolingDisabled()) {
            this.stsClientPool.initialize(initialNumberOfClients, config);
        }
    }

    public void createPool(int initialNumberOfClients, STSClientCreationCallBack callBack) {
        if (!this.stsClientPool.isPoolingDisabled()) {
            this.stsClientPool.initialize(initialNumberOfClients, callBack);
        }
    }

    public void destroyPool(STSClientConfig config) {
        if (!this.stsClientPool.isPoolingDisabled()) {
            this.stsClientPool.destroy(config);
        }
    }

    public void returnClient(STSClient stsClient) {
        if (!this.stsClientPool.isPoolingDisabled()) {
            this.stsClientPool.putIn(stsClient);
        }
    }

    public STSClient getClient(STSClientConfig config) {
        if (this.stsClientPool.isPoolingDisabled()) {
            return new STSClient(config);
        }
        return this.stsClientPool.takeOut(config);
    }

    public boolean configExists(STSClientConfig config) {
        return this.stsClientPool.isConfigInitialized(config);
    }

    public void resetFactory() {
        this.stsClientPool = new STSClientPool();
    }

    private static class LazySTSClientFactory {
        private static final STSClientFactory INSTANCE = new STSClientFactory();

        private LazySTSClientFactory() {
        }
    }
}

