/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.writers;

import java.net.URI;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.StaxUtil;
import org.picketlink.identity.federation.core.saml.v2.writers.BaseWriter;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeType;
import org.picketlink.identity.federation.saml.v2.metadata.AdditionalMetadataLocationType;
import org.picketlink.identity.federation.saml.v2.metadata.AffiliationDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.AttributeAuthorityDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.AttributeConsumingServiceType;
import org.picketlink.identity.federation.saml.v2.metadata.AuthnAuthorityDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.ContactType;
import org.picketlink.identity.federation.saml.v2.metadata.ContactTypeType;
import org.picketlink.identity.federation.saml.v2.metadata.EndpointType;
import org.picketlink.identity.federation.saml.v2.metadata.EntitiesDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.EntityDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.ExtensionsType;
import org.picketlink.identity.federation.saml.v2.metadata.IDPSSODescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.IndexedEndpointType;
import org.picketlink.identity.federation.saml.v2.metadata.KeyDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.KeyTypes;
import org.picketlink.identity.federation.saml.v2.metadata.LocalizedNameType;
import org.picketlink.identity.federation.saml.v2.metadata.LocalizedURIType;
import org.picketlink.identity.federation.saml.v2.metadata.OrganizationType;
import org.picketlink.identity.federation.saml.v2.metadata.PDPDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.RequestedAttributeType;
import org.picketlink.identity.federation.saml.v2.metadata.RoleDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.SPSSODescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.SSODescriptorType;
import org.w3c.dom.Element;

public class SAMLMetadataWriter
extends BaseWriter {
    private final String METADATA_PREFIX = "md";

    public SAMLMetadataWriter(XMLStreamWriter writer) {
        super(writer);
    }

    public void writeEntitiesDescriptor(EntitiesDescriptorType entities) throws ProcessingException {
        ExtensionsType extensions;
        Element signature;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"md", (String)JBossSAMLConstants.ENTITIES_DESCRIPTOR.get(), (String)JBossSAMLURIConstants.METADATA_NSURI.get());
        StaxUtil.writeDefaultNameSpace((XMLStreamWriter)this.writer, (String)JBossSAMLURIConstants.METADATA_NSURI.get());
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)"md", (String)JBossSAMLURIConstants.METADATA_NSURI.get());
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)"saml", (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)"ds", (String)JBossSAMLURIConstants.XMLDSIG_NSURI.get());
        if (entities.getValidUntil() != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.VALID_UNTIL.get(), (String)entities.getValidUntil().toString());
        }
        if (entities.getID() != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.ID.get(), (String)entities.getID());
        }
        if (entities.getName() != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.NAME.get(), (String)entities.getName());
        }
        if ((signature = entities.getSignature()) != null) {
            StaxUtil.writeDOMElement((XMLStreamWriter)this.writer, (Element)signature);
        }
        if ((extensions = entities.getExtensions()) != null) {
            StaxUtil.writeDOMElement((XMLStreamWriter)this.writer, (Element)extensions.getElement());
        }
        List<Object> entityDescriptors = entities.getEntityDescriptor();
        for (Object ed : entityDescriptors) {
            if (ed instanceof EntityDescriptorType) {
                this.writeEntityDescriptor((EntityDescriptorType)ed);
                continue;
            }
            this.writeEntitiesDescriptor((EntitiesDescriptorType)ed);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void writeEntityDescriptor(EntityDescriptorType entityDescriptor) throws ProcessingException {
        ExtensionsType extensions;
        Element signature;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"md", (String)JBossSAMLConstants.ENTITY_DESCRIPTOR.get(), (String)JBossSAMLURIConstants.METADATA_NSURI.get());
        StaxUtil.writeDefaultNameSpace((XMLStreamWriter)this.writer, (String)JBossSAMLURIConstants.METADATA_NSURI.get());
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)"md", (String)JBossSAMLURIConstants.METADATA_NSURI.get());
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)"saml", (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)"ds", (String)JBossSAMLURIConstants.XMLDSIG_NSURI.get());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.ENTITY_ID.get(), (String)entityDescriptor.getEntityID());
        if (entityDescriptor.getValidUntil() != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.VALID_UNTIL.get(), (String)entityDescriptor.getValidUntil().toString());
        }
        if (entityDescriptor.getID() != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.ID.get(), (String)entityDescriptor.getID());
        }
        if ((signature = entityDescriptor.getSignature()) != null) {
            StaxUtil.writeDOMElement((XMLStreamWriter)this.writer, (Element)signature);
        }
        if ((extensions = entityDescriptor.getExtensions()) != null) {
            StaxUtil.writeDOMElement((XMLStreamWriter)this.writer, (Element)extensions.getElement());
        }
        List<EntityDescriptorType.EDTChoiceType> choiceTypes = entityDescriptor.getChoiceType();
        for (EntityDescriptorType.EDTChoiceType edtChoice : choiceTypes) {
            AffiliationDescriptorType affliationDesc = edtChoice.getAffiliationDescriptor();
            if (affliationDesc != null) {
                throw logger.notImplementedYet("affliation");
            }
            List<EntityDescriptorType.EDTDescriptorChoiceType> edtDescChoices = edtChoice.getDescriptors();
            for (EntityDescriptorType.EDTDescriptorChoiceType edtDescChoice : edtDescChoices) {
                AuthnAuthorityDescriptorType authNDesc;
                AttributeAuthorityDescriptorType attribAuth;
                SPSSODescriptorType spSSO;
                RoleDescriptorType roleDesc = edtDescChoice.getRoleDescriptor();
                if (roleDesc != null) {
                    throw logger.notImplementedYet("Role Descriptor type");
                }
                IDPSSODescriptorType idpSSO = edtDescChoice.getIdpDescriptor();
                if (idpSSO != null) {
                    this.write(idpSSO);
                }
                if ((spSSO = edtDescChoice.getSpDescriptor()) != null) {
                    this.write(spSSO);
                }
                if ((attribAuth = edtDescChoice.getAttribDescriptor()) != null) {
                    this.writeAttributeAuthorityDescriptor(attribAuth);
                }
                if ((authNDesc = edtDescChoice.getAuthnDescriptor()) != null) {
                    throw logger.notImplementedYet("AuthnAuthorityDescriptorType");
                }
                PDPDescriptorType pdpDesc = edtDescChoice.getPdpDescriptor();
                if (pdpDesc == null) continue;
                throw logger.notImplementedYet("PDPDescriptorType");
            }
        }
        OrganizationType organization = entityDescriptor.getOrganization();
        if (organization != null) {
            this.writeOrganization(organization);
        }
        List<ContactType> contactPersons = entityDescriptor.getContactPerson();
        for (ContactType contact : contactPersons) {
            this.write(contact);
        }
        List<AdditionalMetadataLocationType> addl = entityDescriptor.getAdditionalMetadataLocation();
        if (addl.size() > 0) {
            throw logger.notImplementedYet("AdditionalMetadataLocationType");
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(SSODescriptorType ssoDescriptor) throws ProcessingException {
        throw new RuntimeException("should not be called");
    }

    public void write(SPSSODescriptorType spSSODescriptor) throws ProcessingException {
        Boolean wantAssertionsSigned;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"md", (String)JBossSAMLConstants.SP_SSO_DESCRIPTOR.get(), (String)JBossSAMLURIConstants.METADATA_NSURI.get());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (QName)new QName(JBossSAMLConstants.PROTOCOL_SUPPORT_ENUMERATION.get()), (String)spSSODescriptor.getProtocolSupportEnumeration().get(0));
        Boolean authnSigned = spSSODescriptor.isAuthnRequestsSigned();
        if (authnSigned != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (QName)new QName(JBossSAMLConstants.AUTHN_REQUESTS_SIGNED.get()), (String)authnSigned.toString());
        }
        if ((wantAssertionsSigned = spSSODescriptor.isWantAssertionsSigned()) != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (QName)new QName(JBossSAMLConstants.WANT_ASSERTIONS_SIGNED.get()), (String)wantAssertionsSigned.toString());
        }
        List<KeyDescriptorType> keyDescriptors = spSSODescriptor.getKeyDescriptor();
        for (KeyDescriptorType keyDescriptorType : keyDescriptors) {
            this.writeKeyDescriptor(keyDescriptorType);
        }
        List<EndpointType> sloServices = spSSODescriptor.getSingleLogoutService();
        for (EndpointType endpointType : sloServices) {
            this.writeSingleLogoutService(endpointType);
        }
        List<IndexedEndpointType> list = spSSODescriptor.getArtifactResolutionService();
        for (IndexedEndpointType indexedEndpointType : list) {
            this.writeArtifactResolutionService(indexedEndpointType);
        }
        List<String> list2 = spSSODescriptor.getNameIDFormat();
        for (String string : list2) {
            this.writeNameIDFormat(string);
        }
        List<IndexedEndpointType> list3 = spSSODescriptor.getAssertionConsumerService();
        for (IndexedEndpointType assertionConsumer : list3) {
            this.writeAssertionConsumerService(assertionConsumer);
        }
        List<AttributeConsumingServiceType> list4 = spSSODescriptor.getAttributeConsumingService();
        for (AttributeConsumingServiceType attributeConsumer : list4) {
            this.writeAttributeConsumingService(attributeConsumer);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(IDPSSODescriptorType idpSSODescriptor) throws ProcessingException {
        if (idpSSODescriptor == null) {
            throw new ProcessingException((Throwable)logger.nullArgumentError("IDPSSODescriptorType"));
        }
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"md", (String)JBossSAMLConstants.IDP_SSO_DESCRIPTOR.get(), (String)JBossSAMLURIConstants.METADATA_NSURI.get());
        Boolean wantsAuthnRequestsSigned = idpSSODescriptor.isWantAuthnRequestsSigned();
        if (wantsAuthnRequestsSigned != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (QName)new QName(JBossSAMLConstants.WANT_AUTHN_REQUESTS_SIGNED.get()), (String)wantsAuthnRequestsSigned.toString());
        }
        this.writeProtocolSupportEnumeration(idpSSODescriptor.getProtocolSupportEnumeration());
        List<IndexedEndpointType> artifactResolutionServices = idpSSODescriptor.getArtifactResolutionService();
        for (IndexedEndpointType indexedEndpointType : artifactResolutionServices) {
            this.writeArtifactResolutionService(indexedEndpointType);
        }
        List<EndpointType> sloServices = idpSSODescriptor.getSingleLogoutService();
        for (EndpointType endpointType : sloServices) {
            this.writeSingleLogoutService(endpointType);
        }
        List<EndpointType> list = idpSSODescriptor.getSingleSignOnService();
        for (EndpointType endpointType : list) {
            this.writeSingleSignOnService(endpointType);
        }
        List<String> list2 = idpSSODescriptor.getNameIDFormat();
        for (String nameIDFormat : list2) {
            this.writeNameIDFormat(nameIDFormat);
        }
        List<AttributeType> list3 = idpSSODescriptor.getAttribute();
        for (AttributeType attribType : list3) {
            this.write(attribType);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void writeAttributeAuthorityDescriptor(AttributeAuthorityDescriptorType attributeAuthority) throws ProcessingException {
        ExtensionsType extensions;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"md", (String)JBossSAMLConstants.ATTRIBUTE_AUTHORITY_DESCRIPTOR.get(), (String)JBossSAMLURIConstants.METADATA_NSURI.get());
        this.writeProtocolSupportEnumeration(attributeAuthority.getProtocolSupportEnumeration());
        Element signature = attributeAuthority.getSignature();
        if (signature != null) {
            StaxUtil.writeDOMElement((XMLStreamWriter)this.writer, (Element)signature);
        }
        if ((extensions = attributeAuthority.getExtensions()) != null) {
            StaxUtil.writeDOMElement((XMLStreamWriter)this.writer, (Element)extensions.getElement());
        }
        List<KeyDescriptorType> keyDescriptorList = attributeAuthority.getKeyDescriptor();
        for (KeyDescriptorType keyDescriptorType : keyDescriptorList) {
            this.writeKeyDescriptor(keyDescriptorType);
        }
        List<EndpointType> attributeServices = attributeAuthority.getAttributeService();
        for (EndpointType endpointType : attributeServices) {
            this.writeAttributeService(endpointType);
        }
        List<String> list = attributeAuthority.getNameIDFormat();
        for (String nameIDFormat : list) {
            this.writeNameIDFormat(nameIDFormat);
        }
        List<AttributeType> list2 = attributeAuthority.getAttribute();
        for (AttributeType attributeType : list2) {
            this.write(attributeType);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void writeArtifactResolutionService(IndexedEndpointType indexedEndpoint) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"md", (String)JBossSAMLConstants.ARTIFACT_RESOLUTION_SERVICE.get(), (String)JBossSAMLURIConstants.METADATA_NSURI.get());
        this.writeIndexedEndpointType(indexedEndpoint);
    }

    public void writeAssertionConsumerService(IndexedEndpointType indexedEndpoint) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"md", (String)JBossSAMLConstants.ASSERTION_CONSUMER_SERVICE.get(), (String)JBossSAMLURIConstants.METADATA_NSURI.get());
        this.writeIndexedEndpointType(indexedEndpoint);
    }

    public void writeIndexedEndpointType(IndexedEndpointType indexedEndpoint) throws ProcessingException {
        this.writeEndpointType(indexedEndpoint);
        if (indexedEndpoint.isIsDefault() != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.ISDEFAULT.get(), (String)("" + indexedEndpoint.isIsDefault()));
        }
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.INDEX.get(), (String)("" + indexedEndpoint.getIndex()));
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void writeAttributeConsumingService(AttributeConsumingServiceType attributeConsumer) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"md", (String)JBossSAMLConstants.ATTRIBUTE_CONSUMING_SERVICE.get(), (String)JBossSAMLURIConstants.METADATA_NSURI.get());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.ISDEFAULT.get(), (String)("" + attributeConsumer.isIsDefault()));
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.INDEX.get(), (String)("" + attributeConsumer.getIndex()));
        List<LocalizedNameType> serviceNames = attributeConsumer.getServiceName();
        for (LocalizedNameType localizedNameType : serviceNames) {
            this.writeLocalizedNameType(localizedNameType, new QName(JBossSAMLURIConstants.METADATA_NSURI.get(), JBossSAMLConstants.SERVICE_NAME.get(), "md"));
        }
        List<LocalizedNameType> serviceDescriptions = attributeConsumer.getServiceDescription();
        for (LocalizedNameType serviceDescription : serviceDescriptions) {
            this.writeLocalizedNameType(serviceDescription, new QName(JBossSAMLURIConstants.METADATA_NSURI.get(), JBossSAMLConstants.SERVICE_DESCRIPTION.get(), "md"));
        }
        List<RequestedAttributeType> list = attributeConsumer.getRequestedAttribute();
        for (RequestedAttributeType requestedAttribute : list) {
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"md", (String)JBossSAMLConstants.REQUESTED_ATTRIBUTE.get(), (String)JBossSAMLURIConstants.METADATA_NSURI.get());
            Boolean isRequired = requestedAttribute.isIsRequired();
            if (isRequired != null) {
                StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (QName)new QName(JBossSAMLConstants.IS_REQUIRED.get()), (String)isRequired.toString());
            }
            this.writeAttributeTypeWithoutRootTag(requestedAttribute);
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void writeOrganization(OrganizationType org) throws ProcessingException {
        if (org == null) {
            throw new ProcessingException((Throwable)logger.nullArgumentError("Organization"));
        }
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"md", (String)JBossSAMLConstants.ORGANIZATION.get(), (String)JBossSAMLURIConstants.METADATA_NSURI.get());
        ExtensionsType extensions = org.getExtensions();
        if (extensions != null) {
            StaxUtil.writeDOMElement((XMLStreamWriter)this.writer, (Element)extensions.getElement());
        }
        List<LocalizedNameType> nameList = org.getOrganizationName();
        for (LocalizedNameType localizedNameType : nameList) {
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"md", (String)JBossSAMLConstants.ORGANIZATION_NAME.get(), (String)JBossSAMLURIConstants.METADATA_NSURI.get());
            this.writeLocalizedType(localizedNameType);
        }
        List<LocalizedNameType> displayNameList = org.getOrganizationDisplayName();
        for (LocalizedNameType localName : displayNameList) {
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"md", (String)JBossSAMLConstants.ORGANIZATION_DISPLAY_NAME.get(), (String)JBossSAMLURIConstants.METADATA_NSURI.get());
            this.writeLocalizedType(localName);
        }
        List<LocalizedURIType> list = org.getOrganizationURL();
        for (LocalizedURIType uri : list) {
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"md", (String)JBossSAMLConstants.ORGANIZATION_URL.get(), (String)JBossSAMLURIConstants.METADATA_NSURI.get());
            String lang = uri.getLang();
            String val = uri.getValue().toString();
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (QName)new QName(JBossSAMLURIConstants.XML.get(), JBossSAMLConstants.LANG.get(), "xml"), (String)lang);
            StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)val);
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(ContactType contact) throws ProcessingException {
        String surName;
        String givenName;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"md", (String)JBossSAMLConstants.CONTACT_PERSON.get(), (String)JBossSAMLURIConstants.METADATA_NSURI.get());
        ExtensionsType extensions = contact.getExtensions();
        if (extensions != null) {
            StaxUtil.writeDOMElement((XMLStreamWriter)this.writer, (Element)extensions.getElement());
        }
        ContactTypeType attribs = contact.getContactType();
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.CONTACT_TYPE.get(), (String)attribs.value());
        String company = contact.getCompany();
        if (company != null) {
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"md", (String)JBossSAMLConstants.COMPANY.get(), (String)JBossSAMLURIConstants.METADATA_NSURI.get());
            StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)company);
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        if ((givenName = contact.getGivenName()) != null) {
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"md", (String)JBossSAMLConstants.GIVEN_NAME.get(), (String)JBossSAMLURIConstants.METADATA_NSURI.get());
            StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)givenName);
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        if ((surName = contact.getSurName()) != null) {
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"md", (String)JBossSAMLConstants.SURNAME.get(), (String)JBossSAMLURIConstants.METADATA_NSURI.get());
            StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)surName);
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        List<String> emailAddresses = contact.getEmailAddress();
        for (String email : emailAddresses) {
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"md", (String)JBossSAMLConstants.EMAIL_ADDRESS.get(), (String)JBossSAMLURIConstants.METADATA_NSURI.get());
            StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)email);
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        List<String> tels = contact.getTelephoneNumber();
        for (String telephone : tels) {
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"md", (String)JBossSAMLConstants.TELEPHONE_NUMBER.get(), (String)JBossSAMLURIConstants.METADATA_NSURI.get());
            StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)telephone);
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void writeKeyDescriptor(KeyDescriptorType keyDescriptor) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"md", (String)JBossSAMLConstants.KEY_DESCRIPTOR.get(), (String)JBossSAMLURIConstants.METADATA_NSURI.get());
        KeyTypes keyTypes = keyDescriptor.getUse();
        if (keyTypes != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (QName)new QName(JBossSAMLConstants.USE.get()), (String)keyTypes.value());
        }
        Element keyInfo = keyDescriptor.getKeyInfo();
        StaxUtil.writeDOMElement((XMLStreamWriter)this.writer, (Element)keyInfo);
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void writeAttributeService(EndpointType endpoint) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"md", (String)JBossSAMLConstants.ATTRIBUTE_SERVICE.get(), (String)JBossSAMLURIConstants.METADATA_NSURI.get());
        this.writeEndpointType(endpoint);
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void writeSingleLogoutService(EndpointType endpoint) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"md", (String)JBossSAMLConstants.SINGLE_LOGOUT_SERVICE.get(), (String)JBossSAMLURIConstants.METADATA_NSURI.get());
        this.writeEndpointType(endpoint);
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void writeSingleSignOnService(EndpointType endpoint) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"md", (String)JBossSAMLConstants.SINGLE_SIGNON_SERVICE.get(), (String)JBossSAMLURIConstants.METADATA_NSURI.get());
        this.writeEndpointType(endpoint);
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    private void writeProtocolSupportEnumeration(List<String> protoEnum) throws ProcessingException {
        if (protoEnum.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (String str : protoEnum) {
                sb.append(str).append(" ");
            }
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (QName)new QName(JBossSAMLConstants.PROTOCOL_SUPPORT_ENUMERATION.get()), (String)sb.toString().trim());
        }
    }

    private void writeEndpointType(EndpointType endpoint) throws ProcessingException {
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.BINDING.get(), (String)endpoint.getBinding().toString());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.LOCATION.get(), (String)endpoint.getLocation().toString());
        URI responseLocation = endpoint.getResponseLocation();
        if (responseLocation != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.RESPONSE_LOCATION.get(), (String)responseLocation.toString());
        }
    }

    private void writeLocalizedType(LocalizedNameType localName) throws ProcessingException {
        String lang = localName.getLang();
        String val = localName.getValue();
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (QName)new QName(JBossSAMLURIConstants.XML.get(), JBossSAMLConstants.LANG.get(), "xml"), (String)lang);
        StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)val);
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
    }

    private void writeNameIDFormat(String nameIDFormat) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"md", (String)JBossSAMLConstants.NAMEID_FORMAT.get(), (String)JBossSAMLURIConstants.METADATA_NSURI.get());
        StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)nameIDFormat);
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
    }
}

