/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm;

import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.password.PasswordEncoder;
import org.picketlink.idm.query.GroupQuery;
import org.picketlink.idm.query.MembershipQuery;
import org.picketlink.idm.query.RoleQuery;
import org.picketlink.idm.query.UserQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IdentityManager {
    public User createUser(String var1);

    public User createUser(User var1);

    public void removeUser(User var1);

    public void removeUser(String var1);

    public User getUser(String var1);

    public Collection<User> getAllUsers();

    public Group createGroup(String var1);

    public Group createGroup(String var1, Group var2);

    public Group createGroup(String var1, String var2);

    public void removeGroup(Group var1);

    public void removeGroup(String var1);

    public Group getGroup(String var1);

    public Group getGroup(String var1, Group var2);

    public Collection<Group> getAllGroups();

    public void addToGroup(IdentityType var1, Group var2);

    public void removeFromGroup(IdentityType var1, Group var2);

    public Collection<IdentityType> getGroupMembers(Group var1);

    public Role createRole(String var1);

    public void removeRole(Role var1);

    public void removeRole(String var1);

    public Role getRole(String var1);

    public Collection<Role> getAllRoles();

    public Collection<Role> getRoles(IdentityType var1, Group var2);

    public boolean hasRole(Role var1, IdentityType var2, Group var3);

    public void grantRole(Role var1, IdentityType var2, Group var3);

    public void revokeRole(Role var1, IdentityType var2, Group var3);

    public UserQuery createUserQuery();

    public GroupQuery createGroupQuery();

    public RoleQuery createRoleQuery();

    public MembershipQuery createMembershipQuery();

    public boolean validatePassword(User var1, String var2);

    public void updatePassword(User var1, String var2);

    public void setPasswordEncoder(PasswordEncoder var1);

    public boolean validateCertificate(User var1, X509Certificate var2);

    public boolean updateCertificate(User var1, X509Certificate var2);

    public void setEnabled(IdentityType var1, boolean var2);

    public void setExpirationDate(IdentityType var1, Date var2);

    public IdentityType lookupIdentityByKey(String var1);
}

