/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.AnnotatedElement;
import javax.naming.NamingException;
import org.jboss.logging.Cause;
import org.jboss.logging.Message;
import org.jboss.logging.MessageBundle;
import org.jboss.logging.Messages;
import org.jboss.logging.Param;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.OperationNotSupportedException;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.password.PasswordEncoder;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.spi.IdentityStore;

@MessageBundle(projectCode="PLIDM")
public interface IDMMessages {
    public static final IDMMessages MESSAGES = (IDMMessages)Messages.getBundle(IDMMessages.class);

    @Message(id=1, value="Unsupported IdentityType [%s].")
    public IdentityManagementException identityTypeUnsupportedType(Class<? extends IdentityType> var1);

    @Message(id=2, value="IdentityType [%s] already exists with the given identifier [%s] for the given Partition [%s].")
    public IdentityManagementException identityTypeAlreadyExists(Class<? extends IdentityType> var1, String var2, Partition var3);

    @Message(id=3, value="Ambiguous IdentityType found with identifier [%s].")
    public IdentityManagementException identityTypeAmbiguosFoundWithId(String var1);

    @Message(id=52, value="Could not add IdentityType [%s].")
    public IdentityManagementException identityTypeAddFailed(IdentityType var1, @Cause Throwable var2);

    @Message(id=53, value="Could not remove IdentityType [%s].")
    public IdentityManagementException identityTypeRemoveFailed(IdentityType var1, @Cause Throwable var2);

    @Message(id=54, value="Could not update IdentityType [%s].")
    public IdentityManagementException identityTypeUpdateFailed(IdentityType var1, @Cause Throwable var2);

    @Message(id=55, value="Could not query IdentityType using query [%s].")
    public IdentityManagementException identityTypeQueryFailed(IdentityQuery<?> var1, @Cause Throwable var2);

    @Message(id=4, value="Unsupported AttributedType [%s].")
    public IdentityManagementException attributedTypeUnsupportedType(Class<? extends AttributedType> var1);

    @Message(id=5, value="Could not find AttributedType [%s] with the given identifier [%s] for Partition [%s]")
    public IdentityManagementException attributedTypeNotFoundWithId(Class<? extends AttributedType> var1, String var2, Partition var3);

    @Message(id=6, value="Method not implemented, yet.")
    public RuntimeException notImplentedYet();

    @Message(id=7, value="Error creating instance for type [%s].")
    public IdentityManagementException instantiationError(String var1, @Cause Throwable var2);

    @Message(id=8, value="Could not find class [%s].")
    public IdentityManagementException classNotFound(String var1);

    @Message(id=9, value="Null argument: [%s].")
    public IdentityManagementException nullArgument(String var1);

    @Message(id=10, value="Error unmarshalling object.")
    public IdentityManagementException unmarshallingError(@Cause Throwable var1);

    @Message(id=11, value="Error marshalling object.")
    public IdentityManagementException marshallingError(@Cause Throwable var1);

    @Message(id=12, value="Could not create contextual IdentityManager for Partition [%s]. Partition not found or it was null.")
    public IdentityManagementException couldNotCreateContextualIdentityManager(Partition var1);

    @Message(id=13, value="QueryParameter [%s] is not supported for sorting.")
    public IdentityManagementException notSortableQueryParameter(QueryParameter var1);

    @Message(id=14, value="Feature set has already been locked, no additional features may be added.")
    public SecurityConfigurationException storeConfigLockedFeatureSet();

    @Message(id=15, value="The specified realm [%s] has not been configured.")
    public SecurityConfigurationException storeConfigRealmNotConfigured(String var1);

    @Message(id=16, value="No identity store configuration found that supports the relationship type [%s].")
    public SecurityConfigurationException storeConfigUnsupportedRelationshipType(Class<? extends Relationship> var1);

    @Message(id=17, value="The IdentityStoreConfiguration [%s] specified is not supported by this IdentityStoreFactory implementation.")
    public SecurityConfigurationException storeConfigUnsupportedConfiguration(IdentityStoreConfiguration var1);

    @Message(id=18, value="No identity store configuration found for requested operation [%s.%s].")
    public OperationNotSupportedException storeConfigUnsupportedOperation(@Param FeatureSet.FeatureGroup var1, @Param FeatureSet.FeatureOperation var2, FeatureSet.FeatureGroup var3, FeatureSet.FeatureOperation var4);

    @Message(id=19, value="Error creating instance for CredentialHandler [%s].")
    public IdentityManagementException credentialCredentialHandlerInstantiationError(Class<? extends CredentialHandler> var1, @Cause Throwable var2);

    @Message(id=20, value="Credentials class [%s] not supported by this handler [%s].")
    public IdentityManagementException credentialUnsupportedType(Class<?> var1, CredentialHandler var2);

    @Message(id=21, value="Provided IdentityStore [%s] is not an instance of CredentialStore.")
    public IdentityManagementException credentialInvalidCredentialStoreType(Class<? extends IdentityStore> var1);

    @Message(id=22, value="Invalid Realm or it was not provided.")
    public IdentityManagementException credentialDigestInvalidRealm();

    @Message(id=23, value="Invalid Password or it was not provided.")
    public IdentityManagementException credentialInvalidPassword();

    @Message(id=24, value="Could not encode password.")
    public IdentityManagementException credentialCouldNotEncodePassword(@Cause UnsupportedEncodingException var1);

    @Message(id=25, value="No suitable CredentialHandler available for validating Credentials of type [%s].")
    public IdentityManagementException credentialHandlerNotFoundForCredentialType(Class<?> var1);

    @Message(id=26, value="No Group found with the given path [%s] for Partition [%s].")
    public IdentityManagementException groupNotFoundWithPath(String var1, Partition var2);

    @Message(id=27, value="No Parent Group found with the given id [%s] for Partition [%s].")
    public IdentityManagementException groupParentNotFoundWithId(String var1, Partition var2);

    @Message(id=28, value="Ambiguos relationship found [%s].")
    public IdentityManagementException relationshipAmbiguosFound(Relationship var1);

    @Message(id=29, value="Unsupported IdentityType. Group members are only Agent or Group instances. You provided [%s].")
    public IdentityManagementException relationshipUnsupportedGroupMemberType(IdentityType var1);

    @Message(id=30, value="Unsupported type for the Grant assignee. Roles are granted for Agent and Group only. You provided [%s].")
    public IdentityManagementException relationshipUnsupportedGrantAssigneeType(IdentityType var1);

    @Message(id=56, value="Could not add Relationship [%s].")
    public IdentityManagementException relationshipAddFailed(Relationship var1, @Cause Throwable var2);

    @Message(id=57, value="Could not remove Relationship [%s].")
    public IdentityManagementException relationshipRemoveFailed(Relationship var1, @Cause Throwable var2);

    @Message(id=58, value="Could not update Relationship [%s].")
    public IdentityManagementException relationshipUpdateFailed(Relationship var1, @Cause Throwable var2);

    @Message(id=59, value="Could not query Relationship using query [%s].")
    public IdentityManagementException relationshipQueryFailed(RelationshipQuery<?> var1, @Cause Throwable var2);

    @Message(id=31, value="Partition not found with id [%s].")
    public IdentityManagementException partitionNotFoundWithId(String var1);

    @Message(id=32, value="Unsupported partition type [%s].")
    public IdentityManagementException partitionUnsupportedType(String var1);

    @Message(id=33, value="A Partition [%s] with name [%s] already exists.")
    public IdentityManagementException partitionAlreadyExistsWithName(Class<? extends Partition> var1, String var2);

    @Message(id=34, value="Partition [%s] not found with the given name [%s].")
    public IdentityManagementException partitionNotFoundWithName(Class<? extends Partition> var1, String var2);

    @Message(id=35, value="Partition [%s] could not be removed. There are IdentityTypes associated with it. Remove them first.")
    public IdentityManagementException partitionCouldNotRemoveWithIdentityTypes(Partition var1);

    @Message(id=36, value="Partition [%s] could not be removed. There are child partitions associated with it. Remove them first.")
    public IdentityManagementException partitionCouldNotRemoveWithChilds(Partition var1);

    @Message(id=37, value="Unsupported value for Query Parameter [%s]. Value: %s.")
    public IdentityManagementException queryUnsupportedParameterValue(String var1, Object var2);

    @Message(id=38, value="Error while trying to determine EntityManager - context parameter not set.")
    public IdentityManagementException jpaStoreCouldNotGetEntityManagerFromStoreContext();

    @Message(id=39, value="Ambiguous property [%s] property in class [%s]")
    public SecurityConfigurationException jpaConfigAmbiguosPropertyForClass(String var1, Class<?> var2);

    @Message(id=40, value="Model property [%s] has not been configured.")
    public SecurityConfigurationException jpaConfigModelPropertyNotConfigured(String var1);

    @Message(id=41, value="Error initializing JpaIdentityStore - identityClass not set.")
    public SecurityConfigurationException jpaConfigIdentityClassNotProvided();

    @Message(id=42, value="Error initializing JpaIdentityStore - partitionClass not set.")
    public SecurityConfigurationException jpaConfigPartitionClassNotProvided();

    @Message(id=43, value="Multiple properties defined for attribute [%s] - Property: %s.%s, Property: %s.%s")
    public SecurityConfigurationException jpaConfigMultiplePropertiesForAttribute(String var1, Class<?> var2, AnnotatedElement var3, Class<?> var4, AnnotatedElement var5);

    @Message(id=44, value="Could not retrieve LDAP attribute [%s]")
    public IdentityManagementException ldapStoreFailToRetrieveAttribute(String var1, @Cause Throwable var2);

    @Message(id=45, value="Unknown Base DN [%s] for IdentityType.")
    public IdentityManagementException ldapStoreUnknownBaseDNForIdentityType(String var1);

    @Message(id=46, value="Could not execute search on server.")
    public IdentityManagementException ldapStoreSearchFailed(@Cause NamingException var1);

    @Message(id=47, value="Could not create GroupRole entry.")
    public IdentityManagementException ldapStoreCouldNotCreateGroupRoleEntry(@Cause NamingException var1);

    @Message(id=48, value="Could not remove GroupRole entry.")
    public IdentityManagementException ldapStoreCouldNotRemoveGroupRoleEntry(@Cause NamingException var1);

    @Message(id=49, value="User baseDN not provided.")
    public SecurityConfigurationException ldapConfigUserDNNotProvided();

    @Message(id=50, value="Role baseDN not provided.")
    public SecurityConfigurationException ldapConfigRoleDNNotProvided();

    @Message(id=51, value="Group baseDN not provided.")
    public SecurityConfigurationException ldapConfigGroupDNNotProvided();

    @Message(id=60, value="Could not initialize filesystem.")
    public SecurityConfigurationException fileConfigFailedToInitializeFilesystem(@Cause Throwable var1);

    @Message(id=61, value="No discriminator could be determined for type [%s].")
    public SecurityConfigurationException jpaConfigDiscriminatorNotFoundForIdentityType(Class<? extends IdentityType> var1);

    @Message(id=62, value="Could not create context.")
    public IdentityManagementException ldapCouldNotCreateContext(@Cause Throwable var1);

    @Message(id=63, value="Could not find Users BaseDN [%s].")
    public IdentityManagementException ldapCouldNotFindUsersBaseDN(String var1, @Cause Throwable var2);

    @Message(id=64, value="Could not find Roles BaseDN [%s].")
    public IdentityManagementException ldapCouldNotFindRolesBaseDN(String var1, @Cause Throwable var2);

    @Message(id=65, value="Could not find Groups BaseDN [%s].")
    public IdentityManagementException ldapCouldNotFindGroupsBaseDN(String var1, @Cause Throwable var2);

    @Message(id=66, value="Could not find Agents BaseDN [%s].")
    public IdentityManagementException ldapCouldNotFindAgentsBaseDN(String var1, @Cause Throwable var2);

    @Message(id=67, value="Agents can only be stored and managed from a Realm. Current partition is [%s].")
    public IdentityManagementException partitionInvalidTypeForAgents(Class<? extends Partition> var1);

    @Message(id=68, value="The specified tier [%s] has not been configured.")
    public SecurityConfigurationException storeConfigTierNotConfigured(String var1);

    @Message(id=69, value="Could not create IdentityManagerFactory implementation [%s].")
    public SecurityConfigurationException configurationCouldNotCreateIdentityManagerFactoryImpl(String var1, @Cause Throwable var2);

    @Message(id=70, value="The default Realm was not configured for any identity store. Check your configuration.")
    public SecurityConfigurationException configurationDefaultRealmNotDefined();

    @Message(id=71, value="The same feature [%s] was configured for different IdentityStoreConfiguration [%s, %s].")
    public SecurityConfigurationException configurationAmbiguousFeatureForStore(FeatureSet.FeatureGroup var1, IdentityStoreConfiguration var2, IdentityStoreConfiguration var3);

    @Message(id=72, value="No such algorithm [%s] for encoding passwords. Using PasswordEncoder [%s].")
    public IdentityManagementException credentialInvalidEncodingAlgorithm(String var1, PasswordEncoder var2, @Cause Throwable var3);

    @Message(id=73, value="Credentials can only be managed from a Realm. Current partition is [%s].")
    public IdentityManagementException partitionInvalidTypeForCredential(Class<? extends Partition> var1);

    @Message(id=74, value="You must specify which credentials are supported by the [%s].")
    public IdentityManagementException credentialSupportedCredentialsNotProvided(Class<? extends CredentialHandler> var1);
}

