/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.properties.query.PropertyQuery;
import org.picketlink.common.properties.query.TypedPropertyCriteria;
import org.picketlink.idm.IDMLogger;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.BaseAbstractStoreConfiguration;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.jpa.annotations.AttributeName;
import org.picketlink.idm.jpa.annotations.AttributeType;
import org.picketlink.idm.jpa.annotations.AttributeValue;
import org.picketlink.idm.jpa.annotations.CreationDate;
import org.picketlink.idm.jpa.annotations.CredentialType;
import org.picketlink.idm.jpa.annotations.CredentialValue;
import org.picketlink.idm.jpa.annotations.Discriminator;
import org.picketlink.idm.jpa.annotations.EffectiveDate;
import org.picketlink.idm.jpa.annotations.Email;
import org.picketlink.idm.jpa.annotations.Enabled;
import org.picketlink.idm.jpa.annotations.ExpiryDate;
import org.picketlink.idm.jpa.annotations.FirstName;
import org.picketlink.idm.jpa.annotations.GroupPath;
import org.picketlink.idm.jpa.annotations.IDMAttribute;
import org.picketlink.idm.jpa.annotations.Identifier;
import org.picketlink.idm.jpa.annotations.Identity;
import org.picketlink.idm.jpa.annotations.IdentityName;
import org.picketlink.idm.jpa.annotations.IdentityPartition;
import org.picketlink.idm.jpa.annotations.LastName;
import org.picketlink.idm.jpa.annotations.LoginName;
import org.picketlink.idm.jpa.annotations.Parent;
import org.picketlink.idm.jpa.annotations.RelationshipClass;
import org.picketlink.idm.jpa.annotations.RelationshipDescriptor;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.spi.ContextInitializer;

public class JPAIdentityStoreConfiguration
extends BaseAbstractStoreConfiguration {
    private static final String DEFAULT_USER_IDENTITY_DISCRIMINATOR = "USER";
    private static final String DEFAULT_ROLE_IDENTITY_DISCRIMINATOR = "ROLE";
    private static final String DEFAULT_GROUP_IDENTITY_DISCRIMINATOR = "GROUP";
    private static final String DEFAULT_AGENT_IDENTITY_DISCRIMINATOR = "AGENT";
    private String identityTypeAgent = "AGENT";
    private String identityTypeUser = "USER";
    private String identityTypeRole = "ROLE";
    private String identityTypeGroup = "GROUP";
    private Map<PropertyType, Property<Object>> modelProperties = new HashMap<PropertyType, Property<Object>>();
    private Map<String, MappedAttribute> attributeProperties = new HashMap<String, MappedAttribute>();
    private Class<?> identityClass;
    private Class<?> attributeClass;
    private Class<?> credentialClass;
    private Class<?> credentialAttributeClass;
    private Class<?> relationshipClass;
    private Class<?> relationshipIdentityClass;
    private Class<?> relationshipAttributeClass;
    private Class<?> partitionClass;

    JPAIdentityStoreConfiguration(Class<?> identityClass, Class<?> attributeClass, Class<?> credentialClass, Class<?> credentialAttributeClass, Class<?> relationshipClass, Class<?> relationshipIdentityClass, Class<?> relationshipAttributeClass, Class<?> partitionClass, Map<FeatureSet.FeatureGroup, Set<FeatureSet.FeatureOperation>> supportedFeatures, Map<Class<? extends Relationship>, Set<FeatureSet.FeatureOperation>> supportedRelationships, Set<String> realms, Set<String> tiers, List<ContextInitializer> contextInitializers, Map<String, Object> credentialHandlerProperties, List<Class<? extends CredentialHandler>> credentialHandlers) {
        super(supportedFeatures, supportedRelationships, realms, tiers, contextInitializers, credentialHandlerProperties, credentialHandlers);
        this.identityClass = identityClass;
        this.attributeClass = attributeClass;
        this.credentialAttributeClass = credentialAttributeClass;
        this.credentialClass = credentialClass;
        this.relationshipAttributeClass = relationshipAttributeClass;
        this.relationshipClass = relationshipClass;
        this.relationshipIdentityClass = relationshipIdentityClass;
        this.partitionClass = partitionClass;
    }

    @Override
    protected void initConfig() throws SecurityConfigurationException {
        this.configureIdentity();
        this.configurePartitions();
        this.configureRelationships();
        this.configureCredentials();
    }

    public Class<?> getIdentityClass() {
        return this.identityClass;
    }

    public Class<?> getCredentialClass() {
        return this.credentialClass;
    }

    public Class<?> getCredentialAttributeClass() {
        return this.credentialAttributeClass;
    }

    public Class<?> getRelationshipClass() {
        return this.relationshipClass;
    }

    public Class<?> getPartitionClass() {
        return this.partitionClass;
    }

    public Class<?> getRelationshipIdentityClass() {
        return this.relationshipIdentityClass;
    }

    public Class<?> getRelationshipAttributeClass() {
        return this.relationshipAttributeClass;
    }

    public Class<?> getAttributeClass() {
        return this.attributeClass;
    }

    public Property<Object> getModelProperty(PropertyType propertyType) {
        return this.modelProperties.get((Object)propertyType);
    }

    public <P> P getModelPropertyValue(Class<P> propertyClass, Object instance, PropertyType propertyType) {
        Property<Object> property = this.getModelProperty(propertyType);
        return (P)(property == null ? null : property.getValue(instance));
    }

    public void setModelPropertyValue(Object instance, PropertyType propertyType, Object value) {
        this.setModelPropertyValue(instance, propertyType, value, false);
    }

    public void setModelPropertyValue(Object instance, PropertyType propertyType, Object value, boolean required) {
        if (this.isModelPropertySet(propertyType)) {
            this.getModelProperty(propertyType).setValue(instance, value);
        } else if (required) {
            throw IDMMessages.MESSAGES.jpaConfigModelPropertyNotConfigured(propertyType.name());
        }
    }

    public Map<String, MappedAttribute> getAttributeProperties() {
        return this.attributeProperties;
    }

    private String getIdentityTypeUser() {
        return this.identityTypeUser;
    }

    private String getIdentityTypeGroup() {
        return this.identityTypeGroup;
    }

    private String getIdentityTypeRole() {
        return this.identityTypeRole;
    }

    private String getIdentityTypeAgent() {
        return this.identityTypeAgent;
    }

    public String getIdentityTypeDiscriminator(Class<? extends IdentityType> identityType) {
        String discriminator = null;
        if (User.class.isAssignableFrom(identityType)) {
            discriminator = this.getIdentityTypeUser();
        } else if (Agent.class.isAssignableFrom(identityType)) {
            discriminator = this.getIdentityTypeAgent();
        } else if (Role.class.isAssignableFrom(identityType)) {
            discriminator = this.getIdentityTypeRole();
        } else if (Group.class.isAssignableFrom(identityType)) {
            discriminator = this.getIdentityTypeGroup();
        } else {
            throw IDMMessages.MESSAGES.jpaConfigDiscriminatorNotFoundForIdentityType(identityType);
        }
        return discriminator;
    }

    public Class<? extends IdentityType> getIdentityTypeFromDiscriminator(String discriminator) {
        Class type = null;
        if (this.getIdentityTypeUser().equals(discriminator)) {
            type = User.class;
        } else if (this.getIdentityTypeAgent().equals(discriminator)) {
            type = Agent.class;
        } else if (this.getIdentityTypeRole().equals(discriminator)) {
            type = Role.class;
        } else if (this.getIdentityTypeGroup().equals(discriminator)) {
            type = Group.class;
        } else {
            throw new IdentityManagementException("Discriminator [" + discriminator + "] does not map to an IdentityType.");
        }
        return type;
    }

    private void configureIdentity() throws SecurityConfigurationException {
        this.configureModelProperty(PropertyType.IDENTITY_DISCRIMINATOR, Discriminator.class, this.identityClass, null, "discriminator", "identityType", "identityTypeName", "typeName", "type");
        this.configureModelProperty(PropertyType.IDENTITY_ID, Identifier.class, this.identityClass, null, "id", "identifier");
        this.configureModelProperty(PropertyType.IDENTITY_NAME, IdentityName.class, this.identityClass, null, "name");
        this.configureModelProperty(PropertyType.IDENTITY_ENABLED, Enabled.class, this.identityClass, null, "enabled", "active");
        this.configureModelProperty(PropertyType.IDENTITY_CREATION_DATE, CreationDate.class, this.identityClass, null, false, "created", "creationDate");
        this.configureModelProperty(PropertyType.IDENTITY_EXPIRY_DATE, ExpiryDate.class, this.identityClass, null, false, "expires", "expiryDate");
        this.configureModelProperty(PropertyType.IDENTITY_PARTITION, IdentityPartition.class, this.identityClass, null, false, "partition");
        this.configureModelProperty(PropertyType.GROUP_PARENT, Parent.class, this.identityClass, null, "parentGroup", "parent");
        this.configureModelProperty(PropertyType.GROUP_PATH, GroupPath.class, this.identityClass, null, "groupPath", "path");
        this.configureModelProperty(PropertyType.AGENT_LOGIN_NAME, LoginName.class, this.identityClass, null, "loginName", "login");
        this.configureModelProperty(PropertyType.USER_FIRST_NAME, FirstName.class, this.identityClass, null, false, "firstName");
        this.configureModelProperty(PropertyType.USER_LAST_NAME, LastName.class, this.identityClass, null, false, "lastName");
        this.configureModelProperty(PropertyType.USER_EMAIL, Email.class, this.identityClass, null, false, "email");
        this.configureAttributes();
    }

    private void configureAttributes() throws SecurityConfigurationException {
        if (this.attributeClass != null) {
            this.configureModelProperty(PropertyType.ATTRIBUTE_IDENTITY, Parent.class, this.attributeClass, this.identityClass, new String[0]);
            this.configureModelProperty(PropertyType.ATTRIBUTE_NAME, AttributeName.class, this.attributeClass, null, "attributeName", "name");
            this.configureModelProperty(PropertyType.ATTRIBUTE_TYPE, AttributeType.class, this.attributeClass, null, "attributeType", "type");
            this.configureModelProperty(PropertyType.ATTRIBUTE_VALUE, AttributeValue.class, this.attributeClass, null, "attributeValue", "value");
        }
        List props = PropertyQueries.createQuery(this.identityClass).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(IDMAttribute.class)).getResultList();
        for (Property p : props) {
            String attribName = p.getAnnotatedElement().getAnnotation(IDMAttribute.class).name();
            if (this.attributeProperties.containsKey(attribName)) {
                Property<Object> other = this.attributeProperties.get(attribName).getAttributeProperty();
                throw IDMMessages.MESSAGES.jpaConfigMultiplePropertiesForAttribute(attribName, other.getDeclaringClass(), other.getAnnotatedElement(), p.getDeclaringClass(), p.getAnnotatedElement());
            }
            this.attributeProperties.put(attribName, new MappedAttribute(null, (Property<Object>)p));
        }
    }

    private void configureCredentials() {
        if (this.credentialClass != null && this.credentialAttributeClass != null) {
            this.configureModelProperty(PropertyType.CREDENTIAL_TYPE, CredentialType.class, this.credentialClass, null, new String[0]);
            this.configureModelProperty(PropertyType.CREDENTIAL_VALUE, CredentialValue.class, this.credentialClass, null, new String[0]);
            this.configureModelProperty(PropertyType.CREDENTIAL_IDENTITY, Parent.class, this.credentialClass, null, new String[0]);
            this.configureModelProperty(PropertyType.CREDENTIAL_EFFECTIVE_DATE, EffectiveDate.class, this.credentialClass, null, new String[0]);
            this.configureModelProperty(PropertyType.CREDENTIAL_EXPIRY_DATE, ExpiryDate.class, this.credentialClass, null, new String[0]);
            this.configureModelProperty(PropertyType.CREDENTIAL_ATTRIBUTE_NAME, AttributeName.class, this.credentialAttributeClass, String.class, new String[0]);
            this.configureModelProperty(PropertyType.CREDENTIAL_ATTRIBUTE_VALUE, AttributeValue.class, this.credentialAttributeClass, null, new String[0]);
            this.configureModelProperty(PropertyType.CREDENTIAL_ATTRIBUTE_CREDENTIAL, Parent.class, this.credentialAttributeClass, this.credentialClass, new String[0]);
        } else {
            IDMLogger.LOGGER.jpaConfigDisablingCredentialFeatures();
            this.removeFeature(FeatureSet.FeatureGroup.credential);
        }
    }

    private void configurePartitions() {
        if (this.partitionClass != null) {
            this.configureModelProperty(PropertyType.PARTITION_ID, Identifier.class, this.partitionClass, null, "id", "id");
            this.configureModelProperty(PropertyType.PARTITION_TYPE, Discriminator.class, this.partitionClass, null, "type", "partitionType");
            this.configureModelProperty(PropertyType.PARTITION_PARENT, Parent.class, this.partitionClass, null, "parent");
        } else {
            IDMLogger.LOGGER.jpaConfigDisablingPartitionFeatures();
            this.removeFeature(FeatureSet.FeatureGroup.realm);
            this.removeFeature(FeatureSet.FeatureGroup.tier);
        }
    }

    private void configureRelationships() throws SecurityConfigurationException {
        if (this.relationshipClass != null && this.relationshipIdentityClass != null && this.relationshipAttributeClass != null) {
            this.configureModelProperty(PropertyType.RELATIONSHIP_ID, Identifier.class, this.relationshipClass, null, "id");
            this.configureModelProperty(PropertyType.RELATIONSHIP_CLASS, RelationshipClass.class, this.relationshipClass, null, "relationshipClass");
            this.configureModelProperty(PropertyType.RELATIONSHIP_IDENTITY, Identity.class, this.relationshipIdentityClass, null, "identityObject");
            this.configureModelProperty(PropertyType.RELATIONSHIP_DESCRIPTOR, RelationshipDescriptor.class, this.relationshipIdentityClass, null, "descriptor");
            this.configureModelProperty(PropertyType.RELATIONSHIP_IDENTITY_RELATIONSHIP, Parent.class, this.relationshipIdentityClass, this.relationshipClass, new String[0]);
            this.configureModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_NAME, AttributeName.class, this.relationshipAttributeClass, null, "attributeName", "name");
            this.configureModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_VALUE, AttributeValue.class, this.relationshipAttributeClass, null, "attributeValue", "value");
            this.configureModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_RELATIONSHIP, Parent.class, this.relationshipAttributeClass, null, new String[0]);
        } else {
            IDMLogger.LOGGER.jpaConfigDisablingRelationshipFeatures();
            this.removeFeature(FeatureSet.FeatureGroup.relationship);
        }
    }

    private void configureModelProperty(PropertyType propertyType, Class<? extends Annotation> annotationClass, Class<?> targetClass, Class<?> propertyClass, String ... possibleNames) {
        this.configureModelProperty(propertyType, annotationClass, targetClass, propertyClass, false, possibleNames);
    }

    private void configureModelProperty(PropertyType propertyType, Class<? extends Annotation> annotationClass, Class<?> targetClass, Class<?> propertyClass, boolean optional, String ... possibleNames) {
        List props;
        PropertyQuery query = PropertyQueries.createQuery(targetClass);
        if (annotationClass != null) {
            query.addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(annotationClass));
        }
        if (propertyClass != null) {
            query.addCriteria((PropertyCriteria)new TypedPropertyCriteria(propertyClass));
        }
        if ((props = query.getResultList()).size() == 1) {
            this.modelProperties.put(propertyType, (Property<Object>)props.get(0));
        } else {
            Property<Object> p;
            if (props.size() > 1) {
                throw IDMMessages.MESSAGES.jpaConfigAmbiguosPropertyForClass(annotationClass.getName(), targetClass);
            }
            if (possibleNames != null && possibleNames.length > 0 && (p = this.findNamedProperty(targetClass, possibleNames)) != null) {
                this.modelProperties.put(propertyType, p);
            }
            if (!optional) {
                throw new SecurityConfigurationException("Error configuring JPAIdentityStore - no " + annotationClass.getName() + " property found in identity class [" + targetClass.getName() + "]");
            }
        }
    }

    private Property<Object> findNamedProperty(Class<?> targetClass, String ... allowedNames) {
        List props = PropertyQueries.createQuery(targetClass).addCriteria((PropertyCriteria)new TypedPropertyCriteria(String.class)).addCriteria((PropertyCriteria)new NamedPropertyCriteria(allowedNames)).getResultList();
        for (String name : allowedNames) {
            for (Property prop : props) {
                if (!name.equals(prop.getName())) continue;
                return prop;
            }
        }
        return null;
    }

    private boolean isModelPropertySet(PropertyType propertyType) {
        return this.modelProperties.containsKey((Object)propertyType);
    }

    public class MappedAttribute {
        private Property<Object> identityProperty;
        private Property<Object> attributeProperty;

        public MappedAttribute(Property<Object> identityProperty, Property<Object> attributeProperty) {
            this.identityProperty = identityProperty;
            this.attributeProperty = attributeProperty;
        }

        public Property<Object> getIdentityProperty() {
            return this.identityProperty;
        }

        public Property<Object> getAttributeProperty() {
            return this.attributeProperty;
        }
    }

    public static enum PropertyType {
        IDENTITY_ID,
        IDENTITY_DISCRIMINATOR,
        GROUP_PATH,
        IDENTITY_NAME,
        IDENTITY_ENABLED,
        IDENTITY_CREATION_DATE,
        IDENTITY_EXPIRY_DATE,
        CREDENTIAL_VALUE,
        ATTRIBUTE_IDENTITY,
        ATTRIBUTE_NAME,
        ATTRIBUTE_TYPE,
        ATTRIBUTE_VALUE,
        GROUP_PARENT,
        AGENT_LOGIN_NAME,
        USER_FIRST_NAME,
        USER_LAST_NAME,
        USER_EMAIL,
        IDENTITY_PARTITION,
        PARTITION_ID,
        PARTITION_TYPE,
        PARTITION_PARENT,
        CREDENTIAL_IDENTITY,
        CREDENTIAL_TYPE,
        CREDENTIAL_EFFECTIVE_DATE,
        CREDENTIAL_EXPIRY_DATE,
        CREDENTIAL_ATTRIBUTE_CREDENTIAL,
        CREDENTIAL_ATTRIBUTE_NAME,
        CREDENTIAL_ATTRIBUTE_VALUE,
        RELATIONSHIP_ID,
        RELATIONSHIP_CLASS,
        RELATIONSHIP_IDENTITY,
        RELATIONSHIP_IDENTITY_RELATIONSHIP,
        RELATIONSHIP_DESCRIPTOR,
        RELATIONSHIP_ATTRIBUTE_NAME,
        RELATIONSHIP_ATTRIBUTE_VALUE,
        RELATIONSHIP_ATTRIBUTE_RELATIONSHIP;

    }
}

