/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.spi;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.spi.SecurityContext;

public interface IdentityStore<T extends IdentityStoreConfiguration> {
    public void setup(T var1);

    public T getConfig();

    public void add(SecurityContext var1, AttributedType var2);

    public void update(SecurityContext var1, AttributedType var2);

    public void remove(SecurityContext var1, AttributedType var2);

    public Agent getAgent(SecurityContext var1, String var2);

    public User getUser(SecurityContext var1, String var2);

    public Group getGroup(SecurityContext var1, String var2);

    public Group getGroup(SecurityContext var1, String var2, Group var3);

    public Role getRole(SecurityContext var1, String var2);

    public <V extends IdentityType> List<V> fetchQueryResults(SecurityContext var1, IdentityQuery<V> var2);

    public <V extends IdentityType> int countQueryResults(SecurityContext var1, IdentityQuery<V> var2);

    public <V extends Relationship> List<V> fetchQueryResults(SecurityContext var1, RelationshipQuery<V> var2);

    public <V extends Relationship> int countQueryResults(SecurityContext var1, RelationshipQuery<V> var2);

    public void setAttribute(SecurityContext var1, IdentityType var2, Attribute<? extends Serializable> var3);

    public <V extends Serializable> Attribute<V> getAttribute(SecurityContext var1, IdentityType var2, String var3);

    public void removeAttribute(SecurityContext var1, IdentityType var2, String var3);

    public void validateCredentials(SecurityContext var1, Credentials var2);

    public void updateCredential(SecurityContext var1, Agent var2, Object var3, Date var4, Date var5);
}

