/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.IDMLogger;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.spi.ContextInitializer;

public abstract class BaseAbstractStoreConfiguration
implements IdentityStoreConfiguration {
    private final Set<String> realms = new HashSet<String>();
    private final Set<String> tiers = new HashSet<String>();
    private List<ContextInitializer> contextInitializers = new ArrayList<ContextInitializer>();
    private Map<String, Object> credentialHandlerProperties = new HashMap<String, Object>();
    private List<Class<? extends CredentialHandler>> credentialHandlers = new ArrayList<Class<? extends CredentialHandler>>();
    private final Map<FeatureSet.FeatureGroup, Set<FeatureSet.FeatureOperation>> supportedFeatures;
    private final Map<Class<? extends Relationship>, Set<FeatureSet.FeatureOperation>> supportedRelationships;

    protected BaseAbstractStoreConfiguration(Map<FeatureSet.FeatureGroup, Set<FeatureSet.FeatureOperation>> supportedFeatures, Map<Class<? extends Relationship>, Set<FeatureSet.FeatureOperation>> supportedRelationships, Set<String> realms, Set<String> tiers, List<ContextInitializer> contextInitializers, Map<String, Object> credentialHandlerProperties, List<Class<? extends CredentialHandler>> credentialHandlers) {
        this.realms.addAll(realms);
        this.tiers.addAll(tiers);
        this.contextInitializers.addAll(contextInitializers);
        this.credentialHandlerProperties.putAll(credentialHandlerProperties);
        this.credentialHandlers.addAll(credentialHandlers);
        this.supportedFeatures = supportedFeatures;
        this.supportedRelationships = supportedRelationships;
    }

    @Override
    public final void init() throws SecurityConfigurationException {
        this.initConfig();
        if (IDMLogger.LOGGER.isDebugEnabled()) {
            IDMLogger.LOGGER.debugf("FeatureSet for %s", this);
            IDMLogger.LOGGER.debug("Features [");
            for (Map.Entry<FeatureSet.FeatureGroup, Set<FeatureSet.FeatureOperation>> entry : this.getSupportedFeatures().entrySet()) {
                IDMLogger.LOGGER.debugf("%s.%s", (Object)entry.getKey(), entry.getValue());
            }
            IDMLogger.LOGGER.debug("]");
            IDMLogger.LOGGER.debug("Relationships [");
            for (Map.Entry<Object, Set<FeatureSet.FeatureOperation>> entry : this.getSupportedRelationships().entrySet()) {
                IDMLogger.LOGGER.debugf("%s.%s", entry.getKey(), entry.getValue());
            }
            IDMLogger.LOGGER.debug("]");
        }
    }

    protected abstract void initConfig();

    @Override
    public List<ContextInitializer> getContextInitializers() {
        return Collections.unmodifiableList(this.contextInitializers);
    }

    @Override
    public List<Class<? extends CredentialHandler>> getCredentialHandlers() {
        return Collections.unmodifiableList(this.credentialHandlers);
    }

    @Override
    public Map<String, Object> getCredentialHandlerProperties() {
        return Collections.unmodifiableMap(this.credentialHandlerProperties);
    }

    @Override
    public boolean supportsFeature(FeatureSet.FeatureGroup feature, FeatureSet.FeatureOperation operation) {
        if (!this.supportedFeatures.containsKey((Object)feature)) {
            return false;
        }
        if (operation == null) {
            return true;
        }
        return this.supportedFeatures.get((Object)feature).contains((Object)operation);
    }

    @Override
    public boolean supportsRelationship(Class<? extends Relationship> relationshipType, FeatureSet.FeatureOperation operation) {
        if (!this.supportedRelationships.containsKey(relationshipType)) {
            return false;
        }
        if (operation == null) {
            return true;
        }
        return this.supportedRelationships.get(relationshipType).contains((Object)operation);
    }

    @Override
    public Set<String> getRealms() {
        return Collections.unmodifiableSet(this.realms);
    }

    @Override
    public Set<String> getTiers() {
        return Collections.unmodifiableSet(this.tiers);
    }

    @Override
    public Map<FeatureSet.FeatureGroup, Set<FeatureSet.FeatureOperation>> getSupportedFeatures() {
        return Collections.unmodifiableMap(this.supportedFeatures);
    }

    @Override
    public Map<Class<? extends Relationship>, Set<FeatureSet.FeatureOperation>> getSupportedRelationships() {
        return Collections.unmodifiableMap(this.supportedRelationships);
    }

    protected void removeFeature(FeatureSet.FeatureGroup feature) throws SecurityConfigurationException {
        this.supportedFeatures.remove((Object)feature);
        if (FeatureSet.FeatureGroup.relationship.equals((Object)feature)) {
            this.supportedRelationships.clear();
        }
    }
}

