/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.handler;

import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.credential.AbstractBaseCredentials;
import org.picketlink.idm.credential.handler.CredentialHandler;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.sample.Agent;
import org.picketlink.idm.model.sample.SampleModel;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.IdentityStore;

public abstract class AbstractCredentialHandler<S extends IdentityStore<?>, V extends AbstractBaseCredentials, U>
implements CredentialHandler<S, V, U> {
    protected <A extends Account> A getAccount(IdentityContext context, String loginName) {
        IdentityManager identityManager = this.getIdentityManager(context);
        Agent agent = SampleModel.getAgent(identityManager, loginName);
        if (agent == null) {
            agent = SampleModel.getUser(identityManager, loginName);
        }
        return (A)agent;
    }

    protected IdentityManager getIdentityManager(IdentityContext context) {
        IdentityManager identityManager = (IdentityManager)context.getParameter("IDENTITY_MANAGER_CTX_PARAMETER");
        if (identityManager == null) {
            throw new IdentityManagementException("IdentityManager not set into context.");
        }
        return identityManager;
    }
}

