/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.IdentityStoreConfigurationBuilder;
import org.picketlink.idm.config.IdentityStoresConfigurationBuilder;
import org.picketlink.idm.config.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.config.LDAPMappingConfiguration;
import org.picketlink.idm.config.LDAPMappingConfigurationBuilder;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Partition;

public class LDAPStoreConfigurationBuilder
extends IdentityStoreConfigurationBuilder<LDAPIdentityStoreConfiguration, LDAPStoreConfigurationBuilder> {
    private String url;
    private String baseDN;
    private String bindDN;
    private String bindCredential;
    private Set<LDAPMappingConfigurationBuilder> mappingBuilders = new HashSet<LDAPMappingConfigurationBuilder>();

    public LDAPStoreConfigurationBuilder(IdentityStoresConfigurationBuilder builder) {
        super(builder);
    }

    public LDAPStoreConfigurationBuilder url(String url) {
        this.url = url;
        return this;
    }

    public LDAPStoreConfigurationBuilder baseDN(String baseDN) {
        this.baseDN = baseDN;
        return this;
    }

    public LDAPStoreConfigurationBuilder bindDN(String bindDN) {
        this.bindDN = bindDN;
        return this;
    }

    public LDAPStoreConfigurationBuilder bindCredential(String bindCredential) {
        this.bindCredential = bindCredential;
        return this;
    }

    public LDAPMappingConfigurationBuilder mapping(Class<? extends AttributedType> attributedType) {
        LDAPMappingConfigurationBuilder ldapMappingConfigurationBuilder = new LDAPMappingConfigurationBuilder(attributedType, this);
        this.mappingBuilders.add(ldapMappingConfigurationBuilder);
        this.supportType(attributedType);
        return ldapMappingConfigurationBuilder;
    }

    @Override
    protected LDAPIdentityStoreConfiguration create() {
        HashMap<Class<? extends AttributedType>, LDAPMappingConfiguration> mappingConfig = new HashMap<Class<? extends AttributedType>, LDAPMappingConfiguration>();
        for (LDAPMappingConfigurationBuilder builder : this.mappingBuilders) {
            LDAPMappingConfiguration ldapMappingConfiguration = builder.create();
            mappingConfig.put(ldapMappingConfiguration.getMappedClass(), ldapMappingConfiguration);
        }
        return new LDAPIdentityStoreConfiguration(this.url, this.bindDN, this.bindCredential, this.baseDN, mappingConfig, this.getSupportedTypes(), this.getUnsupportedTypes(), this.getContextInitializers(), this.getCredentialHandlerProperties(), this.getCredentialHandlers());
    }

    @Override
    protected void validate() {
        super.validate();
        for (LDAPMappingConfigurationBuilder builder : this.mappingBuilders) {
            builder.validate();
        }
        this.unsupportType(Partition.class, new IdentityStoreConfiguration.IdentityOperation[0]);
    }

    protected LDAPStoreConfigurationBuilder readFrom(LDAPIdentityStoreConfiguration configuration) {
        super.readFrom(configuration);
        this.baseDN = configuration.getBaseDN();
        this.bindCredential = configuration.getBindCredential();
        this.bindDN = configuration.getBindDN();
        this.url = configuration.getLdapURL();
        for (Class<? extends AttributedType> attributedType : configuration.getMappingConfig().keySet()) {
            LDAPMappingConfiguration mappingConfiguration = configuration.getMappingConfig().get(attributedType);
            this.mapping(attributedType).readFrom(mappingConfiguration);
        }
        return this;
    }
}

