/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.picketlink.idm.config.Builder;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityConfigurationChildBuilder;
import org.picketlink.idm.config.NamedIdentityConfigurationBuilder;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.event.EventBridge;

public class IdentityConfigurationBuilder
extends Builder<List<IdentityConfiguration>>
implements IdentityConfigurationChildBuilder {
    private final Map<String, NamedIdentityConfigurationBuilder> namedIdentityConfigurationBuilders = new LinkedHashMap<String, NamedIdentityConfigurationBuilder>();
    private EventBridge eventBridge;

    public IdentityConfigurationBuilder() {
    }

    public IdentityConfigurationBuilder(List<IdentityConfiguration> configurations) throws SecurityConfigurationException {
        this();
        this.readFrom(configurations);
    }

    @Override
    public NamedIdentityConfigurationBuilder named(String configurationName) {
        if (this.namedIdentityConfigurationBuilders.containsKey(configurationName)) {
            return this.namedIdentityConfigurationBuilders.get(configurationName);
        }
        NamedIdentityConfigurationBuilder namedIdentityConfiguration = new NamedIdentityConfigurationBuilder(configurationName, this);
        this.namedIdentityConfigurationBuilders.put(configurationName, namedIdentityConfiguration);
        return namedIdentityConfiguration;
    }

    @Override
    public IdentityConfiguration build() throws SecurityConfigurationException {
        Object identityConfigurations = this.create();
        if (identityConfigurations.size() > 1) {
            throw new SecurityConfigurationException("You have provided more than one configuration. Use the buildAll method instead.");
        }
        return (IdentityConfiguration)identityConfigurations.get(0);
    }

    @Override
    public List<IdentityConfiguration> buildAll() throws SecurityConfigurationException {
        return this.create();
    }

    public boolean isConfigured() {
        return !this.namedIdentityConfigurationBuilders.isEmpty();
    }

    @Override
    protected void validate() throws SecurityConfigurationException {
        if (this.namedIdentityConfigurationBuilders.isEmpty()) {
            throw new SecurityConfigurationException("You must provide at least one configuration.");
        }
        for (NamedIdentityConfigurationBuilder identityConfigBuilder : this.namedIdentityConfigurationBuilders.values()) {
            identityConfigBuilder.validate();
        }
    }

    @Override
    protected List<IdentityConfiguration> create() throws SecurityConfigurationException {
        this.validate();
        ArrayList<IdentityConfiguration> configurations = new ArrayList<IdentityConfiguration>();
        for (NamedIdentityConfigurationBuilder identityConfigBuilder : this.namedIdentityConfigurationBuilders.values()) {
            IdentityConfiguration configuration = identityConfigBuilder.create();
            if (configurations.contains(configuration)) {
                throw new SecurityConfigurationException("Multiple configuration with the same name [" + configuration.getName() + "].");
            }
            configurations.add(configuration);
        }
        return configurations;
    }

    @Override
    protected Builder<List<IdentityConfiguration>> readFrom(List<IdentityConfiguration> fromConfiguration) throws SecurityConfigurationException {
        if (fromConfiguration == null || fromConfiguration.isEmpty()) {
            throw new SecurityConfigurationException("No configuration provided to read from.");
        }
        for (IdentityConfiguration identityConfiguration : fromConfiguration) {
            this.named(identityConfiguration.getName()).readFrom(identityConfiguration);
        }
        return this;
    }
}

