/*
 * JBoss, Home of Professional Open Source
 *
 * Copyright 2013 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.picketlink.idm.credential.handler.annotations;

import org.picketlink.idm.credential.storage.CredentialStorage;

import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;

/**
 * <p>This annotation is used to declare which credential types are supported by a
 * particular {@link org.picketlink.idm.credential.handler.CredentialHandler} implementation.</p>
 *
 * <p>It also declares the {@link CredentialStorage} supported by a particular {@link org.picketlink.idm.credential.handler.CredentialHandler}.</p>
 *
 * @author Shane Bryzak
 */
@Target({TYPE})
@Documented
@Retention(RUNTIME)
@Inherited
public @interface SupportsCredentials {

    interface NO_CREDENTIAL_STORAGE extends CredentialStorage {};

    /**
     * <p>Credential types supported by the handler.</p>
     *
     * @return
     */
    Class<?>[] credentialClass();

    /**
     * <p>Credential storage supported by the handler.</p>
     *
     * @return
     */
    Class<? extends CredentialStorage> credentialStorage();
}
