/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.handler;

import java.util.ArrayList;
import java.util.List;
import org.picketlink.idm.IDMLog;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.credential.AbstractBaseCredentials;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.handler.CredentialHandler;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.credential.util.CredentialUtils;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.basic.Agent;
import org.picketlink.idm.model.basic.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.IdentityStore;

public abstract class AbstractCredentialHandler<S extends IdentityStore<?>, V extends AbstractBaseCredentials, U>
implements CredentialHandler<S, V, U> {
    private static final String DEFAULT_ACCOUNT_LOGIN_PROPERTY_NAME = "loginName";
    private String defaultAccountLoginNameProperty = "loginName";
    private List<Class<? extends Account>> defaultAccountTypes;

    @Override
    public void setup(S store) {
        this.configureDefaultSupportedAccountTypes(store);
    }

    protected Account getAccount(IdentityContext context, String loginName) {
        IdentityManager identityManager = this.getIdentityManager(context);
        for (Class<Account> accountType : this.getDefaultAccountTypes()) {
            IdentityQuery<Account> query = identityManager.createIdentityQuery(accountType);
            String defaultAccountLoginNameProperty = this.defaultAccountLoginNameProperty;
            if (Agent.class.isAssignableFrom(accountType)) {
                defaultAccountLoginNameProperty = DEFAULT_ACCOUNT_LOGIN_PROPERTY_NAME;
            }
            if (this.isDebugEnabled()) {
                IDMLog.CREDENTIAL_LOGGER.credentialRetrievingAccount(loginName, accountType, defaultAccountLoginNameProperty);
            }
            query.setParameter(AttributedType.QUERY_ATTRIBUTE.byName(defaultAccountLoginNameProperty), loginName);
            List<Account> result = query.getResultList();
            if (result.size() == 1) {
                IdentityType account = result.get(0);
                if (!Account.class.isInstance(account)) {
                    throw IDMMessages.MESSAGES.credentialInvalidAccountType(account.getClass());
                }
                return (Account)account;
            }
            if (result.size() <= 1) continue;
            IDMLog.CREDENTIAL_LOGGER.errorf("Multiple Account objects found with the same login name [%s] for type [%s]: [%s]", defaultAccountLoginNameProperty, accountType, result);
            throw IDMMessages.MESSAGES.credentialMultipleAccountsFoundForType(defaultAccountLoginNameProperty, accountType);
        }
        return null;
    }

    @Override
    public void validate(IdentityContext context, V credentials, S store) {
        Account account;
        ((AbstractBaseCredentials)credentials).setStatus(Credentials.Status.IN_PROGRESS);
        if (this.isDebugEnabled()) {
            IDMLog.CREDENTIAL_LOGGER.debugf("Starting validation for credentials [%s][%s] using identity store [%s] and credential handler [%s].", new Object[]{credentials.getClass(), credentials, store, this});
        }
        if ((account = this.getAccount(context, credentials)) != null) {
            if (this.isDebugEnabled()) {
                IDMLog.CREDENTIAL_LOGGER.debugf("Found account [%s] from credentials [%s].", account, credentials);
            }
            if (account.isEnabled()) {
                if (this.isDebugEnabled()) {
                    IDMLog.CREDENTIAL_LOGGER.debugf("Account [%s] is ENABLED.", account, credentials);
                }
                CredentialStorage credentialStorage = this.getCredentialStorage(context, account, credentials, store);
                if (this.isDebugEnabled()) {
                    IDMLog.CREDENTIAL_LOGGER.debugf("Current credential storage for account [%s] is [%s].", account, credentialStorage);
                }
                if (this.validateCredential(credentialStorage, credentials)) {
                    if (credentialStorage != null && CredentialUtils.isCredentialExpired(credentialStorage)) {
                        ((AbstractBaseCredentials)credentials).setStatus(Credentials.Status.EXPIRED);
                    } else if (Credentials.Status.IN_PROGRESS.equals((Object)((AbstractBaseCredentials)credentials).getStatus())) {
                        ((AbstractBaseCredentials)credentials).setStatus(Credentials.Status.VALID);
                    }
                }
            } else {
                if (this.isDebugEnabled()) {
                    IDMLog.CREDENTIAL_LOGGER.debugf("Account [%s] is DISABLED.", account, credentials);
                }
                ((AbstractBaseCredentials)credentials).setStatus(Credentials.Status.ACCOUNT_DISABLED);
            }
        } else if (this.isDebugEnabled()) {
            IDMLog.CREDENTIAL_LOGGER.debugf("Account NOT FOUND for credentials [%s][%s].", credentials.getClass(), credentials);
        }
        ((AbstractBaseCredentials)credentials).setValidatedAccount(null);
        if (Credentials.Status.VALID.equals((Object)((AbstractBaseCredentials)credentials).getStatus())) {
            ((AbstractBaseCredentials)credentials).setValidatedAccount(account);
        } else if (Credentials.Status.IN_PROGRESS.equals((Object)((AbstractBaseCredentials)credentials).getStatus())) {
            ((AbstractBaseCredentials)credentials).setStatus(Credentials.Status.INVALID);
        }
        if (this.isDebugEnabled()) {
            IDMLog.CREDENTIAL_LOGGER.debugf("Finishing validation for credential [%s][%s] validated using identity store [%s] and credential handler [%s]. Status [%s]. Validated Account [%s]", new Object[]{credentials.getClass(), credentials, store, this, ((AbstractBaseCredentials)credentials).getStatus(), ((AbstractBaseCredentials)credentials).getValidatedAccount()});
        }
    }

    protected abstract boolean validateCredential(CredentialStorage var1, V var2);

    protected abstract Account getAccount(IdentityContext var1, V var2);

    protected abstract CredentialStorage getCredentialStorage(IdentityContext var1, Account var2, V var3, S var4);

    protected IdentityManager getIdentityManager(IdentityContext context) {
        IdentityManager identityManager = (IdentityManager)context.getParameter("IDENTITY_MANAGER_CTX_PARAMETER");
        if (identityManager == null) {
            throw new IdentityManagementException("IdentityManager not set into context.");
        }
        return identityManager;
    }

    private void configureDefaultSupportedAccountTypes(S store) {
        String defaultAccountLoginNameOption;
        this.defaultAccountTypes = new ArrayList<Class<? extends Account>>();
        Object accountTypesOption = store.getConfig().getCredentialHandlerProperties().get("SUPPORTED_ACCOUNT_TYPES");
        if (accountTypesOption != null) {
            if (accountTypesOption.getClass().isArray()) {
                Class[] defaultAccountTypes;
                for (Class accountType : defaultAccountTypes = (Class[])accountTypesOption) {
                    this.defaultAccountTypes.add(accountType);
                }
            } else {
                this.defaultAccountTypes.add((Class)accountTypesOption);
            }
        }
        if (!this.defaultAccountTypes.contains(User.class)) {
            this.defaultAccountTypes.add(User.class);
        }
        if (!this.defaultAccountTypes.contains(Agent.class)) {
            this.defaultAccountTypes.add(Agent.class);
        }
        if ((defaultAccountLoginNameOption = (String)store.getConfig().getCredentialHandlerProperties().get("LOGIN_NAME_PROPERTY")) != null) {
            this.defaultAccountLoginNameProperty = defaultAccountLoginNameOption;
        }
    }

    private List<Class<? extends Account>> getDefaultAccountTypes() {
        if (this.defaultAccountTypes.isEmpty()) {
            throw new IdentityManagementException("No default Account types defined.");
        }
        return this.defaultAccountTypes;
    }

    protected boolean isDebugEnabled() {
        return IDMLog.CREDENTIAL_LOGGER.isDebugEnabled();
    }
}

