/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.encoder;

import org.picketlink.idm.credential.encoder.PasswordEncoder;
import org.picketlink.idm.credential.util.BCrypt;

public class BCryptPasswordEncoder
implements PasswordEncoder {
    int logRounds = 12;

    public BCryptPasswordEncoder(int logRounds) {
        this.logRounds = logRounds;
    }

    @Override
    public String encode(String rawPassword) {
        return BCrypt.hashpw(rawPassword, BCrypt.gensalt(this.logRounds));
    }

    @Override
    public boolean verify(String rawPassword, String encodedPassword) {
        return BCrypt.checkpw(rawPassword, encodedPassword);
    }
}

