/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.config.AbstractIdentityConfigurationChildBuilder;
import org.picketlink.idm.config.Builder;
import org.picketlink.idm.config.FileStoreConfigurationBuilder;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.IdentityStoreConfigurationChildBuilder;
import org.picketlink.idm.config.IdentityStoresConfigurationBuilder;
import org.picketlink.idm.config.JPAStoreConfigurationBuilder;
import org.picketlink.idm.config.LDAPStoreConfigurationBuilder;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.credential.handler.CredentialHandler;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.basic.Agent;
import org.picketlink.idm.model.basic.Grant;
import org.picketlink.idm.model.basic.Group;
import org.picketlink.idm.model.basic.GroupMembership;
import org.picketlink.idm.model.basic.GroupRole;
import org.picketlink.idm.model.basic.Realm;
import org.picketlink.idm.model.basic.Role;
import org.picketlink.idm.model.basic.User;
import org.picketlink.idm.spi.ContextInitializer;

public abstract class IdentityStoreConfigurationBuilder<T extends IdentityStoreConfiguration, S extends IdentityStoreConfigurationBuilder<T, S>>
extends AbstractIdentityConfigurationChildBuilder<T>
implements IdentityStoreConfigurationChildBuilder {
    private final Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> supportedTypes = new HashMap<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>>();
    private final Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> unsupportedTypes = new HashMap<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>>();
    private final Set<Class<? extends Relationship>> globalRelationshipTypes = new HashSet<Class<? extends Relationship>>();
    private final Set<Class<? extends Relationship>> selfRelationshipTypes = new HashSet<Class<? extends Relationship>>();
    private final Set<Class<? extends CredentialHandler>> credentialHandlers = new HashSet<Class<? extends CredentialHandler>>();
    private final Map<String, Object> credentialHandlerProperties = new HashMap<String, Object>();
    private final List<ContextInitializer> contextInitializers = new ArrayList<ContextInitializer>();
    private final IdentityStoresConfigurationBuilder identityStoresConfigurationBuilder;
    private boolean supportCredentials;
    private boolean supportAttributes;
    private boolean supportPermissions;

    protected IdentityStoreConfigurationBuilder(IdentityStoresConfigurationBuilder builder) {
        super(builder);
        this.identityStoresConfigurationBuilder = builder;
    }

    @Override
    public FileStoreConfigurationBuilder file() {
        return this.identityStoresConfigurationBuilder.file();
    }

    @Override
    public JPAStoreConfigurationBuilder jpa() {
        return this.identityStoresConfigurationBuilder.jpa();
    }

    @Override
    public LDAPStoreConfigurationBuilder ldap() {
        return this.identityStoresConfigurationBuilder.ldap();
    }

    public S supportType(Class<? extends AttributedType> ... attributedTypes) {
        if (attributedTypes == null) {
            throw IDMMessages.MESSAGES.nullArgument("Attributed Types");
        }
        for (Class<? extends AttributedType> attributedType : attributedTypes) {
            if (this.supportedTypes.containsKey(attributedType)) continue;
            List<IdentityStoreConfiguration.IdentityOperation> defaultTypeOperations = Arrays.asList(IdentityStoreConfiguration.IdentityOperation.values());
            HashSet<IdentityStoreConfiguration.IdentityOperation> supportedOperations = new HashSet<IdentityStoreConfiguration.IdentityOperation>(defaultTypeOperations);
            this.supportedTypes.put(attributedType, supportedOperations);
        }
        return (S)this;
    }

    public S unsupportType(Class<? extends AttributedType> type, IdentityStoreConfiguration.IdentityOperation ... operations) {
        if (!this.unsupportedTypes.containsKey(type)) {
            this.unsupportedTypes.put(type, new HashSet());
        }
        if (operations != null && operations.length == 0) {
            operations = IdentityStoreConfiguration.IdentityOperation.values();
        }
        for (IdentityStoreConfiguration.IdentityOperation op : operations) {
            this.unsupportedTypes.get(type).add(op);
        }
        return (S)this;
    }

    public S supportGlobalRelationship(Class<? extends Relationship> ... types) {
        this.globalRelationshipTypes.addAll(Arrays.asList(types));
        this.supportType(types);
        return (S)this;
    }

    public S supportSelfRelationship(Class<? extends Relationship> ... types) {
        this.selfRelationshipTypes.addAll(Arrays.asList(types));
        this.supportType(types);
        return (S)this;
    }

    public S supportAllFeatures() {
        this.supportType(IdentityStoreConfigurationBuilder.getDefaultIdentityModelClasses());
        this.supportCredentials(true);
        this.supportGlobalRelationship(Relationship.class);
        this.supportGlobalRelationship(Grant.class);
        this.supportGlobalRelationship(GroupMembership.class);
        this.supportGlobalRelationship(GroupRole.class);
        this.supportAttributes(true);
        this.supportPermissions(true);
        return (S)this;
    }

    public S addContextInitializer(ContextInitializer contextInitializer) {
        this.contextInitializers.add(contextInitializer);
        return (S)this;
    }

    public S setCredentialHandlerProperty(String propertyName, Object value) {
        this.credentialHandlerProperties.put(propertyName, value);
        return (S)this;
    }

    public S addCredentialHandler(Class<? extends CredentialHandler> credentialHandler) {
        this.credentialHandlers.add(credentialHandler);
        return (S)this;
    }

    public S supportCredentials(boolean supportCredentials) {
        this.supportCredentials = supportCredentials;
        return (S)this;
    }

    public S supportPermissions(boolean supportPermissions) {
        this.supportPermissions = supportPermissions;
        return (S)this;
    }

    public S supportAttributes(boolean supportAttributes) {
        this.supportAttributes = supportAttributes;
        return (S)this;
    }

    @Override
    protected void validate() {
        if (this.supportedTypes.isEmpty()) {
            throw new SecurityConfigurationException("The store configuration must have at least one supported type.");
        }
    }

    @Override
    protected Builder<T> readFrom(T configuration) {
        for (Class<? extends CredentialHandler> clazz : configuration.getCredentialHandlers()) {
            this.addCredentialHandler(clazz);
        }
        for (String string : configuration.getCredentialHandlerProperties().keySet()) {
            Object value = configuration.getCredentialHandlerProperties().get(string);
            this.setCredentialHandlerProperty(string, value);
        }
        for (Class clazz : configuration.getSupportedTypes().keySet()) {
            this.supportType(clazz);
            if (!Relationship.class.isAssignableFrom(clazz)) continue;
            this.supportGlobalRelationship(clazz);
        }
        for (Class clazz : configuration.getUnsupportedTypes().keySet()) {
            this.unsupportType(clazz, new IdentityStoreConfiguration.IdentityOperation[0]);
        }
        for (ContextInitializer contextInitializer : configuration.getContextInitializers()) {
            this.addContextInitializer(contextInitializer);
        }
        this.supportAttributes(configuration.supportsAttribute());
        this.supportCredentials(configuration.supportsCredential());
        this.supportPermissions(configuration.supportsPermissions());
        return this;
    }

    protected List<ContextInitializer> getContextInitializers() {
        return Collections.unmodifiableList(this.contextInitializers);
    }

    protected Map<String, Object> getCredentialHandlerProperties() {
        return Collections.unmodifiableMap(this.credentialHandlerProperties);
    }

    protected Set<Class<? extends CredentialHandler>> getCredentialHandlers() {
        return Collections.unmodifiableSet(this.credentialHandlers);
    }

    protected Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> getSupportedTypes() {
        return Collections.unmodifiableMap(this.supportedTypes);
    }

    protected Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> getUnsupportedTypes() {
        return Collections.unmodifiableMap(this.unsupportedTypes);
    }

    protected Set<Class<? extends Relationship>> getGlobalRelationshipTypes() {
        return this.globalRelationshipTypes;
    }

    protected Set<Class<? extends Relationship>> getSelfRelationshipTypes() {
        return this.selfRelationshipTypes;
    }

    protected boolean isSupportAttributes() {
        return this.supportAttributes;
    }

    protected boolean isSupportCredentials() {
        return this.supportCredentials;
    }

    protected boolean isSupportPermissions() {
        return this.supportPermissions;
    }

    private static Class<? extends AttributedType>[] getDefaultIdentityModelClasses() {
        ArrayList<Class<Realm>> classes = new ArrayList<Class<Realm>>();
        classes.add(IdentityType.class);
        classes.add(User.class);
        classes.add(Agent.class);
        classes.add(Role.class);
        classes.add(Group.class);
        classes.add(Partition.class);
        classes.add(Realm.class);
        return classes.toArray(new Class[classes.size()]);
    }

    public <U extends IdentityStoreConfigurationBuilder<?, ?>> U add(Class<? extends IdentityStoreConfiguration> identityStoreConfiguration, Class<U> builder) {
        return this.identityStoresConfigurationBuilder.add(identityStoreConfiguration, builder);
    }
}

