/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.handler;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.idm.IDMLog;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.credential.AbstractBaseCredentials;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.handler.CredentialHandler;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.credential.util.CredentialUtils;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.annotation.StereotypeProperty;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityContext;

public abstract class AbstractCredentialHandler<S extends CredentialStore<?>, V extends AbstractBaseCredentials, U>
implements CredentialHandler<S, V, U> {
    private List<Class<? extends Account>> defaultAccountTypes;

    @Override
    public void setup(S store) {
        this.configureDefaultSupportedAccountTypes(store);
    }

    protected Account getAccount(IdentityContext context, String userName) {
        if (userName == null) {
            return null;
        }
        IdentityManager identityManager = this.getIdentityManager(context);
        for (Class<Account> accountType : this.getDefaultAccountTypes()) {
            IdentityQuery<Account> query = identityManager.createIdentityQuery(accountType);
            query.setParameter(Account.PARTITION, context.getPartition());
            String loginNameProperty = this.getDefaultLoginNameProperty(accountType).getName();
            if (this.isDebugEnabled()) {
                IDMLog.CREDENTIAL_LOGGER.credentialRetrievingAccount(userName, accountType, loginNameProperty);
            }
            query.setParameter(AttributedType.QUERY_ATTRIBUTE.byName(loginNameProperty), userName);
            List<Account> result = query.getResultList();
            if (result.size() == 1) {
                IdentityType account = result.get(0);
                if (!Account.class.isInstance(account)) {
                    throw IDMMessages.MESSAGES.credentialInvalidAccountType(account.getClass());
                }
                return (Account)account;
            }
            if (result.size() <= 1) continue;
            IDMLog.CREDENTIAL_LOGGER.errorf("Multiple Account objects found with the same login name [%s] for type [%s]: [%s]", loginNameProperty, accountType, result);
            throw IDMMessages.MESSAGES.credentialMultipleAccountsFoundForType(loginNameProperty, accountType);
        }
        return null;
    }

    protected Account getAccountById(IdentityContext context, String identifier) {
        if (identifier == null) {
            return null;
        }
        IdentityManager identityManager = this.getIdentityManager(context);
        for (Class<Account> accountType : this.getDefaultAccountTypes()) {
            IdentityQuery<Account> query = identityManager.createIdentityQuery(accountType);
            query.setParameter(Account.PARTITION, context.getPartition());
            if (this.isDebugEnabled()) {
                IDMLog.CREDENTIAL_LOGGER.credentialRetrievingAccount(identifier, accountType, "ID");
            }
            query.setParameter(Account.ID, identifier);
            List<Account> result = query.getResultList();
            if (result.size() == 1) {
                IdentityType account = result.get(0);
                if (!Account.class.isInstance(account)) {
                    throw IDMMessages.MESSAGES.credentialInvalidAccountType(account.getClass());
                }
                return (Account)account;
            }
            if (result.size() <= 1) continue;
            IDMLog.CREDENTIAL_LOGGER.errorf("Multiple Account objects found with the same login name [%s] for type [%s]: [%s]", "ID", accountType, result);
            throw IDMMessages.MESSAGES.credentialMultipleAccountsFoundForType("ID", accountType);
        }
        return null;
    }

    @Override
    public void validate(IdentityContext context, V credentials, S store) {
        Account account;
        ((AbstractBaseCredentials)credentials).setStatus(Credentials.Status.IN_PROGRESS);
        if (this.isDebugEnabled()) {
            IDMLog.CREDENTIAL_LOGGER.debugf("Starting validation for credentials [%s][%s] using identity store [%s] and credential handler [%s].", new Object[]{credentials.getClass(), credentials, store, this});
        }
        if ((account = this.getAccount(context, credentials)) != null) {
            if (this.isDebugEnabled()) {
                IDMLog.CREDENTIAL_LOGGER.debugf("Found account [%s] from credentials [%s].", account, credentials);
            }
            if (account.isEnabled()) {
                if (this.isDebugEnabled()) {
                    IDMLog.CREDENTIAL_LOGGER.debugf("Account [%s] is ENABLED.", account, credentials);
                }
                CredentialStorage credentialStorage = this.getCredentialStorage(context, account, credentials, store);
                if (this.isDebugEnabled()) {
                    IDMLog.CREDENTIAL_LOGGER.debugf("Current credential storage for account [%s] is [%s].", account, credentialStorage);
                }
                if (this.validateCredential(context, credentialStorage, credentials, store)) {
                    if (credentialStorage != null && CredentialUtils.isCredentialExpired(credentialStorage)) {
                        ((AbstractBaseCredentials)credentials).setStatus(Credentials.Status.EXPIRED);
                    } else if (Credentials.Status.IN_PROGRESS.equals((Object)((AbstractBaseCredentials)credentials).getStatus())) {
                        ((AbstractBaseCredentials)credentials).setStatus(Credentials.Status.VALID);
                    }
                }
            } else {
                if (this.isDebugEnabled()) {
                    IDMLog.CREDENTIAL_LOGGER.debugf("Account [%s] is DISABLED.", account, credentials);
                }
                ((AbstractBaseCredentials)credentials).setStatus(Credentials.Status.ACCOUNT_DISABLED);
            }
        } else if (this.isDebugEnabled()) {
            IDMLog.CREDENTIAL_LOGGER.debugf("Account NOT FOUND for credentials [%s][%s].", credentials.getClass(), credentials);
        }
        ((AbstractBaseCredentials)credentials).setValidatedAccount(null);
        if (Credentials.Status.VALID.equals((Object)((AbstractBaseCredentials)credentials).getStatus())) {
            ((AbstractBaseCredentials)credentials).setValidatedAccount(account);
        } else if (Credentials.Status.IN_PROGRESS.equals((Object)((AbstractBaseCredentials)credentials).getStatus())) {
            ((AbstractBaseCredentials)credentials).setStatus(Credentials.Status.INVALID);
        }
        if (this.isDebugEnabled()) {
            IDMLog.CREDENTIAL_LOGGER.debugf("Finishing validation for credential [%s][%s] validated using identity store [%s] and credential handler [%s]. Status [%s]. Validated Account [%s]", new Object[]{credentials.getClass(), credentials, store, this, ((AbstractBaseCredentials)credentials).getStatus(), ((AbstractBaseCredentials)credentials).getValidatedAccount()});
        }
    }

    @Override
    public void update(IdentityContext context, Account account, U password, S store, Date effectiveDate, Date expiryDate) {
        CredentialStorage storage = this.createCredentialStorage(context, account, password, store, effectiveDate, expiryDate);
        if (storage == null) {
            throw new IdentityManagementException("CredentialStorage returned by handler [" + this + "is null.");
        }
        store.removeCredential(context, account, storage.getClass());
        store.storeCredential(context, account, storage);
    }

    protected abstract CredentialStorage createCredentialStorage(IdentityContext var1, Account var2, U var3, S var4, Date var5, Date var6);

    protected abstract boolean validateCredential(IdentityContext var1, CredentialStorage var2, V var3, S var4);

    protected abstract Account getAccount(IdentityContext var1, V var2);

    protected abstract CredentialStorage getCredentialStorage(IdentityContext var1, Account var2, V var3, S var4);

    protected IdentityManager getIdentityManager(IdentityContext context) {
        IdentityManager identityManager = (IdentityManager)context.getParameter("IDENTITY_MANAGER_CTX_PARAMETER");
        if (identityManager == null) {
            throw new IdentityManagementException("IdentityManager not set into context.");
        }
        return identityManager;
    }

    private void configureDefaultSupportedAccountTypes(S store) {
        this.defaultAccountTypes = new ArrayList<Class<? extends Account>>();
        for (Class<? extends AttributedType> supportedType : store.getConfig().getSupportedTypes().keySet()) {
            if (Account.class.equals(supportedType) || !Account.class.isAssignableFrom(supportedType)) continue;
            this.defaultAccountTypes.add(supportedType);
        }
        if (this.defaultAccountTypes.isEmpty()) {
            throw IDMMessages.MESSAGES.credentialNoAccountTypeProvided();
        }
    }

    private List<Class<? extends Account>> getDefaultAccountTypes() {
        if (this.defaultAccountTypes.isEmpty()) {
            throw new IdentityManagementException("No default Account types defined.");
        }
        return this.defaultAccountTypes;
    }

    protected boolean isDebugEnabled() {
        return IDMLog.CREDENTIAL_LOGGER.isDebugEnabled();
    }

    protected Property getDefaultLoginNameProperty(Class<? extends Account> accountType) {
        List properties = PropertyQueries.createQuery(accountType).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(StereotypeProperty.class)).getResultList();
        for (Property property : properties) {
            StereotypeProperty stereotypeProperty = property.getAnnotatedElement().getAnnotation(StereotypeProperty.class);
            if (!StereotypeProperty.Property.IDENTITY_USER_NAME.equals((Object)stereotypeProperty.value())) continue;
            return property;
        }
        throw IDMMessages.MESSAGES.credentialUnknownUserNameProperty(accountType);
    }
}

