/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.util.HashSet;
import java.util.Set;
import org.picketlink.idm.config.BaseAbstractStoreConfiguration;
import org.picketlink.idm.config.StoreConfiguration;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.model.Relationship;

public abstract class IdentityStoreConfiguration
extends BaseAbstractStoreConfiguration
implements StoreConfiguration {
    private FeatureSet featureSet;
    private String realm;
    private final Set<Class<? extends CredentialHandler>> supportedCredentialHandlers = new HashSet<Class<? extends CredentialHandler>>();

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public FeatureSet getFeatureSet() {
        return this.featureSet;
    }

    public Set<Class<? extends CredentialHandler>> getSupportedCredentialHandlers() {
        return this.supportedCredentialHandlers;
    }

    public class FeatureSet {
        private final Set<Feature> supportedFeatures = new HashSet<Feature>();
        private final Set<Class<? extends Relationship>> supportedRelationships = new HashSet<Class<? extends Relationship>>();

        public void addSupportedFeature(Feature feature) {
            this.supportedFeatures.add(feature);
        }

        public boolean supports(Feature feature) {
            return this.supportedFeatures.contains((Object)feature);
        }

        public void addSupportedRelationship(Class<? extends Relationship> relationshipClass) {
            this.supportedRelationships.add(relationshipClass);
        }

        public boolean supportsRelationship(Class<? extends Relationship> relationshipClass) {
            for (Class<? extends Relationship> cls : this.supportedRelationships) {
                if (!cls.isAssignableFrom(relationshipClass)) continue;
                return true;
            }
            return false;
        }
    }

    public static enum Feature {
        createUser,
        readUser,
        updateUser,
        deleteUser,
        createGroup,
        readGroup,
        updateGroup,
        deleteGroup,
        createRole,
        readRole,
        updateRole,
        deleteRole,
        createRelationship,
        readRelationship,
        updateRelationship,
        deleteRelationship,
        readAttribute,
        updateAttribute,
        deleteAttribute,
        manageCredentials,
        supportsTiers,
        supportsRealms,
        disableRole,
        disableGroup,
        disableUser,
        createAgent,
        updateAgent,
        deleteAgent,
        readAgent,
        managePartitions,
        all;

    }
}

