/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm;

import java.io.Serializable;
import java.util.Date;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.Tier;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.spi.IdentityStoreInvocationContextFactory;
import org.picketlink.idm.spi.StoreFactory;

public interface IdentityManager
extends Serializable {
    public void bootstrap(IdentityConfiguration var1, IdentityStoreInvocationContextFactory var2);

    public void setIdentityStoreFactory(StoreFactory var1);

    public void add(IdentityType var1);

    public void update(IdentityType var1);

    public void remove(IdentityType var1);

    public Agent getAgent(String var1);

    public User getUser(String var1);

    public Group getGroup(String var1);

    public Group getGroup(String var1, Group var2);

    public boolean isMember(IdentityType var1, Group var2);

    public void addToGroup(IdentityType var1, Group var2);

    public void removeFromGroup(IdentityType var1, Group var2);

    public Role getRole(String var1);

    public boolean hasGroupRole(IdentityType var1, Role var2, Group var3);

    public void grantGroupRole(IdentityType var1, Role var2, Group var3);

    public void revokeGroupRole(IdentityType var1, Role var2, Group var3);

    public boolean hasRole(IdentityType var1, Role var2);

    public void grantRole(IdentityType var1, Role var2);

    public void revokeRole(IdentityType var1, Role var2);

    public <T extends IdentityType> IdentityQuery<T> createQuery(Class<T> var1);

    public void validateCredentials(Credentials var1);

    public void updateCredential(Agent var1, Object var2);

    public void updateCredential(Agent var1, Object var2, Date var3, Date var4);

    public IdentityType lookupIdentityByKey(String var1);

    public void loadAttribute(IdentityType var1, String var2);

    public void createRealm(Realm var1);

    public void removeRealm(Realm var1);

    public Realm getRealm(String var1);

    public void createTier(Tier var1);

    public void removeTier(Tier var1);

    public Tier getTier(String var1);

    public IdentityManager forRealm(Realm var1);

    public IdentityManager forTier(Tier var1);
}

