/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.spi;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;

public interface IdentityStore<T extends IdentityStoreConfiguration> {
    public void setup(T var1, IdentityStoreInvocationContext var2);

    public T getConfig();

    public IdentityStoreInvocationContext getContext();

    public void add(IdentityType var1);

    public void update(IdentityType var1);

    public void remove(IdentityType var1);

    public Agent getAgent(String var1);

    public User getUser(String var1);

    public Group getGroup(String var1);

    public Group getGroup(String var1, Group var2);

    public Role getRole(String var1);

    public GroupRole createMembership(IdentityType var1, Group var2, Role var3);

    public void removeMembership(IdentityType var1, Group var2, Role var3);

    public GroupRole getMembership(IdentityType var1, Group var2, Role var3);

    public <T extends IdentityType> List<T> fetchQueryResults(IdentityQuery<T> var1);

    public <T extends IdentityType> int countQueryResults(IdentityQuery<T> var1);

    public void setAttribute(IdentityType var1, Attribute<? extends Serializable> var2);

    public <T extends Serializable> Attribute<T> getAttribute(IdentityType var1, String var2);

    public void removeAttribute(IdentityType var1, String var2);

    public void validateCredentials(Credentials var1);

    public void updateCredential(Agent var1, Object var2, Date var3, Date var4);

    public static enum Feature {
        createUser,
        readUser,
        updateUser,
        deleteUser,
        createGroup,
        readGroup,
        updateGroup,
        deleteGroup,
        createRole,
        readRole,
        updateRole,
        deleteRole,
        createMembership,
        readMembership,
        updateMembership,
        deleteMembership,
        readAttribute,
        updateAttribute,
        deleteAttribute,
        manageCredentials,
        supportsTiers,
        supportsRealms,
        disableRole,
        disableGroup,
        disableUser,
        createAgent,
        all,
        updateAgent,
        deleteAgent,
        readAgent;

    }
}

