/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.spi;

import java.util.HashMap;
import java.util.Map;
import org.picketlink.idm.IdGenerator;
import org.picketlink.idm.IdentityCache;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.CredentialHandlerFactory;
import org.picketlink.idm.event.EventBridge;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.spi.IdentityStore;

public class SecurityContext {
    private IdentityCache cache;
    private EventBridge eventBridge;
    private Partition partition;
    private CredentialHandlerFactory credentialHandlerFactory;
    private IdGenerator idGenerator;
    private IdentityManager identityManager;
    private Map<String, Object> parameters = new HashMap<String, Object>();

    public SecurityContext(IdentityCache cache, EventBridge eventBridge, CredentialHandlerFactory factory, IdGenerator idGenerator, Partition partition) {
        this.cache = cache;
        this.eventBridge = eventBridge;
        this.credentialHandlerFactory = factory;
        this.idGenerator = idGenerator;
        this.partition = partition;
    }

    public CredentialHandler getCredentialValidator(Class<? extends Credentials> credentialsClass, IdentityStore identityStore) {
        return this.credentialHandlerFactory.getCredentialValidator(credentialsClass, identityStore.getClass());
    }

    public CredentialHandler getCredentialUpdater(Class<?> credentialClass, IdentityStore identityStore) {
        return this.credentialHandlerFactory.getCredentialUpdater(credentialClass, identityStore.getClass());
    }

    public IdentityCache getCache() {
        return this.cache;
    }

    public Object getParameter(String paramName) {
        return this.parameters.get(paramName);
    }

    public boolean isParameterSet(String paramName) {
        return this.parameters.containsKey(paramName);
    }

    public void setParameter(String paramName, Object value) {
        this.parameters.put(paramName, value);
    }

    public EventBridge getEventBridge() {
        return this.eventBridge;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public void setIdentityManager(IdentityManager identityManager) {
        this.identityManager = identityManager;
    }

    public IdentityManager getIdentityManager() {
        return this.identityManager;
    }
}

