/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm;

import java.io.Serializable;
import java.util.Date;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.RelationshipQuery;

public interface IdentityManager
extends Serializable {
    public void add(IdentityType var1) throws IdentityManagementException;

    public void update(IdentityType var1) throws IdentityManagementException;

    public void remove(IdentityType var1) throws IdentityManagementException;

    public void add(Relationship var1) throws IdentityManagementException;

    public void update(Relationship var1);

    public void remove(Relationship var1);

    public Agent getAgent(String var1) throws IdentityManagementException;

    public User getUser(String var1);

    public Role getRole(String var1);

    public Group getGroup(String var1);

    public Group getGroup(String var1, Group var2);

    public boolean isMember(IdentityType var1, Group var2);

    public void addToGroup(Agent var1, Group var2);

    public void removeFromGroup(Agent var1, Group var2);

    public boolean hasGroupRole(IdentityType var1, Role var2, Group var3);

    public void grantGroupRole(IdentityType var1, Role var2, Group var3);

    public void revokeGroupRole(IdentityType var1, Role var2, Group var3);

    public boolean hasRole(IdentityType var1, Role var2);

    public void grantRole(IdentityType var1, Role var2);

    public void revokeRole(IdentityType var1, Role var2);

    public <T extends IdentityType> T lookupIdentityById(Class<T> var1, String var2);

    public <T extends IdentityType> IdentityQuery<T> createIdentityQuery(Class<T> var1);

    public <T extends Relationship> RelationshipQuery<T> createRelationshipQuery(Class<T> var1);

    public void validateCredentials(Credentials var1);

    public void updateCredential(Agent var1, Object var2);

    public void updateCredential(Agent var1, Object var2, Date var3, Date var4);

    public void loadAttribute(IdentityType var1, String var2);
}

