/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential;

import java.io.IOException;
import java.io.StringReader;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Properties;
import org.picketlink.idm.credential.AbstractBaseCredentials;
import org.picketlink.idm.credential.Credentials;

public class X509CertificateCredentials
extends AbstractBaseCredentials
implements Credentials {
    private X509Certificate certificate;
    private String userName;

    public X509CertificateCredentials(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public String getUsername() {
        if (this.userName == null) {
            Properties prop = new Properties();
            this.userName = this.getCertificatePrincipal().getName();
            try {
                prop.load(new StringReader(this.userName.replaceAll(",", "\n")));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.userName = prop.getProperty("CN");
        }
        return this.userName;
    }

    public X509CertificateCredentials setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    @Override
    public void invalidate() {
        this.certificate = null;
    }

    private Principal getCertificatePrincipal() {
        Principal certprincipal = this.certificate.getSubjectDN();
        if (certprincipal == null) {
            certprincipal = this.certificate.getIssuerDN();
        }
        return certprincipal;
    }
}

