/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.internal;

import java.util.Date;
import java.util.List;
import javax.enterprise.inject.Typed;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.spi.CredentialStorage;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.RelationshipQuery;

@Typed(value={SecuredIdentityManager.class})
public class SecuredIdentityManager
implements IdentityManager {
    private static final long serialVersionUID = -8197103563768366958L;
    private IdentityManager decorated;

    public SecuredIdentityManager(IdentityManager decorated) {
        this.decorated = decorated;
    }

    public void add(IdentityType value) {
        this.decorated.add(value);
    }

    public void update(IdentityType value) {
        this.decorated.update(value);
    }

    public void remove(IdentityType value) {
        this.decorated.remove(value);
    }

    public void add(Relationship value) {
        this.decorated.add(value);
    }

    public void update(Relationship value) {
        this.decorated.update(value);
    }

    public void remove(Relationship value) {
        this.decorated.remove(value);
    }

    public Agent getAgent(String loginName) {
        return this.decorated.getAgent(loginName);
    }

    public User getUser(String id) {
        return this.decorated.getUser(id);
    }

    public Group getGroup(String groupId) {
        return this.decorated.getGroup(groupId);
    }

    public Group getGroup(String groupName, Group parent) {
        return this.decorated.getGroup(groupName, parent);
    }

    public boolean isMember(IdentityType identityType, Group group) {
        return this.decorated.isMember(identityType, group);
    }

    public void addToGroup(Agent identityType, Group group) {
        this.decorated.addToGroup(identityType, group);
    }

    public void removeFromGroup(Agent member, Group group) {
        this.decorated.removeFromGroup(member, group);
    }

    public Role getRole(String name) {
        return this.decorated.getRole(name);
    }

    public boolean hasGroupRole(IdentityType identityType, Role role, Group group) {
        return this.decorated.hasGroupRole(identityType, role, group);
    }

    public void grantGroupRole(IdentityType identityType, Role role, Group group) {
        this.decorated.grantGroupRole(identityType, role, group);
    }

    public void revokeGroupRole(IdentityType member, Role role, Group group) {
        this.decorated.revokeGroupRole(member, role, group);
    }

    public boolean hasRole(IdentityType identityType, Role role) {
        return this.decorated.hasRole(identityType, role);
    }

    public void grantRole(IdentityType identityType, Role role) {
        this.decorated.grantRole(identityType, role);
    }

    public void revokeRole(IdentityType identityType, Role role) {
        this.decorated.revokeRole(identityType, role);
    }

    public <T extends IdentityType> T lookupIdentityById(Class<T> identityType, String value) {
        return (T)this.decorated.lookupIdentityById(identityType, value);
    }

    public <T extends IdentityType> IdentityQuery<T> createIdentityQuery(Class<T> identityType) {
        return this.decorated.createIdentityQuery(identityType);
    }

    public <T extends Relationship> RelationshipQuery<T> createRelationshipQuery(Class<T> relationshipType) {
        return this.decorated.createRelationshipQuery(relationshipType);
    }

    public void validateCredentials(Credentials credentials) {
        this.decorated.validateCredentials(credentials);
    }

    public void updateCredential(Agent agent, Object value) {
        this.decorated.updateCredential(agent, value);
    }

    public void updateCredential(Agent agent, Object value, Date effectiveDate, Date expiryDate) {
        this.decorated.updateCredential(agent, value, effectiveDate, expiryDate);
    }

    public void loadAttribute(IdentityType identityType, String attributeName) {
        this.decorated.loadAttribute(identityType, attributeName);
    }

    public <T extends CredentialStorage> T retrieveCurrentCredential(Agent agent, Class<T> storageClass) {
        return (T)this.decorated.retrieveCurrentCredential(agent, storageClass);
    }

    public <T extends CredentialStorage> List<T> retrieveCredentials(Agent agent, Class<T> storageClass) {
        return this.decorated.retrieveCredentials(agent, storageClass);
    }
}

