/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.oauth;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

/*
 * Exception performing whole class analysis ignored.
 */
public final class OAuthUtils {
    private static final String ENCODING = "UTF-8";
    private static final String PARAMETER_SEPARATOR = "&";
    private static final String NAME_VALUE_SEPARATOR = "=";
    public static final String AUTH_SCHEME = "Bearer";
    private static final Pattern OAUTH_HEADER = Pattern.compile("\\s*(\\w*)\\s+(.*)");
    private static final Pattern NVP = Pattern.compile("(\\S*)\\s*\\=\\s*\"([^\"]*)\"");
    public static final String MULTIPART = "multipart/";
    private static final String DEFAULT_CONTENT_CHARSET = "UTF-8";

    public static String format(Collection<? extends Map.Entry<String, Object>> parameters, String encoding) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, Object> entry : parameters) {
            String encodedValue;
            String value;
            String string = value = entry.getValue() == null ? null : String.valueOf(entry.getValue());
            if (OAuthUtils.isEmpty((String)entry.getKey()) || OAuthUtils.isEmpty((String)value)) continue;
            String encodedName = OAuthUtils.encode((String)entry.getKey(), (String)encoding);
            String string2 = encodedValue = value != null ? OAuthUtils.encode((String)value, (String)encoding) : "";
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(encodedName);
            result.append("=");
            result.append(encodedValue);
        }
        return result.toString();
    }

    private static String encode(String content, String encoding) {
        try {
            return URLEncoder.encode(content, encoding != null ? encoding : "UTF-8");
        }
        catch (UnsupportedEncodingException problem) {
            throw new IllegalArgumentException(problem);
        }
    }

    public static String saveStreamAsString(InputStream is) throws IOException {
        return OAuthUtils.toString((InputStream)is, (String)"UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(InputStream is, String defaultCharset) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException("InputStream may not be null");
        }
        String charset = defaultCharset;
        if (charset == null) {
            charset = "UTF-8";
        }
        InputStreamReader reader = new InputStreamReader(is, charset);
        StringBuilder sb = new StringBuilder();
        try {
            int l;
            char[] tmp = new char[4096];
            while ((l = reader.read(tmp)) != -1) {
                sb.append(tmp, 0, l);
            }
        }
        finally {
            ((Reader)reader).close();
        }
        return sb.toString();
    }

    public static Map<String, Object> decodeForm(String form) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!OAuthUtils.isEmpty((String)form)) {
            for (String nvp : form.split("\\&")) {
                String value;
                String name;
                int equals = nvp.indexOf(61);
                if (equals < 0) {
                    name = OAuthUtils.decodePercent((String)nvp);
                    value = null;
                } else {
                    name = OAuthUtils.decodePercent((String)nvp.substring(0, equals));
                    value = OAuthUtils.decodePercent((String)nvp.substring(equals + 1));
                }
                params.put(name, value);
            }
        }
        return params;
    }

    public static boolean isFormEncoded(String contentType) {
        if (contentType == null) {
            return false;
        }
        int semi = contentType.indexOf(";");
        if (semi >= 0) {
            contentType = contentType.substring(0, semi);
        }
        return "application/x-www-form-urlencoded".equalsIgnoreCase(contentType.trim());
    }

    public static String decodePercent(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException wow) {
            throw new RuntimeException(wow.getMessage(), wow);
        }
    }

    public static String percentEncode(Iterable values) {
        StringBuilder p = new StringBuilder();
        for (Object v : values) {
            String stringValue = OAuthUtils.toString(v);
            if (OAuthUtils.isEmpty((String)stringValue)) continue;
            if (p.length() > 0) {
                p.append("&");
            }
            p.append(OAuthUtils.percentEncode((String)OAuthUtils.toString(v)));
        }
        return p.toString();
    }

    public static String percentEncode(String s) {
        if (s == null) {
            return "";
        }
        try {
            return URLEncoder.encode(s, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException wow) {
            throw new RuntimeException(wow.getMessage(), wow);
        }
    }

    private static String toString(Object from) {
        return from == null ? null : from.toString();
    }

    private static boolean isEmpty(Set<String> missingParams) {
        return missingParams == null || missingParams.size() == 0;
    }

    public static String getAuthHeaderField(String authHeader) {
        Matcher m;
        if (authHeader != null && (m = OAUTH_HEADER.matcher(authHeader)).matches() && "Bearer".equalsIgnoreCase(m.group(1))) {
            return m.group(2);
        }
        return null;
    }

    public static Map<String, String> decodeOAuthHeader(String header) {
        Matcher m;
        HashMap<String, String> headerValues = new HashMap<String, String>();
        if (header != null && (m = OAUTH_HEADER.matcher(header)).matches() && "Bearer".equalsIgnoreCase(m.group(1))) {
            for (String nvp : m.group(2).split("\\s*,\\s*")) {
                m = NVP.matcher(nvp);
                if (!m.matches()) continue;
                String name = OAuthUtils.decodePercent((String)m.group(1));
                String value = OAuthUtils.decodePercent((String)m.group(2));
                headerValues.put(name, value);
            }
        }
        return headerValues;
    }

    public static String encodeOAuthHeader(Map<String, Object> entries) {
        StringBuffer sb = new StringBuffer();
        sb.append("Bearer").append(" ");
        for (Map.Entry<String, Object> entry : entries.entrySet()) {
            String value;
            String string = value = entry.getValue() == null ? null : String.valueOf(entry.getValue());
            if (OAuthUtils.isEmpty((String)entry.getKey()) || OAuthUtils.isEmpty((String)value)) continue;
            sb.append(entry.getKey());
            sb.append("=\"");
            sb.append(value);
            sb.append("\",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static boolean isEmpty(String value) {
        return value == null || "".equals(value);
    }

    public static boolean hasEmptyValues(String[] array) {
        if (array == null || array.length == 0) {
            return true;
        }
        for (String s : array) {
            if (!OAuthUtils.isEmpty((String)s)) continue;
            return true;
        }
        return false;
    }

    public static String getAuthzMethod(String header) {
        Matcher m;
        if (header != null && (m = OAUTH_HEADER.matcher(header)).matches()) {
            return m.group(1);
        }
        return null;
    }

    public static Set<String> decodeScopes(String s) {
        HashSet<String> scopes = new HashSet<String>();
        if (!OAuthUtils.isEmpty((String)s)) {
            StringTokenizer tokenizer = new StringTokenizer(s, " ");
            while (tokenizer.hasMoreElements()) {
                scopes.add(tokenizer.nextToken());
            }
        }
        return scopes;
    }

    public static String encodeScopes(Set<String> s) {
        StringBuffer scopes = new StringBuffer();
        for (String scope : s) {
            scopes.append(scope).append(" ");
        }
        return scopes.toString().trim();
    }

    public static boolean isMultipart(HttpServletRequest request) {
        if (!"post".equals(request.getMethod().toLowerCase())) {
            return false;
        }
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/");
    }

    public static boolean hasContentType(String requestContentType, String requiredContentType) {
        if (OAuthUtils.isEmpty((String)requiredContentType) || OAuthUtils.isEmpty((String)requestContentType)) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(requestContentType, ";");
        while (tokenizer.hasMoreTokens()) {
            if (!requiredContentType.equals(tokenizer.nextToken())) continue;
            return true;
        }
        return false;
    }
}

