/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.oauth.filters;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.basic.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.oauth.messages.ResourceAccessRequest;
import org.picketlink.oauth.server.util.OAuthServerUtil;

public class OAuthResourceFilter
implements Filter {
    protected IdentityManager identityManager = null;
    protected ServletContext context;
    private EntityManagerFactory entityManagerFactory;
    private ThreadLocal<EntityManager> entityManager = new ThreadLocal();

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            this.context = filterConfig.getServletContext();
            this.identityManager = OAuthServerUtil.handleIdentityManager((ServletContext)this.context);
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        try {
            ResourceAccessRequest resourceAccessRequest = OAuthServerUtil.parseResourceRequest((HttpServletRequest)((HttpServletRequest)request));
            String passedClientID = httpRequest.getParameter("client_id");
            String accessToken = resourceAccessRequest.getAccessToken();
            IdentityQuery userQuery = this.identityManager.createIdentityQuery(User.class);
            userQuery.setParameter(User.ID, new Object[]{passedClientID});
            List users = userQuery.getResultList();
            if (users.size() == 0) {
                httpResponse.sendError(403, "client_id not found");
                return;
            }
            if (users.size() > 1) {
                httpResponse.sendError(403, "More than one user with the same client id");
                return;
            }
            User clientApp = (User)users.get(0);
            String clientID = (String)((Object)clientApp.getAttribute("clientID").getValue());
            String tokenCode = (String)((Object)clientApp.getAttribute("accessToken").getValue());
            if (!clientID.equals(passedClientID)) {
                httpResponse.sendError(403, "Client ID is wrong");
                return;
            }
            if (tokenCode.equals(accessToken)) {
                chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                return;
            }
            httpResponse.sendError(403, "UnAuthorized");
            return;
        }
        catch (Exception e) {
            httpResponse.sendError(403, e.getLocalizedMessage());
            return;
        }
    }

    public void destroy() {
    }

    private Properties getProperties() throws IOException {
        Properties properties = new Properties();
        InputStream is = this.context.getResourceAsStream("/WEB-INF/idm.properties");
        properties.load(is);
        return properties;
    }
}

