/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.oauth.messages;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.codehaus.jackson.map.ObjectMapper;
import org.picketlink.oauth.messages.OAuthRequest;

public class AccessTokenRequest
extends OAuthRequest {
    private static final long serialVersionUID = 5069340399891368370L;
    private String grantType;
    private String code;
    private String redirectUri;
    private String clientId;
    private String location;

    public String getGrantType() {
        return this.grantType;
    }

    public AccessTokenRequest setGrantType(String grantType) {
        this.grantType = grantType;
        return this;
    }

    public String getCode() {
        return this.code;
    }

    public AccessTokenRequest setCode(String code) {
        this.code = code;
        return this;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public AccessTokenRequest setRedirectUri(String redirectURI) {
        this.redirectUri = redirectURI;
        return this;
    }

    public String getClientId() {
        return this.clientId;
    }

    public AccessTokenRequest setClientId(String clientID) {
        this.clientId = clientID;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public AccessTokenRequest setLocation(String location) {
        this.location = location;
        return this;
    }

    public String asJSON() {
        StringWriter sw = new StringWriter();
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.grantType != null) {
            map.put("grant_type", this.encode(this.grantType));
        }
        if (this.clientId != null) {
            map.put("client_id", this.encode(this.clientId));
        }
        if (this.redirectUri != null) {
            map.put("redirect_uri", this.encode(this.redirectUri));
        }
        if (this.code != null) {
            map.put("code", this.encode(this.code));
        }
        ObjectMapper mapper = this.getObjectMapper();
        try {
            mapper.writeValue((Writer)sw, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sw.toString();
    }

    public String asQueryParams() {
        String AMP = "&";
        String EQ = "=";
        StringBuilder builder = new StringBuilder();
        if (this.grantType != null) {
            builder.append("grant_type").append(EQ).append(this.encode(this.grantType)).append(AMP);
        }
        if (this.clientId != null) {
            builder.append("client_id").append(EQ).append(this.encode(this.clientId)).append(AMP);
        }
        if (this.redirectUri != null) {
            builder.append("redirect_uri").append(EQ).append(this.encode(this.redirectUri)).append(AMP);
        }
        if (this.code != null) {
            builder.append("code").append(EQ).append(this.encode(this.code)).append(AMP);
        }
        return builder.toString();
    }
}

