/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.oauth.server.endpoint;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.picketlink.idm.IdentityManager;
import org.picketlink.oauth.messages.OAuthResponse;
import org.picketlink.oauth.server.endpoint.BaseEndpoint;
import org.picketlink.oauth.server.util.OAuthServerUtil;

@Path(value="/token")
public class TokenEndpoint
extends BaseEndpoint {
    private static final long serialVersionUID = 1L;
    protected static Logger log = Logger.getLogger(TokenEndpoint.class.getName());

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response authorize(@Context HttpServletRequest request) {
        super.setup();
        OAuthResponse response = null;
        try {
            response = OAuthServerUtil.tokenRequest((HttpServletRequest)request, (IdentityManager)this.identityManager);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "OAuth Server Token Processing:", e);
            return Response.serverError().build();
        }
        return Response.status((int)response.getStatusCode()).entity((Object)response.asJSON()).build();
    }

    @GET
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response authorizeGet(@Context HttpServletRequest request) {
        super.setup();
        OAuthResponse response = null;
        try {
            response = OAuthServerUtil.tokenRequest((HttpServletRequest)request, (IdentityManager)this.identityManager);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "OAuth Server Token Processing:", e);
            return Response.serverError().build();
        }
        return Response.status((int)response.getStatusCode()).entity((Object)response.asJSON()).build();
    }
}

