/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.scim.client;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.picketlink.scim.codec.SCIMParser;
import org.picketlink.scim.codec.SCIMWriter;
import org.picketlink.scim.model.v11.SCIMGroups;
import org.picketlink.scim.model.v11.SCIMUser;

public class SCIMClient {
    private String baseURL = null;

    public SCIMClient setBaseURL(String base) {
        this.baseURL = base;
        return this;
    }

    public SCIMUser createUser(SCIMUser user) throws Exception {
        String url = this.baseURL + "/Users";
        SCIMWriter writer = new SCIMWriter();
        String json = writer.json(user);
        InputStream is = this.executePost(url, json, true, "xyz");
        SCIMParser parser = new SCIMParser();
        return parser.parseUser(is);
    }

    public SCIMGroups createGroup(SCIMGroups group) throws Exception {
        String url = this.baseURL + "/Users";
        SCIMWriter writer = new SCIMWriter();
        String json = writer.json(group);
        InputStream is = this.executePost(url, json, true, "xyz");
        SCIMParser parser = new SCIMParser();
        return parser.parseGroup(is);
    }

    public SCIMUser getUser(String id) throws Exception {
        String url = this.baseURL + "/Users/" + id;
        InputStream is = this.executeGet(url, null, false, "xyz");
        SCIMParser parser = new SCIMParser();
        return parser.parseUser(is);
    }

    public SCIMGroups getGroup(String id) throws Exception {
        String url = this.baseURL + "/Groups/" + id;
        InputStream is = this.executeGet(url, null, false, "xyz");
        SCIMParser parser = new SCIMParser();
        return parser.parseGroup(is);
    }

    private InputStream executeGet(String endpointURL, String body, boolean isJSON, String authorizationHeader) throws Exception {
        InputStream inputStream;
        block6: {
            inputStream = null;
            try {
                URL resUrl = new URL(endpointURL);
                URLConnection urlConnection = resUrl.openConnection();
                if (urlConnection instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
                    httpURLConnection.setRequestMethod("GET");
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setAllowUserInteraction(false);
                    if (isJSON) {
                        httpURLConnection.setRequestProperty("Content-Type", "application/json");
                    } else {
                        httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    }
                    if (body != null) {
                        httpURLConnection.setRequestProperty("Content-Length", Integer.toString(body.length()));
                        OutputStream ost = httpURLConnection.getOutputStream();
                        PrintWriter pw = new PrintWriter(ost);
                        pw.print(body);
                        pw.flush();
                        pw.close();
                    }
                    inputStream = httpURLConnection.getResponseCode() == 400 ? httpURLConnection.getErrorStream() : httpURLConnection.getInputStream();
                    break block6;
                }
                throw new RuntimeException("Wrong url conn");
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        return inputStream;
    }

    private InputStream executePost(String endpointURL, String body, boolean isJSON, String authorizationHeader) throws Exception {
        InputStream inputStream;
        block6: {
            inputStream = null;
            try {
                URL resUrl = new URL(endpointURL);
                URLConnection urlConnection = resUrl.openConnection();
                if (urlConnection instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
                    httpURLConnection.setRequestMethod("POST");
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setAllowUserInteraction(false);
                    if (isJSON) {
                        httpURLConnection.setRequestProperty("Content-Type", "application/json");
                    } else {
                        httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    }
                    if (body != null) {
                        httpURLConnection.setRequestProperty("Content-Length", Integer.toString(body.length()));
                        OutputStream ost = httpURLConnection.getOutputStream();
                        PrintWriter pw = new PrintWriter(ost);
                        pw.print(body);
                        pw.flush();
                        pw.close();
                    }
                    inputStream = httpURLConnection.getResponseCode() == 400 ? httpURLConnection.getErrorStream() : httpURLConnection.getInputStream();
                    break block6;
                }
                throw new RuntimeException("Wrong url conn");
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        return inputStream;
    }
}

