/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.rest;

import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.picketlink.Identity;
import org.picketlink.credential.DefaultLoginCredentials;
import org.picketlink.idm.model.Account;

@Path(value="/auth")
@RequestScoped
public class AuthenticationEndpoint {
    @Inject
    DefaultLoginCredentials credentials;
    @Inject
    Identity identity;

    @POST
    @Path(value="/login")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Account login(Map<String, String> params) {
        if (!this.identity.isLoggedIn()) {
            this.credentials.setUserId(params.get("username"));
            this.credentials.setPassword(params.get("password"));
            if (!Identity.AuthenticationResult.SUCCESS.equals((Object)this.identity.login())) {
                return null;
            }
        }
        return this.identity.getAccount();
    }

    @GET
    @Path(value="/status")
    @Produces(value={"application/json"})
    public Account status() {
        if (this.identity.isLoggedIn()) {
            return this.identity.getAccount();
        }
        return null;
    }

    @GET
    @Path(value="/logout")
    @Produces(value={"application/json"})
    public boolean logout() {
        this.identity.logout();
        return true;
    }
}

