/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.seam.federation;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PublicKey;
import javax.servlet.http.HttpServletRequest;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Name;
import org.picketlink.identity.federation.core.saml.v2.util.SignatureUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.core.util.XMLSignatureUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingSignatureUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingUtil;
import org.picketlink.identity.seam.federation.InvalidRequestException;
import org.picketlink.identity.seam.federation.RequestOrResponse;
import org.picketlink.identity.seam.federation.configuration.SamlIdentityProvider;
import org.w3c.dom.Document;

@Name(value="org.picketlink.identity.seam.federation.samlSignatureValidator")
@AutoCreate
public class SamlSignatureValidator {
    public void validateSignatureForPostBinding(SamlIdentityProvider idp, Document document) throws InvalidRequestException {
        boolean signatureValid;
        try {
            signatureValid = XMLSignatureUtil.validate((Document)document, (Key)idp.getPublicKey());
        }
        catch (MarshalException e) {
            throw new RuntimeException(e);
        }
        catch (XMLSignatureException e) {
            throw new RuntimeException(e);
        }
        if (!signatureValid) {
            throw new InvalidRequestException("Invalid signature");
        }
    }

    public void validateSignatureForRedirectBinding(SamlIdentityProvider idp, HttpServletRequest httpRequest, RequestOrResponse requestOrResponse) throws InvalidRequestException {
        boolean isValid;
        byte[] sigValue;
        String queryString = httpRequest.getQueryString();
        String sigValueParam = RedirectBindingSignatureUtil.getTokenValue((String)queryString, (String)"Signature");
        if (sigValueParam == null) {
            throw new InvalidRequestException("Signature parameter is not present.");
        }
        try {
            sigValue = RedirectBindingUtil.urlBase64Decode((String)sigValueParam);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String samlMessageParameter = requestOrResponse == RequestOrResponse.REQUEST ? "SAMLRequest" : "SAMLResponse";
        String reqFromURL = RedirectBindingSignatureUtil.getTokenValue((String)queryString, (String)samlMessageParameter);
        String relayStateFromURL = RedirectBindingSignatureUtil.getTokenValue((String)queryString, (String)"RelayState");
        String sigAlgFromURL = RedirectBindingSignatureUtil.getTokenValue((String)queryString, (String)"SigAlg");
        StringBuilder sb = new StringBuilder();
        sb.append(samlMessageParameter).append("=").append(reqFromURL);
        if (StringUtil.isNotNull((String)relayStateFromURL)) {
            sb.append("&").append("RelayState").append("=").append(relayStateFromURL);
        }
        sb.append("&").append("SigAlg").append("=").append(sigAlgFromURL);
        PublicKey validatingKey = idp.getPublicKey();
        try {
            isValid = SignatureUtil.validate((byte[])sb.toString().getBytes("UTF-8"), (byte[])sigValue, (PublicKey)validatingKey);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        if (!isValid) {
            throw new InvalidRequestException("Invalid signature.");
        }
    }
}

