/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.seam.federation;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Import;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.jboss.seam.security.Identity;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectConfirmationDataType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectConfirmationType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusType;
import org.picketlink.identity.seam.federation.ExternalAuthenticationService;
import org.picketlink.identity.seam.federation.InternalAuthenticator;
import org.picketlink.identity.seam.federation.InvalidRequestException;
import org.picketlink.identity.seam.federation.RequestContext;
import org.picketlink.identity.seam.federation.Requests;
import org.picketlink.identity.seam.federation.SamlPrincipal;
import org.picketlink.identity.seam.federation.configuration.SamlIdentityProvider;
import org.picketlink.identity.seam.federation.configuration.ServiceProvider;

@Name(value="org.picketlink.identity.seam.federation.samlSingleSignOnReceiver")
@AutoCreate
@Import(value={"org.picketlink.identity.seam.federation"})
public class SamlSingleSignOnReceiver {
    @Logger
    private Log log;
    @In
    private Requests requests;
    @In
    private Identity identity;
    @In
    private InternalAuthenticator internalAuthenticator;
    @In
    private ServiceProvider serviceProvider;

    public void processIDPResponse(HttpServletRequest httpRequest, HttpServletResponse httpResponse, StatusResponseType statusResponse, RequestContext requestContext, SamlIdentityProvider idp) throws InvalidRequestException {
        StatusType status = statusResponse.getStatus();
        if (status == null) {
            throw new InvalidRequestException("Response does not contain a status");
        }
        String statusValue = status.getStatusCode().getValue();
        if (!JBossSAMLURIConstants.STATUS_SUCCESS.get().equals(statusValue)) {
            throw new RuntimeException("IDP returned status " + statusValue);
        }
        if (!(statusResponse instanceof ResponseType)) {
            throw new InvalidRequestException("Response does not have type ResponseType");
        }
        ResponseType response = (ResponseType)statusResponse;
        List assertions = response.getAssertionOrEncryptedAssertion();
        if (assertions.size() == 0) {
            throw new RuntimeException("IDP response does not contain assertions");
        }
        SamlPrincipal principal = this.getAuthenticatedUser(response, requestContext);
        if (principal == null) {
            try {
                httpResponse.sendRedirect(this.serviceProvider.getFailedAuthenticationUrl());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            principal.setIdentityProvider(idp);
            this.loginUser(httpRequest, httpResponse, principal, requestContext);
        }
    }

    private SamlPrincipal getAuthenticatedUser(ResponseType responseType, RequestContext requestContext) {
        SamlPrincipal principal = null;
        for (Object assertion : responseType.getAssertionOrEncryptedAssertion()) {
            if (assertion instanceof AssertionType) {
                SamlPrincipal assertionSubject = this.handleAssertion((AssertionType)assertion, requestContext);
                if (principal == null) {
                    principal = assertionSubject;
                    continue;
                }
                this.log.warn((Object)"Multiple authenticated users found in assertions. Using the first one.", new Object[0]);
                continue;
            }
            this.log.warn((Object)"Encountered encrypted assertion. Skipping it because decryption is not yet supported.", new Object[0]);
        }
        return principal;
    }

    private SamlPrincipal handleAssertion(AssertionType assertion, RequestContext requestContext) {
        try {
            if (AssertionUtil.hasExpired((AssertionType)assertion)) {
                this.log.warn((Object)"Received assertion not processed because it has expired.", new Object[0]);
                return null;
            }
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        AuthnStatementType authnStatement = this.extractValidAuthnStatement(assertion);
        if (authnStatement == null) {
            this.log.warn((Object)"Received assertion not processed because it doesn't contain a valid authnStatement.", new Object[0]);
            return null;
        }
        NameIDType nameId = this.validateSubjectAndExtractNameID(assertion, requestContext);
        if (nameId == null) {
            this.log.warn((Object)"Received assertion not processed because it doesn't contain a valid subject.", new Object[0]);
            return null;
        }
        SamlPrincipal principal = new SamlPrincipal();
        principal.setAssertion(assertion);
        principal.setSessionIndex(authnStatement.getSessionIndex());
        principal.setNameId(nameId);
        for (StatementAbstractType statement : assertion.getStatementOrAuthnStatementOrAuthzDecisionStatement()) {
            if (!(statement instanceof AttributeStatementType)) continue;
            AttributeStatementType attributeStatement = (AttributeStatementType)statement;
            LinkedList<AttributeType> attributes = new LinkedList<AttributeType>();
            for (Object object : attributeStatement.getAttributeOrEncryptedAttribute()) {
                if (object instanceof AttributeType) {
                    attributes.add((AttributeType)object);
                    continue;
                }
                this.log.warn((Object)"Encrypted attributes are not supported. Ignoring the attribute.", new Object[0]);
            }
            principal.setAttributes(attributes);
        }
        return principal;
    }

    private AuthnStatementType extractValidAuthnStatement(AssertionType assertion) {
        for (StatementAbstractType statement : assertion.getStatementOrAuthnStatementOrAuthzDecisionStatement()) {
            if (!(statement instanceof AuthnStatementType)) continue;
            AuthnStatementType authnStatement = (AuthnStatementType)statement;
            return authnStatement;
        }
        return null;
    }

    private NameIDType validateSubjectAndExtractNameID(AssertionType assertion, RequestContext requestContext) {
        NameIDType nameId = null;
        boolean validConfirmationFound = false;
        for (JAXBElement contentElement : assertion.getSubject().getContent()) {
            boolean validInResponseTo;
            SubjectConfirmationType confirmation;
            if (contentElement.getValue() instanceof NameIDType) {
                nameId = (NameIDType)contentElement.getValue();
            }
            if (!(contentElement.getValue() instanceof SubjectConfirmationType) || !(confirmation = (SubjectConfirmationType)contentElement.getValue()).getMethod().equals("urn:oasis:names:tc:SAML:2.0:cm:bearer")) continue;
            SubjectConfirmationDataType confirmationData = confirmation.getSubjectConfirmationData();
            boolean validRecipient = confirmationData.getRecipient().equals(this.serviceProvider.getServiceURL(ExternalAuthenticationService.SAML_ASSERTION_CONSUMER_SERVICE));
            boolean notTooLate = confirmationData.getNotOnOrAfter().compare(this.getCurrentTime()) == 1;
            boolean bl = validInResponseTo = requestContext == null || confirmationData.getInResponseTo().equals(requestContext.getId());
            if (!validRecipient || !notTooLate || !validInResponseTo) continue;
            validConfirmationFound = true;
        }
        if (validConfirmationFound) {
            return nameId;
        }
        return null;
    }

    private XMLGregorianCalendar getCurrentTime() {
        try {
            return XMLTimeUtil.getIssueInstant();
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private void loginUser(HttpServletRequest httpRequest, HttpServletResponse httpResponse, SamlPrincipal principal, RequestContext requestContext) {
        if (this.identity.isLoggedIn()) {
            throw new RuntimeException("User is already logged in.");
        }
        boolean internallyAuthenticated = this.internalAuthenticator.authenticate(principal, httpRequest);
        try {
            if (internallyAuthenticated) {
                if (requestContext == null) {
                    this.redirectForUnsolicitedAuthentication(httpRequest, httpResponse);
                } else {
                    this.requests.redirect(requestContext.getId(), httpResponse);
                }
            } else {
                httpResponse.sendRedirect(this.serviceProvider.getFailedAuthenticationUrl());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void redirectForUnsolicitedAuthentication(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        String relayState = httpRequest.getParameter("RelayState");
        if (relayState != null) {
            httpResponse.sendRedirect(relayState);
        } else {
            String unsolicitedAuthenticationUrl = this.serviceProvider.getUnsolicitedAuthenticationUrl();
            if (unsolicitedAuthenticationUrl != null) {
                httpResponse.sendRedirect(unsolicitedAuthenticationUrl);
            } else {
                throw new RuntimeException("Unsolicited login could not be handled because the unsolicitedAuthenticationViewId property has not been configured");
            }
        }
    }
}

