/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.seam.federation.configuration;

import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import javax.xml.bind.JAXBElement;
import org.picketlink.identity.federation.saml.v2.metadata.IDPSSODescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.KeyDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.KeyTypes;
import org.picketlink.identity.seam.federation.SamlProfile;
import org.picketlink.identity.seam.federation.configuration.SamlService;
import org.picketlink.identity.xmlsec.w3.xmldsig.X509DataType;

public class SamlIdentityProvider {
    private String entityId;
    private Map<SamlProfile, SamlService> services = new HashMap<SamlProfile, SamlService>();
    private PublicKey publicKey;
    private boolean wantAuthnRequestsSigned;
    private boolean wantSingleLogoutMessagesSigned;
    private boolean singleLogoutMessagesSigned;

    public SamlIdentityProvider(String entityId, IDPSSODescriptorType IDPSSODescriptor) {
        this.entityId = entityId;
        this.wantAuthnRequestsSigned = IDPSSODescriptor.isWantAuthnRequestsSigned();
        this.services.put(SamlProfile.SINGLE_SIGN_ON, new SamlService(SamlProfile.SINGLE_SIGN_ON, IDPSSODescriptor.getSingleSignOnService()));
        this.services.put(SamlProfile.SINGLE_LOGOUT, new SamlService(SamlProfile.SINGLE_LOGOUT, IDPSSODescriptor.getSingleLogoutService()));
        for (KeyDescriptorType keyDescriptor : IDPSSODescriptor.getKeyDescriptor()) {
            if (!keyDescriptor.getUse().equals((Object)KeyTypes.SIGNING)) continue;
            for (Object content : keyDescriptor.getKeyInfo().getContent()) {
                if (!(content instanceof JAXBElement) || !(((JAXBElement)content).getValue() instanceof X509DataType)) continue;
                X509DataType X509Data = (X509DataType)((JAXBElement)content).getValue();
                for (Object object : X509Data.getX509IssuerSerialOrX509SKIOrX509SubjectName()) {
                    JAXBElement el;
                    if (!(object instanceof JAXBElement) || !(el = (JAXBElement)object).getName().getLocalPart().equals("X509Certificate")) continue;
                    byte[] certificate = (byte[])el.getValue();
                    try {
                        X509Certificate cert = X509Certificate.getInstance(certificate);
                        this.publicKey = cert.getPublicKey();
                    }
                    catch (CertificateException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public SamlService getService(SamlProfile service) {
        return this.services.get((Object)service);
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public boolean isWantAuthnRequestsSigned() {
        return this.wantAuthnRequestsSigned;
    }

    public void setWantAuthnRequestsSigned(boolean wantAuthnRequestsSigned) {
        this.wantAuthnRequestsSigned = wantAuthnRequestsSigned;
    }

    public boolean isWantSingleLogoutMessagesSigned() {
        return this.wantSingleLogoutMessagesSigned;
    }

    public void setWantSingleLogoutMessagesSigned(boolean wantSingleLogoutMessagesSigned) {
        this.wantSingleLogoutMessagesSigned = wantSingleLogoutMessagesSigned;
    }

    public boolean isSingleLogoutMessagesSigned() {
        return this.singleLogoutMessagesSigned;
    }

    public void setSingleLogoutMessagesSigned(boolean singleLogoutMessagesSigned) {
        this.singleLogoutMessagesSigned = singleLogoutMessagesSigned;
    }
}

