/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.seam.federation;

import javax.xml.datatype.XMLGregorianCalendar;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.factories.JBossSAMLBaseFactory;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.LogoutRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.ObjectFactory;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusCodeType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusType;
import org.picketlink.identity.seam.federation.ExternalAuthenticationService;
import org.picketlink.identity.seam.federation.SeamSamlPrincipal;
import org.picketlink.identity.seam.federation.configuration.ServiceProvider;

@Name(value="org.picketlink.identity.seam.federation.samlMessageFactory")
@AutoCreate
public class SamlMessageFactory {
    @In
    private ServiceProvider serviceProvider;

    public StatusResponseType createStatusResponse(RequestAbstractType request, String statusCode, String statusMessage) {
        ObjectFactory objectFactory = new ObjectFactory();
        org.picketlink.identity.federation.saml.v2.assertion.ObjectFactory assertionObjectFactory = new org.picketlink.identity.federation.saml.v2.assertion.ObjectFactory();
        StatusResponseType response = objectFactory.createStatusResponseType();
        response.setID(this.generateId());
        response.setIssueInstant(this.generateIssueInstant());
        NameIDType issuer = assertionObjectFactory.createNameIDType();
        issuer.setValue(this.serviceProvider.getSamlConfiguration().getEntityId());
        response.setIssuer(issuer);
        response.setVersion(JBossSAMLConstants.VERSION_2_0.get());
        response.setInResponseTo(request.getID());
        StatusCodeType statusCodeJaxb = objectFactory.createStatusCodeType();
        statusCodeJaxb.setValue(statusCode);
        StatusType statusType = objectFactory.createStatusType();
        statusType.setStatusCode(statusCodeJaxb);
        if (statusMessage != null) {
            statusType.setStatusMessage(statusMessage);
        }
        response.setStatus(statusType);
        return response;
    }

    public AuthnRequestType createAuthnRequest() {
        ObjectFactory objectFactory = new ObjectFactory();
        org.picketlink.identity.federation.saml.v2.assertion.ObjectFactory assertionObjectFactory = new org.picketlink.identity.federation.saml.v2.assertion.ObjectFactory();
        AuthnRequestType authnRequest = objectFactory.createAuthnRequestType();
        authnRequest.setID(this.generateId());
        authnRequest.setIssueInstant(this.generateIssueInstant());
        NameIDType issuer = assertionObjectFactory.createNameIDType();
        issuer.setValue(this.serviceProvider.getSamlConfiguration().getEntityId());
        authnRequest.setIssuer(issuer);
        authnRequest.setVersion(JBossSAMLConstants.VERSION_2_0.get());
        authnRequest.setAssertionConsumerServiceURL(this.serviceProvider.getServiceURL(ExternalAuthenticationService.SAML_ASSERTION_CONSUMER_SERVICE));
        authnRequest.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        return authnRequest;
    }

    public LogoutRequestType createLogoutRequest(SeamSamlPrincipal principal) throws ConfigurationException {
        ObjectFactory objectFactory = new ObjectFactory();
        org.picketlink.identity.federation.saml.v2.assertion.ObjectFactory assertionObjectFactory = new org.picketlink.identity.federation.saml.v2.assertion.ObjectFactory();
        LogoutRequestType logoutRequest = objectFactory.createLogoutRequestType();
        logoutRequest.setID(this.generateId());
        logoutRequest.setIssueInstant(this.generateIssueInstant());
        NameIDType issuer = assertionObjectFactory.createNameIDType();
        issuer.setValue(this.serviceProvider.getSamlConfiguration().getEntityId());
        logoutRequest.setIssuer(issuer);
        NameIDType nameID = JBossSAMLBaseFactory.createNameID();
        nameID.setValue(principal.getNameId().getValue());
        logoutRequest.setNameID(nameID);
        logoutRequest.setVersion(JBossSAMLConstants.VERSION_2_0.get());
        logoutRequest.getSessionIndex().add(principal.getSessionIndex());
        return logoutRequest;
    }

    private String generateId() {
        return IDGenerator.create((String)"ID_");
    }

    private XMLGregorianCalendar generateIssueInstant() {
        try {
            return XMLTimeUtil.getIssueInstant();
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

