/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.seam.federation;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Import;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.security.Identity;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.saml.v2.protocol.LogoutRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.seam.federation.Requests;
import org.picketlink.identity.seam.federation.SamlMessageFactory;
import org.picketlink.identity.seam.federation.SamlMessageSender;
import org.picketlink.identity.seam.federation.SamlProfile;
import org.picketlink.identity.seam.federation.SeamSamlPrincipal;
import org.picketlink.identity.seam.federation.configuration.SamlIdentityProvider;

@Name(value="org.picketlink.identity.seam.federation.samlSingleLogoutSender")
@AutoCreate
@Import(value={"org.picketlink.identity.seam.federation"})
public class SamlSingleLogoutSender {
    @In
    private Requests requests;
    @In
    private SamlMessageSender samlMessageSender;
    @In
    private SamlMessageFactory samlMessageFactory;

    public void sendSingleLogoutRequestToIDP(HttpServletRequest request, HttpServletResponse response, Identity identity) {
        LogoutRequestType logoutRequest;
        SeamSamlPrincipal principal = (SeamSamlPrincipal)identity.getPrincipal();
        SamlIdentityProvider idp = principal.getIdentityProvider();
        try {
            logoutRequest = this.samlMessageFactory.createLogoutRequest(principal);
            this.requests.addRequest(logoutRequest.getID(), idp, null);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        this.samlMessageSender.sendRequestToIDP(request, response, idp, SamlProfile.SINGLE_LOGOUT, (RequestAbstractType)logoutRequest);
    }
}

