/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.trust.jbossws;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.picketlink.trust.jbossws.Constants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Util {
    public static int count = 0;

    public static String assignWsuId(Element element) {
        String id = element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        if (id == null || id.length() < 1) {
            id = Util.generateId();
            element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", id);
            Util.addNamespace(element, "wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        }
        return id;
    }

    public static Element getFirstChildElement(Node node) {
        Node child = node.getFirstChild();
        while (child != null && child.getNodeType() != 1) {
            child = child.getNextSibling();
        }
        return (Element)child;
    }

    public static Element getNextSiblingElement(Element element) {
        Node sibling = element.getNextSibling();
        while (sibling != null && sibling.getNodeType() != 1) {
            sibling = sibling.getNextSibling();
        }
        return (Element)sibling;
    }

    public static Element getPreviousSiblingElement(Element element) {
        Node sibling = element.getPreviousSibling();
        while (sibling != null && sibling.getNodeType() != 1) {
            sibling = sibling.getPreviousSibling();
        }
        return (Element)sibling;
    }

    public static Element findElement(Element root, String localName, String namespace) {
        return Util.findElement(root, new QName(namespace, localName));
    }

    public static Element findElement(Element root, QName name) {
        if (Util.matchNode(root, name)) {
            return root;
        }
        Node child = root.getFirstChild();
        while (child != null) {
            Element possibleMatch;
            if (child.getNodeType() == 1 && (possibleMatch = Util.findElement((Element)child, name)) != null) {
                return possibleMatch;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public static List<Node> findAllElements(Element root, QName name, boolean local) {
        ArrayList<Node> list = new ArrayList<Node>();
        if (Util.matchNode(root, name, local)) {
            list.add(root);
        }
        Node child = root.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                list.addAll(Util.findAllElements((Element)child, name, local));
            }
            child = child.getNextSibling();
        }
        return list;
    }

    public static Element findElementByWsuId(Element root, String id) {
        if (id.equals(Util.getWsuId(root))) {
            return root;
        }
        Node child = root.getFirstChild();
        while (child != null) {
            Element possibleMatch;
            if (child.getNodeType() == 1 && (possibleMatch = Util.findElementByWsuId((Element)child, id)) != null) {
                return possibleMatch;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public static Element findOrCreateSoapHeader(Element envelope) {
        String prefix = envelope.getPrefix();
        String uri = envelope.getNamespaceURI();
        QName name = new QName(uri, "Header");
        Element header = Util.findElement(envelope, name);
        if (header == null) {
            header = envelope.getOwnerDocument().createElementNS(uri, String.valueOf(prefix) + ":Header");
            envelope.insertBefore(header, envelope.getFirstChild());
        }
        return header;
    }

    public static String getWsuId(Element element) {
        String ns;
        if (element.hasAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id")) {
            return element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        }
        if (element.hasAttribute("Id") && (Constants.XML_SIGNATURE_NS.equals(ns = element.getNamespaceURI()) || Constants.XML_ENCRYPTION_NS.equals(ns))) {
            return element.getAttribute("Id");
        }
        return null;
    }

    public static boolean equalStrings(String string1, String string2) {
        if (string1 == null && string2 == null) {
            return true;
        }
        return string1 != null && string1.equals(string2);
    }

    public static boolean matchNode(Node node, QName name) {
        return Util.matchNode(node, name, false);
    }

    public static boolean matchNode(Node node, QName name, boolean local) {
        return Util.equalStrings(node.getLocalName(), name.getLocalPart()) && (local || Util.equalStrings(node.getNamespaceURI(), name.getNamespaceURI()));
    }

    public static String generateId() {
        return Util.generateId("element");
    }

    public static void addNamespace(Element element, String prefix, String uri) {
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateId(String prefix) {
        StringBuilder id = new StringBuilder();
        long time = System.currentTimeMillis();
        Class<Util> clazz = Util.class;
        synchronized (Util.class) {
            // ** MonitorExit[var4_3] (shouldn't be in output)
            id.append(prefix).append("-").append(++count).append("-").append(time).append("-").append(id.hashCode());
            return id.toString();
        }
    }
}

