/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.trust.jbossws.handler;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityContext;
import org.jboss.wsf.common.handler.GenericSOAPHandler;
import org.picketlink.identity.federation.bindings.jboss.subject.PicketLinkPrincipal;
import org.picketlink.identity.federation.core.wstrust.SamlCredential;
import org.picketlink.trust.jbossws.Constants;
import org.picketlink.trust.jbossws.Util;
import org.picketlink.trust.jbossws.handler.SecurityActions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SAML2Handler
extends GenericSOAPHandler {
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private static Set<QName> headers;

    static {
        HashSet<QName> set = new HashSet<QName>();
        set.add(Constants.WSSE_HEADER_QNAME);
        headers = Collections.unmodifiableSet(set);
    }

    public Set<QName> getHeaders() {
        return headers;
    }

    protected boolean handleInbound(MessageContext msgContext) {
        SOAPMessageContext ctx = (SOAPMessageContext)msgContext;
        SOAPMessage soapMessage = ctx.getMessage();
        SOAPPart document = soapMessage.getSOAPPart();
        Element soapHeader = Util.findOrCreateSoapHeader(document.getDocumentElement());
        Element assertion = Util.findElement(soapHeader, new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion"));
        if (assertion != null) {
            SamlCredential credential = new SamlCredential(assertion);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Assertion included in SOAP payload:");
                this.log.trace((Object)credential.getAssertionAsString());
            }
            Element subject = Util.findElement(assertion, new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Subject"));
            Element nameID = Util.findElement(subject, new QName("urn:oasis:names:tc:SAML:2.0:assertion", "NameID"));
            String username = nameID.getTextContent();
            Subject s = new Subject();
            SecurityContext sc = SecurityActions.createSecurityContext((Principal)new PicketLinkPrincipal(username), credential, s);
            SecurityActions.setSecurityContext(sc);
        }
        return true;
    }

    protected boolean handleOutbound(MessageContext msgContext) {
        SOAPMessageContext ctx = (SOAPMessageContext)msgContext;
        SOAPMessage soapMessage = ctx.getMessage();
        Element assertion = (Element)ctx.get((Object)"org.picketlink.trust.saml.assertion");
        SOAPPart document = soapMessage.getSOAPPart();
        Element soapHeader = Util.findOrCreateSoapHeader(document.getDocumentElement());
        try {
            Element wsse = this.getSecurityHeaderElement((Document)document);
            wsse.setAttributeNS(soapHeader.getNamespaceURI(), String.valueOf(soapHeader.getPrefix()) + ":mustUnderstand", "1");
            if (assertion != null) {
                if (document != assertion.getOwnerDocument()) {
                    wsse.appendChild(document.importNode(assertion, true));
                } else {
                    wsse.appendChild(assertion);
                }
            }
            soapHeader.insertBefore(wsse, soapHeader.getFirstChild());
        }
        catch (Exception e) {
            this.log.error((Object)e);
            return false;
        }
        return true;
    }

    private Element getSecurityHeaderElement(Document document) {
        Element element = document.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Security");
        Util.addNamespace(element, "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        Util.addNamespace(element, "wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        Util.addNamespace(element, "ds", Constants.XML_SIGNATURE_NS);
        return element;
    }
}

