/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.picketlink.identity.federation.bindings.wildfly.sp;

import io.undertow.server.handlers.form.FormData;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

/**
 * HttpServletRequest wrapper which changes behavior of {@see ServletRequest.getParameter}.
 * In case oroigin getParameter() method returns null and there is a not null instance of {@see FormData), wrapper returns data from FormData instead.
 * Wrapper is a part of the fix of JBEAP-10449.
 *
 * @Author Jiri Ondrusek
 */
public class SPFormAuthenticationRequestWrapper extends HttpServletRequestWrapper {

    private final FormData formData;

    public SPFormAuthenticationRequestWrapper(HttpServletRequest request, FormData formData) {
        super(request);
        this.formData = formData;
    }

    @Override
    public String getParameter(String name) {
        String retVal = super.getParameter(name);

        if(retVal == null && formData != null) {
            FormData.FormValue formValue = formData.getFirst(name);
            if (formValue != null) {
                retVal = formValue.getValue();
            }
        }
        return retVal;
    }
}
