/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.behaviors;

import com.thoughtworks.proxy.ProxyFactory;
import com.thoughtworks.proxy.factory.StandardProxyFactory;
import com.thoughtworks.proxy.toys.delegate.Delegating;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.AbstractBehavior;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Assimilated<T>
extends AbstractBehavior<T> {
    private final Class<T> type;
    private final ProxyFactory proxyFactory;
    private final boolean isCompatible;

    public Assimilated(Class<T> type, ComponentAdapter delegate, ProxyFactory proxyFactory) throws PicoCompositionException {
        super(delegate);
        this.type = type;
        this.proxyFactory = proxyFactory;
        Class delegationType = delegate.getComponentImplementation();
        this.isCompatible = type.isAssignableFrom(delegationType);
        if (!this.isCompatible) {
            Method[] methods;
            if (!proxyFactory.canProxy(type)) {
                throw new PicoCompositionException("Cannot create proxy for type " + type.getName());
            }
            for (Method method : methods = type.getMethods()) {
                try {
                    delegationType.getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    throw new PicoCompositionException("Cannot create proxy for type " + type.getName() + ", because of incompatible method " + method.toString());
                }
            }
        }
    }

    public Assimilated(Class<T> type, ComponentAdapter delegate) {
        this(type, delegate, (ProxyFactory)new StandardProxyFactory());
    }

    public T getComponentInstance(PicoContainer container, Type into) throws PicoCompositionException {
        return (T)(this.isCompatible ? super.getComponentInstance(container, into) : Delegating.object(this.type, (Object)super.getComponentInstance(container, into), (ProxyFactory)this.proxyFactory));
    }

    public String getDescriptor() {
        return "Assimilated";
    }

    public Class<? extends T> getComponentImplementation() {
        return this.isCompatible ? super.getComponentImplementation() : this.type;
    }

    public Object getComponentKey() {
        Object key = super.getComponentKey();
        if (!(!(key instanceof Class) || this.isCompatible && this.type.isAssignableFrom((Class)key))) {
            return this.type;
        }
        return key;
    }
}

