/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.containers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentFactory;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.adapters.InstanceAdapter;
import org.picocontainer.behaviors.Stored;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReusablePicoContainer
extends DefaultPicoContainer {
    private final List<ComponentAdapter<?>> instanceRegistrations = new ArrayList();
    private final List<ComponentAdapter<?>> adapterRegistrations = new ArrayList();
    private final Map<ComponentAdapter<?>, Stored<?>> storedReferences = new HashMap();

    public ReusablePicoContainer() {
    }

    public ReusablePicoContainer(ComponentFactory componentFactory, LifecycleStrategy lifecycleStrategy, PicoContainer parent, ComponentMonitor componentMonitor) {
        super(componentFactory, lifecycleStrategy, parent, componentMonitor);
    }

    public ReusablePicoContainer(ComponentFactory componentFactory, LifecycleStrategy lifecycleStrategy, PicoContainer parent) {
        super(componentFactory, lifecycleStrategy, parent);
    }

    public ReusablePicoContainer(ComponentFactory componentFactory, PicoContainer parent) {
        super(componentFactory, parent);
    }

    public ReusablePicoContainer(ComponentFactory componentFactory) {
        super(componentFactory);
    }

    public ReusablePicoContainer(ComponentMonitor monitor, LifecycleStrategy lifecycleStrategy, PicoContainer parent) {
        super(monitor, lifecycleStrategy, parent);
    }

    public ReusablePicoContainer(ComponentMonitor monitor, PicoContainer parent) {
        super(monitor, parent);
    }

    public ReusablePicoContainer(ComponentMonitor monitor) {
        super(monitor);
    }

    public ReusablePicoContainer(LifecycleStrategy lifecycleStrategy, PicoContainer parent) {
        super(lifecycleStrategy, parent);
    }

    public ReusablePicoContainer(PicoContainer parent) {
        super(parent);
    }

    public MutablePicoContainer addComponent(Object componentKey, Object componentImplementationOrInstance, Parameter ... parameters) throws PicoCompositionException {
        if (componentKey == null) {
            throw new NullPointerException("componentKey");
        }
        if (componentImplementationOrInstance == null) {
            throw new NullPointerException("componentImplementationOrInstance");
        }
        super.addComponent(componentKey, componentImplementationOrInstance, parameters);
        if (!(componentImplementationOrInstance instanceof Class)) {
            this.instanceRegistrations.add(super.getComponentAdapter(componentKey));
        } else {
            this.addStoredReference(componentKey);
        }
        return this;
    }

    public MutablePicoContainer addComponent(Object implOrInstance) throws PicoCompositionException {
        if (implOrInstance instanceof Class) {
            super.addComponent(implOrInstance);
            this.addStoredReference(implOrInstance);
            return this;
        }
        return this.addComponent(implOrInstance.getClass(), implOrInstance, new Parameter[0]);
    }

    private void addStoredReference(Object key) {
        ComponentAdapter ca = this.getComponentAdapter(key);
        Stored stored = (Stored)ca.findAdapterOfType(Stored.class);
        if (stored != null) {
            this.storedReferences.put(ca, stored);
        }
    }

    public synchronized void stop() {
        super.stop();
        this.flushInstances();
    }

    public void flushInstances() {
        for (ComponentAdapter<?> componentAdapter : this.instanceRegistrations) {
            this.removeComponent(componentAdapter.getComponentKey());
        }
        this.instanceRegistrations.clear();
        for (ComponentAdapter<?> componentAdapter : this.adapterRegistrations) {
            this.removeComponent(componentAdapter.getComponentKey());
        }
        this.adapterRegistrations.clear();
        for (Stored stored : this.storedReferences.values()) {
            stored.flush();
        }
    }

    public MutablePicoContainer addAdapter(ComponentAdapter<?> componentAdapter, Properties properties) {
        super.addAdapter(componentAdapter, properties);
        if (componentAdapter.findAdapterOfType(InstanceAdapter.class) != null) {
            this.instanceRegistrations.add(componentAdapter);
        } else {
            this.addStoredReference(componentAdapter.getComponentKey());
        }
        return this;
    }

    public MutablePicoContainer addFlushableAdapter(ComponentAdapter<?> componentAdapter) {
        this.adapterRegistrations.add(componentAdapter);
        this.addAdapter(componentAdapter);
        return this;
    }

    public MutablePicoContainer addAdapter(ComponentAdapter<?> componentAdapter) {
        super.addAdapter(componentAdapter);
        if (componentAdapter.findAdapterOfType(InstanceAdapter.class) != null) {
            this.instanceRegistrations.add(componentAdapter);
        } else {
            this.addStoredReference(componentAdapter.getComponentKey());
        }
        return this;
    }

    private void removeLocalReferences(ComponentAdapter<?> ca) {
        this.storedReferences.remove(ca);
    }

    public <T> ComponentAdapter<T> removeComponent(Object componentKey) {
        ComponentAdapter result = null;
        try {
            result = super.removeComponent(componentKey);
        }
        catch (PicoCompositionException e) {
            throw new PicoCompositionException("There was an error removing component by key: '" + componentKey + "'", (Throwable)e);
        }
        if (result != null) {
            this.removeLocalReferences(result);
        }
        return result;
    }

    public <T> ComponentAdapter<T> removeComponentByInstance(T componentInstance) {
        ComponentAdapter result = super.removeComponentByInstance(componentInstance);
        if (result != null) {
            this.removeLocalReferences(result);
        }
        return result;
    }

    public MutablePicoContainer makeChildContainer() {
        ReusablePicoContainer pc = new ReusablePicoContainer(this.componentFactory, this.lifecycleStrategy, (PicoContainer)this);
        this.addChildContainer((PicoContainer)pc);
        return pc;
    }
}

