/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.tck;

import junit.framework.TestCase;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoException;
import org.picocontainer.parameters.ComponentParameter;
import org.picocontainer.parameters.ConstantParameter;

public abstract class AbstractMultipleConstructorTestCase
extends TestCase {
    protected abstract MutablePicoContainer createPicoContainer();

    public void testStringWorks() throws PicoException {
        MutablePicoContainer pico = this.createPicoContainer();
        pico.addComponent(String.class);
        AbstractMultipleConstructorTestCase.assertEquals((String)"", (String)((String)pico.getComponent(String.class)));
    }

    public void testMultiWithOnlySmallSatisfiedDependencyWorks() throws PicoException {
        MutablePicoContainer pico = this.createPicoContainer();
        pico.addComponent(Multi.class);
        pico.addComponent(One.class);
        pico.addComponent(Three.class);
        Multi multi = (Multi)pico.getComponent(Multi.class);
        AbstractMultipleConstructorTestCase.assertEquals((String)"three one", (String)multi.message);
    }

    public void testMultiWithBothSatisfiedDependencyWorks() throws PicoException {
        MutablePicoContainer pico = this.createPicoContainer();
        pico.addComponent(Multi.class);
        pico.addComponent(One.class);
        pico.addComponent(Two.class);
        pico.addComponent(Three.class);
        Multi multi = (Multi)pico.getComponent(Multi.class);
        AbstractMultipleConstructorTestCase.assertEquals((String)"one two three", (String)multi.message);
    }

    public void testMultiWithTwoEquallyBigSatisfiedDependenciesFails() throws PicoException {
        MutablePicoContainer pico = this.createPicoContainer();
        pico.addComponent(Multi.class);
        pico.addComponent(One.class);
        pico.addComponent(Two.class);
        try {
            pico.getComponent(Multi.class);
            AbstractMultipleConstructorTestCase.fail();
        }
        catch (PicoCompositionException e) {
            AbstractMultipleConstructorTestCase.assertEquals((String)"3 satisfiable constructors is too many for 'class org.picocontainer.tck.AbstractMultipleConstructorTestCase$Multi'. Constructor List:[<init>(), <init>(org.picocontainer.tck.AbstractMultipleConstructorTestCase$One,org.picocontainer.tck.AbstractMultipleConstructorTestCase$Two), <init>(org.picocontainer.tck.AbstractMultipleConstructorTestCase$Two,org.picocontainer.tck.AbstractMultipleConstructorTestCase$One)]", (String)e.getMessage());
        }
    }

    public void testMultiWithSatisfyingDependencyAndParametersWorks() throws PicoException {
        MutablePicoContainer pico = this.createPicoContainer();
        pico.addComponent((Object)"MultiOneTwo", Multi.class, new Parameter[]{ComponentParameter.DEFAULT, new ComponentParameter((Object)"Two")});
        pico.addComponent((Object)"MultiTwoOne", Multi.class, new Parameter[]{new ComponentParameter((Object)"Two"), ComponentParameter.DEFAULT});
        pico.addComponent((Object)"MultiOneString", Multi.class, new Parameter[]{ComponentParameter.DEFAULT, new ConstantParameter((Object)"")});
        pico.addComponent((Object)"MultiOneInt", Multi.class, new Parameter[]{ComponentParameter.DEFAULT, new ConstantParameter((Object)5)});
        pico.addComponent((Object)"MultiNone", Multi.class, Parameter.ZERO);
        pico.addComponent(One.class);
        pico.addComponent((Object)"Two", Two.class, new Parameter[0]);
        Multi multiOneTwo = (Multi)pico.getComponent((Object)"MultiOneTwo");
        AbstractMultipleConstructorTestCase.assertEquals((String)"one two", (String)multiOneTwo.message);
        Multi multiTwoOne = (Multi)pico.getComponent((Object)"MultiTwoOne");
        AbstractMultipleConstructorTestCase.assertEquals((String)"two one", (String)multiTwoOne.message);
        Multi multiOneString = (Multi)pico.getComponent((Object)"MultiOneString");
        AbstractMultipleConstructorTestCase.assertEquals((String)"one string", (String)multiOneString.message);
        Multi multiOneInt = (Multi)pico.getComponent((Object)"MultiOneInt");
        AbstractMultipleConstructorTestCase.assertEquals((String)"one int", (String)multiOneInt.message);
        Multi multiNone = (Multi)pico.getComponent((Object)"MultiNone");
        AbstractMultipleConstructorTestCase.assertEquals((String)"none", (String)multiNone.message);
    }

    public static class Three {
    }

    public static class Two {
    }

    public static class One {
    }

    public static final class Multi {
        public final String message;

        public Multi(One one, Two two, Three three) {
            this.message = "one two three";
        }

        public Multi(One one, Two two) {
            this.message = "one two";
        }

        public Multi(Two two, One one) {
            this.message = "two one";
        }

        public Multi(Two two, Three three) {
            this.message = "two three";
        }

        public Multi(Three three, One one) {
            this.message = "three one";
        }

        public Multi(One one, String string) {
            this.message = "one string";
        }

        public Multi(One one, int i) {
            this.message = "one int";
        }

        public Multi() {
            this.message = "none";
        }
    }
}

