/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.tck;

import org.junit.Assert;
import org.junit.Test;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoException;
import org.picocontainer.parameters.ComponentParameter;
import org.picocontainer.parameters.ConstantParameter;

public abstract class AbstractMultipleConstructorTest {
    protected abstract MutablePicoContainer createPicoContainer();

    @Test
    public void testStringWorks() throws PicoException {
        MutablePicoContainer pico = this.createPicoContainer();
        pico.addComponent(String.class);
        Assert.assertEquals((Object)"", (Object)pico.getComponent(String.class));
    }

    @Test
    public void testMultiWithOnlySmallSatisfiedDependencyWorks() throws PicoException {
        MutablePicoContainer pico = this.createPicoContainer();
        pico.addComponent(Multi.class);
        pico.addComponent(One.class);
        pico.addComponent(Three.class);
        Multi multi = (Multi)pico.getComponent(Multi.class);
        Assert.assertEquals((Object)"three one", (Object)multi.message);
    }

    @Test
    public void testMultiWithBothSatisfiedDependencyWorks() throws PicoException {
        MutablePicoContainer pico = this.createPicoContainer();
        pico.addComponent(Multi.class);
        pico.addComponent(One.class);
        pico.addComponent(Two.class);
        pico.addComponent(Three.class);
        Multi multi = (Multi)pico.getComponent(Multi.class);
        Assert.assertEquals((Object)"one two three", (Object)multi.message);
    }

    @Test
    public void testMultiWithTwoEquallyBigSatisfiedDependenciesFails() throws PicoException {
        MutablePicoContainer pico = this.createPicoContainer();
        pico.addComponent(Multi.class);
        pico.addComponent(One.class);
        pico.addComponent(Two.class);
        try {
            pico.getComponent(Multi.class);
            Assert.fail();
        }
        catch (PicoCompositionException e) {
            Assert.assertEquals((Object)"3 satisfiable constructors is too many for 'class org.picocontainer.tck.AbstractMultipleConstructorTest$Multi'. Constructor List:[<init>(), <init>(org.picocontainer.tck.AbstractMultipleConstructorTest$One,org.picocontainer.tck.AbstractMultipleConstructorTest$Two), <init>(org.picocontainer.tck.AbstractMultipleConstructorTest$Two,org.picocontainer.tck.AbstractMultipleConstructorTest$One)]", (Object)e.getMessage());
        }
    }

    @Test
    public void testMultiWithSatisfyingDependencyAndParametersWorks() throws PicoException {
        MutablePicoContainer pico = this.createPicoContainer();
        pico.addComponent((Object)"MultiOneTwo", Multi.class, new Parameter[]{ComponentParameter.DEFAULT, new ComponentParameter((Object)"Two")});
        pico.addComponent((Object)"MultiTwoOne", Multi.class, new Parameter[]{new ComponentParameter((Object)"Two"), ComponentParameter.DEFAULT});
        pico.addComponent((Object)"MultiOneString", Multi.class, new Parameter[]{ComponentParameter.DEFAULT, new ConstantParameter((Object)"")});
        pico.addComponent((Object)"MultiOneInt", Multi.class, new Parameter[]{ComponentParameter.DEFAULT, new ConstantParameter((Object)5)});
        pico.addComponent((Object)"MultiNone", Multi.class, Parameter.ZERO);
        pico.addComponent(One.class);
        pico.addComponent((Object)"Two", Two.class, new Parameter[0]);
        Multi multiOneTwo = (Multi)pico.getComponent((Object)"MultiOneTwo");
        Assert.assertEquals((Object)"one two", (Object)multiOneTwo.message);
        Multi multiTwoOne = (Multi)pico.getComponent((Object)"MultiTwoOne");
        Assert.assertEquals((Object)"two one", (Object)multiTwoOne.message);
        Multi multiOneString = (Multi)pico.getComponent((Object)"MultiOneString");
        Assert.assertEquals((Object)"one string", (Object)multiOneString.message);
        Multi multiOneInt = (Multi)pico.getComponent((Object)"MultiOneInt");
        Assert.assertEquals((Object)"one int", (Object)multiOneInt.message);
        Multi multiNone = (Multi)pico.getComponent((Object)"MultiNone");
        Assert.assertEquals((Object)"none", (Object)multiNone.message);
    }

    public static class Three {
    }

    public static class Two {
    }

    public static class One {
    }

    public static final class Multi {
        public final String message;

        public Multi(One one, Two two, Three three) {
            this.message = "one two three";
        }

        public Multi(One one, Two two) {
            this.message = "one two";
        }

        public Multi(Two two, One one) {
            this.message = "two one";
        }

        public Multi(Two two, Three three) {
            this.message = "two three";
        }

        public Multi(Three three, One one) {
            this.message = "three one";
        }

        public Multi(One one, String string) {
            this.message = "one string";
        }

        public Multi(One one, int i) {
            this.message = "one int";
        }

        public Multi() {
            this.message = "none";
        }
    }
}

