/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.tck;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.picocontainer.Behavior;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentFactory;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.Disposable;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.NameBinding;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.PicoVerificationException;
import org.picocontainer.Startable;
import org.picocontainer.adapters.InstanceAdapter;
import org.picocontainer.behaviors.AbstractBehavior;
import org.picocontainer.behaviors.AdaptingBehavior;
import org.picocontainer.injectors.AbstractInjector;
import org.picocontainer.injectors.ConstructorInjector;
import org.picocontainer.injectors.SingleMemberInjector;
import org.picocontainer.lifecycle.NullLifecycleStrategy;
import org.picocontainer.monitors.NullComponentMonitor;
import org.picocontainer.parameters.BasicComponentParameter;
import org.picocontainer.parameters.ConstantParameter;
import org.picocontainer.parameters.NullParameter;
import org.picocontainer.testmodel.DependsOnTouchable;
import org.picocontainer.testmodel.SimpleTouchable;
import org.picocontainer.testmodel.Touchable;
import org.picocontainer.testmodel.Washable;
import org.picocontainer.testmodel.WashableTouchable;
import org.picocontainer.visitors.AbstractPicoVisitor;
import org.picocontainer.visitors.TraversalCheckingVisitor;
import org.picocontainer.visitors.VerifyingVisitor;

public abstract class AbstractPicoContainerTest {
    protected abstract MutablePicoContainer createPicoContainer(PicoContainer var1);

    protected final MutablePicoContainer createPicoContainerWithDependsOnTouchableOnly() throws PicoCompositionException {
        MutablePicoContainer pico = this.createPicoContainer(null);
        pico.addComponent(DependsOnTouchable.class);
        return pico;
    }

    protected final MutablePicoContainer createPicoContainerWithTouchableAndDependsOnTouchable() throws PicoCompositionException {
        MutablePicoContainer pico = this.createPicoContainerWithDependsOnTouchableOnly();
        pico.as(new Properties[]{Characteristics.CACHE}).addComponent(Touchable.class, SimpleTouchable.class, new Parameter[0]);
        return pico;
    }

    @Test
    public void testBasicInstantiationAndContainment() throws PicoException {
        MutablePicoContainer pico = this.createPicoContainerWithTouchableAndDependsOnTouchable();
        Assert.assertTrue((String)"Component should be instance of Touchable", (boolean)Touchable.class.isAssignableFrom(pico.getComponentAdapter(Touchable.class, (NameBinding)null).getComponentImplementation()));
    }

    @Test
    public void testRegisteredComponentsExistAndAreTheCorrectTypes() throws PicoException {
        MutablePicoContainer pico = this.createPicoContainerWithTouchableAndDependsOnTouchable();
        Assert.assertNotNull((String)"Container should have Touchable addComponent", (Object)pico.getComponentAdapter(Touchable.class, (NameBinding)null));
        Assert.assertNotNull((String)"Container should have DependsOnTouchable addComponent", (Object)pico.getComponentAdapter(DependsOnTouchable.class, (NameBinding)null));
        Assert.assertTrue((String)"Component should be instance of Touchable", (pico.getComponent(Touchable.class) != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Component should be instance of DependsOnTouchable", (pico.getComponent(DependsOnTouchable.class) != null ? 1 : 0) != 0);
        Assert.assertNull((String)"should not have non existent addComponent", (Object)pico.getComponentAdapter(Map.class, (NameBinding)null));
    }

    @Test
    public void testRegistersSingleInstance() throws PicoException {
        MutablePicoContainer pico = this.createPicoContainer(null);
        StringBuffer sb = new StringBuffer();
        pico.addComponent((Object)sb);
        Assert.assertSame((Object)sb, (Object)pico.getComponent(StringBuffer.class));
    }

    @Test
    public void testContainerIsSerializable() throws PicoException, IOException, ClassNotFoundException {
        this.getTouchableFromSerializedContainer();
    }

    private Touchable getTouchableFromSerializedContainer() throws IOException, ClassNotFoundException {
        MutablePicoContainer pico = this.createPicoContainerWithTouchableAndDependsOnTouchable();
        pico.addComponent((Object)"list", ArrayList.class, new Parameter[]{new ConstantParameter((Object)10)});
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(pico);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        pico = (MutablePicoContainer)ois.readObject();
        DependsOnTouchable dependsOnTouchable = (DependsOnTouchable)pico.getComponent(DependsOnTouchable.class);
        Assert.assertNotNull((Object)dependsOnTouchable);
        return (Touchable)pico.getComponent(Touchable.class);
    }

    @Test
    public void testSerializedContainerCanRetrieveImplementation() throws PicoException, IOException, ClassNotFoundException {
        Touchable touchable = this.getTouchableFromSerializedContainer();
        SimpleTouchable simpleTouchable = (SimpleTouchable)touchable;
        Assert.assertTrue((boolean)simpleTouchable.wasTouched);
    }

    @Test
    public void testGettingComponentWithMissingDependencyFails() throws PicoException {
        MutablePicoContainer picoContainer = this.createPicoContainerWithDependsOnTouchableOnly();
        try {
            picoContainer.getComponent(DependsOnTouchable.class);
            Assert.fail((String)"should need a Touchable");
        }
        catch (AbstractInjector.UnsatisfiableDependenciesException e) {
            Assert.assertSame((Object)picoContainer.getComponentAdapter(DependsOnTouchable.class, (NameBinding)null).getComponentImplementation(), (Object)e.getUnsatisfiableComponentAdapter().getComponentImplementation());
            Set unsatisfiableDependencies = e.getUnsatisfiableDependencies();
            Assert.assertEquals((long)1L, (long)unsatisfiableDependencies.size());
            List unsatisfied = (List)unsatisfiableDependencies.iterator().next();
            Assert.assertEquals((long)1L, (long)unsatisfied.size());
            Assert.assertEquals(Touchable.class, unsatisfied.get(0));
        }
    }

    @Test
    public void testDuplicateRegistration() {
        try {
            MutablePicoContainer pico = this.createPicoContainer(null);
            pico.addComponent(Object.class);
            pico.addComponent(Object.class);
            Assert.fail((String)"Should have failed with duplicate registration");
        }
        catch (PicoCompositionException e) {
            Assert.assertTrue((String)"Wrong key", (e.getMessage().indexOf(Object.class.toString()) > -1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testExternallyInstantiatedObjectsCanBeRegisteredAndLookedUp() throws PicoException {
        MutablePicoContainer pico = this.createPicoContainer(null);
        HashMap map = new HashMap();
        pico.as(this.getProperties()).addComponent(Map.class, map, new Parameter[0]);
        Assert.assertSame(map, (Object)pico.getComponent(Map.class));
    }

    @Test
    public void testAmbiguousResolution() throws PicoCompositionException {
        MutablePicoContainer pico = this.createPicoContainer(null);
        pico.addComponent((Object)"ping", String.class, new Parameter[0]);
        pico.addComponent((Object)"pong", (Object)"pang", new Parameter[0]);
        try {
            pico.getComponent(String.class);
        }
        catch (AbstractInjector.AmbiguousComponentResolutionException e) {
            Assert.assertTrue((e.getMessage().indexOf("java.lang.String") != -1 ? 1 : 0) != 0);
            Assert.assertTrue((e.getMessage().indexOf("<no-component>") != -1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLookupWithUnregisteredKeyReturnsNull() throws PicoCompositionException {
        MutablePicoContainer pico = this.createPicoContainer(null);
        Assert.assertNull((Object)pico.getComponent(String.class));
    }

    @Test
    public void testLookupWithUnregisteredTypeReturnsNull() throws PicoCompositionException {
        MutablePicoContainer pico = this.createPicoContainer(null);
        Assert.assertNull((Object)pico.getComponent(String.class));
    }

    @Test
    public void testUnsatisfiableDependenciesExceptionGivesVerboseEnoughErrorMessage() {
        MutablePicoContainer pico = this.createPicoContainer(null);
        pico.addComponent(ComponentD.class);
        try {
            pico.getComponent(ComponentD.class);
        }
        catch (AbstractInjector.UnsatisfiableDependenciesException e) {
            Set unsatisfiableDependencies = e.getUnsatisfiableDependencies();
            Assert.assertEquals((long)1L, (long)unsatisfiableDependencies.size());
            List list = (List)unsatisfiableDependencies.iterator().next();
            ArrayList<Class> expectedList = new ArrayList<Class>(2);
            expectedList.add(ComponentE.class);
            expectedList.add(ComponentB.class);
            Assert.assertEquals(expectedList, (Object)list);
        }
    }

    @Test
    public void testUnsatisfiableDependenciesExceptionGivesUnsatisfiedDependencyTypes() {
        Type unsatisfiedDependencyType;
        ArrayList<Class> expectedList;
        List list;
        Set unsatisfiableDependencies;
        MutablePicoContainer pico = this.createPicoContainer(null);
        pico.addComponent(ComponentD.class);
        try {
            pico.getComponent(ComponentD.class);
        }
        catch (AbstractInjector.UnsatisfiableDependenciesException e) {
            unsatisfiableDependencies = e.getUnsatisfiableDependencies();
            Assert.assertEquals((long)1L, (long)unsatisfiableDependencies.size());
            list = (List)unsatisfiableDependencies.iterator().next();
            expectedList = new ArrayList<Class>(2);
            expectedList.add(ComponentE.class);
            expectedList.add(ComponentB.class);
            Assert.assertEquals(expectedList, (Object)list);
            unsatisfiedDependencyType = e.getUnsatisfiedDependencyType();
            Assert.assertNotNull((Object)unsatisfiedDependencyType);
            Assert.assertEquals(ComponentE.class, (Object)unsatisfiedDependencyType);
        }
        pico.addComponent(ComponentE.class);
        try {
            pico.getComponent(ComponentD.class);
        }
        catch (AbstractInjector.UnsatisfiableDependenciesException e) {
            unsatisfiableDependencies = e.getUnsatisfiableDependencies();
            Assert.assertEquals((long)1L, (long)unsatisfiableDependencies.size());
            list = (List)unsatisfiableDependencies.iterator().next();
            expectedList = new ArrayList(2);
            expectedList.add(ComponentE.class);
            expectedList.add(ComponentB.class);
            Assert.assertEquals(expectedList, (Object)list);
            unsatisfiedDependencyType = e.getUnsatisfiedDependencyType();
            Assert.assertNotNull((Object)unsatisfiedDependencyType);
            Assert.assertEquals(ComponentB.class, (Object)unsatisfiedDependencyType);
        }
    }

    @Test
    public void testCyclicDependencyThrowsCyclicDependencyException() {
        AbstractPicoContainerTest.assertCyclicDependencyThrowsCyclicDependencyException(this.createPicoContainer(null));
    }

    private static void assertCyclicDependencyThrowsCyclicDependencyException(MutablePicoContainer pico) {
        pico.addComponent(ComponentB.class);
        pico.addComponent(ComponentD.class);
        pico.addComponent(ComponentE.class);
        try {
            pico.getComponent(ComponentD.class);
            Assert.fail((String)"CyclicDependencyException expected");
        }
        catch (AbstractInjector.CyclicDependencyException e) {
            List<Class> dependencies = Arrays.asList(ComponentD.class, ComponentE.class, ComponentD.class);
            List<Class> reportedDependencies = Arrays.asList(e.getDependencies());
            Assert.assertEquals(dependencies, reportedDependencies);
        }
        catch (StackOverflowError e) {
            Assert.fail();
        }
    }

    @Test
    public void testCyclicDependencyThrowsCyclicDependencyExceptionWithParentContainer() {
        MutablePicoContainer pico = this.createPicoContainer((PicoContainer)this.createPicoContainer(null));
        AbstractPicoContainerTest.assertCyclicDependencyThrowsCyclicDependencyException(pico);
    }

    @Test
    public void testRemovalNonRegisteredComponentAdapterWorksAndReturnsNull() {
        MutablePicoContainer picoContainer = this.createPicoContainer(null);
        Assert.assertNull((Object)picoContainer.removeComponent((Object)"COMPONENT DOES NOT EXIST"));
    }

    @Test
    public void testComponentAdapterRegistrationOrderIsMaintained() throws NoSuchMethodException {
        ConstructorInjector c1 = new ConstructorInjector((Object)"1", Object.class, null, (ComponentMonitor)new NullComponentMonitor(), (LifecycleStrategy)new NullLifecycleStrategy(), false);
        ConstructorInjector c2 = new ConstructorInjector((Object)"2", String.class, null, (ComponentMonitor)new NullComponentMonitor(), (LifecycleStrategy)new NullLifecycleStrategy(), false);
        MutablePicoContainer picoContainer = this.createPicoContainer(null);
        picoContainer.addAdapter((ComponentAdapter)c1).addAdapter((ComponentAdapter)c2);
        Collection list2 = picoContainer.getComponentAdapters();
        Assert.assertEquals((long)2L, (long)list2.size());
        Assert.assertEquals((Object)c1.getComponentKey(), (Object)((ComponentAdapter)list2.toArray()[0]).getComponentKey());
        Assert.assertEquals((Object)c2.getComponentKey(), (Object)((ComponentAdapter)list2.toArray()[1]).getComponentKey());
        picoContainer.getComponents();
        Assert.assertFalse((String)"instances should be created in same order as adapters are created", (boolean)(picoContainer.getComponents().get(0) instanceof String));
        Assert.assertTrue((String)"instances should be created in same order as adapters are created", (boolean)(picoContainer.getComponents().get(1) instanceof String));
        MutablePicoContainer reversedPicoContainer = this.createPicoContainer(null);
        reversedPicoContainer.addAdapter((ComponentAdapter)c2);
        reversedPicoContainer.addAdapter((ComponentAdapter)c1);
        list2 = reversedPicoContainer.getComponentAdapters();
        Assert.assertEquals((long)2L, (long)list2.size());
        Assert.assertEquals((Object)c2.getComponentKey(), (Object)((ComponentAdapter)list2.toArray()[0]).getComponentKey());
        Assert.assertEquals((Object)c1.getComponentKey(), (Object)((ComponentAdapter)list2.toArray()[1]).getComponentKey());
        reversedPicoContainer.getComponents();
        Assert.assertTrue((String)"instances should be created in same order as adapters are created", (boolean)(reversedPicoContainer.getComponents().get(0) instanceof String));
        Assert.assertFalse((String)"instances should be created in same order as adapters are created", (boolean)(reversedPicoContainer.getComponents().get(1) instanceof String));
    }

    @Test
    public void testSameInstanceCanBeUsedAsDifferentTypeWhenCaching() {
        MutablePicoContainer pico = this.createPicoContainer(null);
        pico.as(new Properties[]{Characteristics.CACHE}).addComponent((Object)"wt", WashableTouchable.class, new Parameter[0]);
        pico.addComponent((Object)"nw", NeedsWashable.class, new Parameter[0]);
        pico.as(new Properties[]{Characteristics.CACHE}).addComponent((Object)"nt", NeedsTouchable.class, new Parameter[0]);
        NeedsWashable nw = (NeedsWashable)pico.getComponent((Object)"nw");
        NeedsTouchable nt = (NeedsTouchable)pico.getComponent((Object)"nt");
        Assert.assertSame((Object)nw.washable, (Object)nt.touchable);
    }

    @Test
    public void testRegisterComponentWithObjectBadType() throws PicoCompositionException {
        MutablePicoContainer pico = this.createPicoContainer(null);
        try {
            pico.addComponent(Serializable.class, new Object(), new Parameter[0]);
            Assert.fail((String)"Shouldn't be able to register an Object.class as Serializable because it is not, it does not implement it, Object.class does not implement much.");
        }
        catch (ClassCastException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testPico52() {
        MutablePicoContainer pico = this.createPicoContainer(null);
        pico.addComponent((Object)"foo", JMSService.class, new Parameter[]{new ConstantParameter((Object)"0"), new ConstantParameter((Object)"something")});
        JMSService jms = (JMSService)pico.getComponent((Object)"foo");
        Assert.assertEquals((Object)"0", (Object)jms.serverid);
        Assert.assertEquals((Object)"something", (Object)jms.path);
    }

    @Test
    public void testAggregatedVerificationException() {
        MutablePicoContainer pico = this.createPicoContainer(null);
        pico.addComponent(ComponentA.class);
        pico.addComponent(ComponentE.class);
        try {
            new VerifyingVisitor().traverse((Object)pico);
            Assert.fail((String)"we expect a PicoVerificationException");
        }
        catch (PicoVerificationException e) {
            List nested = e.getNestedExceptions();
            Assert.assertEquals((long)2L, (long)nested.size());
            Assert.assertTrue((-1 != e.getMessage().indexOf(ComponentA.class.getName()) ? 1 : 0) != 0);
            Assert.assertTrue((-1 != e.getMessage().indexOf(ComponentE.class.getName()) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testShouldReturnNullWhenUnregistereingUnmanagedComponent() {
        MutablePicoContainer pico = this.createPicoContainer(null);
        Assert.assertNull((Object)pico.removeComponentByInstance((Object)"yo"));
    }

    @Test
    public void testShouldReturnNullForComponentAdapterOfUnregisteredType() {
        MutablePicoContainer pico = this.createPicoContainer(null);
        Assert.assertNull((Object)pico.getComponent(List.class));
    }

    @Test
    public void testShouldReturnNonMutableParent() {
        DefaultPicoContainer parent = new DefaultPicoContainer();
        MutablePicoContainer picoContainer = this.createPicoContainer((PicoContainer)parent);
        Assert.assertNotSame((Object)parent, (Object)picoContainer.getParent());
        Assert.assertFalse((boolean)(picoContainer.getParent() instanceof MutablePicoContainer));
    }

    @Test
    public void testContainerCascadesDefaultLifecycle() {
        MutablePicoContainer picoContainer = this.createPicoContainer(null);
        Foo foo = new Foo();
        picoContainer.addComponent((Object)foo);
        picoContainer.start();
        Assert.assertEquals((Object)true, (Object)foo.started);
        picoContainer.stop();
        Assert.assertEquals((Object)true, (Object)foo.stopped);
        picoContainer.dispose();
        Assert.assertEquals((Object)true, (Object)foo.disposed);
    }

    @Test
    public void testComponentInstancesFromParentsAreNotDirectlyAccessible2() {
        MutablePicoContainer a = this.createPicoContainer(null);
        MutablePicoContainer b = this.createPicoContainer((PicoContainer)a);
        MutablePicoContainer c = this.createPicoContainer((PicoContainer)b);
        Object ao = new Object();
        Object bo = new Object();
        Object co = new Object();
        a.addComponent((Object)"a", ao, new Parameter[0]);
        b.addComponent((Object)"b", bo, new Parameter[0]);
        c.addComponent((Object)"c", co, new Parameter[0]);
        Assert.assertEquals((long)1L, (long)a.getComponents().size());
        Assert.assertEquals((long)1L, (long)b.getComponents().size());
        Assert.assertEquals((long)1L, (long)c.getComponents().size());
    }

    @Test
    public void testStartStopAndDisposeCascadedtoChildren() {
        MutablePicoContainer parent = this.createPicoContainer(null);
        parent.addComponent((Object)new StringBuffer());
        MutablePicoContainer child = this.createPicoContainer((PicoContainer)parent);
        parent.addChildContainer((PicoContainer)child);
        child.addComponent(LifeCycleMonitoring.class);
        parent.start();
        try {
            child.start();
            Assert.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)"child already started", (Object)"Cannot start.  Current container state was: STARTED", (Object)e.getMessage());
        }
        parent.stop();
        try {
            child.stop();
            Assert.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)"child not started", (Object)"Cannot stop.  Current container state was: STOPPED", (Object)e.getMessage());
        }
        parent.dispose();
        try {
            child.dispose();
            Assert.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)"child already disposed", (Object)"Cannot dispose.  Current lifecycle state is: DISPOSED", (Object)e.getMessage());
        }
    }

    @Test
    public void testMakingOfChildContainer() {
        MutablePicoContainer parent = this.createPicoContainer(null);
        MutablePicoContainer child = parent.makeChildContainer();
        Assert.assertNotNull((Object)child);
    }

    @Test
    public void testMakingOfChildContainerPercolatesLifecycleManager() {
        MutablePicoContainer parent = this.createPicoContainer(null);
        parent.addComponent((Object)"one", TestLifecycleComponent.class, new Parameter[0]);
        MutablePicoContainer child = parent.makeChildContainer();
        Assert.assertNotNull((Object)child);
        child.addComponent((Object)"two", TestLifecycleComponent.class, new Parameter[0]);
        parent.start();
        try {
            child.start();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)"child already started", (Object)"Cannot start.  Current container state was: STARTED", (Object)e.getMessage());
        }
    }

    @Test
    public void testStartStopAndDisposeNotCascadedtoRemovedChildren() {
        MutablePicoContainer parent = this.createPicoContainer(null);
        parent.addComponent((Object)new StringBuffer());
        StringBuffer sb = (StringBuffer)parent.getComponents(StringBuffer.class).get(0);
        MutablePicoContainer child = this.createPicoContainer((PicoContainer)parent);
        Assert.assertEquals((Object)parent, (Object)parent.addChildContainer((PicoContainer)child));
        child.addComponent(LifeCycleMonitoring.class);
        Assert.assertTrue((boolean)parent.removeChildContainer((PicoContainer)child));
        parent.start();
        Assert.assertTrue((sb.toString().indexOf("-started") == -1 ? 1 : 0) != 0);
        parent.stop();
        Assert.assertTrue((sb.toString().indexOf("-stopped") == -1 ? 1 : 0) != 0);
        parent.dispose();
        Assert.assertTrue((sb.toString().indexOf("-disposed") == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testShouldCascadeStartStopAndDisposeToChild() {
        StringBuffer sb = new StringBuffer();
        MutablePicoContainer parent = this.createPicoContainer(null);
        parent.addComponent((Object)sb);
        parent.addComponent(Map.class, HashMap.class, new Parameter[0]);
        MutablePicoContainer child = parent.makeChildContainer();
        child.addComponent(LifeCycleMonitoring.class);
        Map map = (Map)parent.getComponent(Map.class);
        Assert.assertNotNull((Object)map);
        parent.start();
        try {
            child.start();
            Assert.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)"child already started", (Object)"Cannot start.  Current container state was: STARTED", (Object)e.getMessage());
        }
        parent.stop();
        try {
            child.stop();
            Assert.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)"child not started", (Object)"Cannot stop.  Current container state was: STOPPED", (Object)e.getMessage());
        }
        parent.dispose();
        try {
            child.dispose();
            Assert.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)"child already disposed", (Object)"Cannot dispose.  Current lifecycle state is: DISPOSED", (Object)e.getMessage());
        }
    }

    protected abstract Properties[] getProperties();

    @Test
    public void testAcceptImplementsBreadthFirstStrategy() {
        MutablePicoContainer parent = this.createPicoContainer(null);
        MutablePicoContainer child = parent.makeChildContainer();
        ComponentAdapter hashMapAdapter = parent.as(this.getProperties()).addAdapter((ComponentAdapter)new ConstructorInjector(HashMap.class, HashMap.class, null, (ComponentMonitor)new NullComponentMonitor(), (LifecycleStrategy)new NullLifecycleStrategy(), false)).getComponentAdapter(HashMap.class, (NameBinding)null);
        ComponentAdapter hashSetAdapter = parent.as(this.getProperties()).addAdapter((ComponentAdapter)new ConstructorInjector(HashSet.class, HashSet.class, null, (ComponentMonitor)new NullComponentMonitor(), (LifecycleStrategy)new NullLifecycleStrategy(), false)).getComponentAdapter(HashSet.class, (NameBinding)null);
        InstanceAdapter instanceAdapter = new InstanceAdapter(String.class, (Object)"foo", (LifecycleStrategy)new NullLifecycleStrategy(), (ComponentMonitor)new NullComponentMonitor());
        ComponentAdapter stringAdapter = parent.as(this.getProperties()).addAdapter((ComponentAdapter)instanceAdapter).getComponentAdapter(instanceAdapter.getComponentKey());
        ComponentAdapter arrayListAdapter = child.as(this.getProperties()).addAdapter((ComponentAdapter)new ConstructorInjector(ArrayList.class, ArrayList.class, null, (ComponentMonitor)new NullComponentMonitor(), (LifecycleStrategy)new NullLifecycleStrategy(), false)).getComponentAdapter(ArrayList.class, (NameBinding)null);
        BasicComponentParameter componentParameter = BasicComponentParameter.BASIC_DEFAULT;
        ConstantParameter throwableParameter = new ConstantParameter((Object)new Throwable("bar"));
        ConstructorInjector ci = new ConstructorInjector(Exception.class, Exception.class, new Parameter[]{componentParameter, throwableParameter}, (ComponentMonitor)new NullComponentMonitor(), (LifecycleStrategy)new NullLifecycleStrategy(), false);
        ComponentAdapter exceptionAdapter = child.as(this.getProperties()).addAdapter((ComponentAdapter)ci).getComponentAdapter(Exception.class, (NameBinding)null);
        ArrayList expectedList = new ArrayList();
        this.addContainers(expectedList);
        this.addDefaultComponentFactories(expectedList);
        expectedList.add(hashMapAdapter.getClass());
        expectedList.add(hashSetAdapter.getClass());
        expectedList.add(stringAdapter.getClass());
        this.addContainers(expectedList);
        this.addDefaultComponentFactories(expectedList);
        expectedList.add(arrayListAdapter.getClass());
        expectedList.add(exceptionAdapter.getClass());
        expectedList.add(componentParameter.getClass());
        expectedList.add(throwableParameter.getClass());
        LinkedList<Object> visitedList = new LinkedList<Object>();
        RecordingStrategyVisitor visitor = new RecordingStrategyVisitor(visitedList);
        visitor.traverse(parent);
        Assert.assertEquals((long)expectedList.size(), (long)visitedList.size());
        for (Class clazz : expectedList) {
            Assert.assertTrue((boolean)visitedList.remove(clazz));
        }
        Assert.assertEquals((long)0L, (long)visitedList.size());
    }

    @Test
    public void testAcceptIsAbortable() {
        MutablePicoContainer parent = this.createPicoContainer(null);
        MutablePicoContainer child = parent.makeChildContainer();
        child.addComponent((Object)"This is a test");
        TraversalCheckingVisitor parentComponentCountingVisitor = new TraversalCheckingVisitor(){
            private int containerCount = 0;

            public void visitComponentAdapter(ComponentAdapter<?> componentAdapter) {
                if (this.containerCount == 0) {
                    Assert.fail((String)"Should have visited a container first");
                }
                Assert.fail((String)"Should never have visited an adapter.");
            }

            public boolean visitContainer(PicoContainer pico) {
                ++this.containerCount;
                return this.containerCount <= 1;
            }
        };
        parentComponentCountingVisitor.traverse((Object)parent);
    }

    protected void addContainers(List expectedList) {
        expectedList.add(DefaultPicoContainer.class);
    }

    protected void addDefaultComponentFactories(List expectedList) {
        expectedList.add(AdaptingBehavior.class);
    }

    @Test
    public void testAmbiguousDependencies() throws PicoCompositionException {
        MutablePicoContainer pico = this.createPicoContainer(null);
        pico.addComponent(SimpleTouchable.class);
        pico.addComponent(DerivedTouchable.class);
        pico.addComponent(DependsOnTouchable.class);
        try {
            pico.getComponent(DependsOnTouchable.class);
            Assert.fail((String)"DependsOnTouchable should have been confused about the two Touchables");
        }
        catch (AbstractInjector.AmbiguousComponentResolutionException e) {
            List<Object> componentImplementations = Arrays.asList(e.getAmbiguousComponentKeys());
            Assert.assertTrue((boolean)componentImplementations.contains(DerivedTouchable.class));
            Assert.assertTrue((boolean)componentImplementations.contains(SimpleTouchable.class));
            Assert.assertTrue((e.getMessage().indexOf(DerivedTouchable.class.getName()) != -1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNoArgConstructorToBeSelected() {
        MutablePicoContainer pico = this.createPicoContainer(null);
        pico.addComponent(ComponentA.class);
        pico.addComponent(NonGreedyClass.class, NonGreedyClass.class, Parameter.ZERO);
        NonGreedyClass instance = (NonGreedyClass)pico.getComponent(NonGreedyClass.class);
        Assert.assertNotNull((Object)instance);
    }

    @Test
    public void testNullConstantParameter() {
        MutablePicoContainer pico = this.createPicoContainer(null);
        pico.addComponent(ConstantParameterTestService.class, ConstantParameterTestService.class, new Parameter[]{NullParameter.INSTANCE});
        ConstantParameterTestService service = (ConstantParameterTestService)pico.getComponent(ConstantParameterTestService.class);
        Assert.assertNotNull((Object)service);
        Assert.assertNull((Object)service.getArg());
    }

    @Test(expected=SingleMemberInjector.ParameterCannotBeNullException.class)
    public void testNullConstantParametersDoNotInjectOnPrimitives() {
        MutablePicoContainer pico = this.createPicoContainer(null);
        pico.addComponent(PrimitiveConstructor.class, PrimitiveConstructor.class, new Parameter[]{NullParameter.INSTANCE});
        pico.getComponent(PrimitiveConstructor.class);
    }

    @Test
    public void testNullValuesDoNotInject() {
        MutablePicoContainer pico = this.createPicoContainer(null);
        pico.addComponent(ConstantParameterTestService.class, ConstantParameterTestService.class, new Parameter[]{new ConstantParameter(null)});
        try {
            ConstantParameterTestService service = (ConstantParameterTestService)pico.getComponent(ConstantParameterTestService.class);
            Assert.fail((String)("Should have thrown unsatisfiable dependencies exception.  Instead got " + service + " as a return value"));
        }
        catch (AbstractInjector.UnsatisfiableDependenciesException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testNullComponentsDoNotInject() {
        MutablePicoContainer pico = this.createPicoContainer(null).addComponent(ComponentA.class).addComponent(ComponentB.class);
        try {
            pico.addComponent(ComponentC.class, null, new Parameter[0]);
            Assert.fail((String)"Pico should not have been able to register null component instance");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    public static class PrimitiveConstructor {
        public PrimitiveConstructor(int number) {
        }
    }

    public static class ConstantParameterTestService {
        private final String arg;

        public ConstantParameterTestService(String arg) {
            this.arg = arg;
        }

        public String getArg() {
            return this.arg;
        }
    }

    public static final class NonGreedyClass {
        public final int value = 0;

        public NonGreedyClass() {
        }

        public NonGreedyClass(ComponentA component) {
            Assert.fail((String)("Greedy Constructor should never have been called.  Instead got: " + component));
        }
    }

    public static class DerivedTouchable
    extends SimpleTouchable {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RecordingStrategyVisitor
    extends AbstractPicoVisitor {
        private final List<Object> list;

        public RecordingStrategyVisitor(List<Object> list) {
            this.list = list;
        }

        public boolean visitContainer(PicoContainer pico) {
            this.list.add(pico.getClass());
            return true;
        }

        public void visitComponentAdapter(ComponentAdapter componentAdapter) {
            this.list.add(componentAdapter.getClass());
        }

        public void visitComponentFactory(ComponentFactory componentFactory) {
            this.list.add(componentFactory.getClass());
        }

        public void visitParameter(Parameter parameter) {
            this.list.add(parameter.getClass());
        }
    }

    public static final class LifeCycleMonitoring
    implements Startable,
    Disposable {
        final StringBuffer sb;

        public LifeCycleMonitoring(StringBuffer sb) {
            this.sb = sb;
            sb.append("-instantiated");
        }

        public void start() {
            this.sb.append("-started");
        }

        public void stop() {
            this.sb.append("-stopped");
        }

        public void dispose() {
            this.sb.append("-disposed");
        }
    }

    public static class TestLifecycleComponent
    implements Startable {
        public boolean started;

        public void start() {
            this.started = true;
        }

        public void stop() {
        }
    }

    public static final class TestBehavior
    extends AbstractBehavior
    implements Behavior {
        public final ArrayList<PicoContainer> started = new ArrayList();

        public TestBehavior(ComponentAdapter delegate) {
            super(delegate);
        }

        public void start(PicoContainer node) {
            this.started.add(node);
        }

        public void stop(PicoContainer node) {
        }

        public void dispose(PicoContainer node) {
        }

        public boolean componentHasLifecycle() {
            return true;
        }

        public String getDescriptor() {
            return null;
        }
    }

    class Foo
    implements Startable,
    Disposable {
        public boolean started;
        public boolean stopped;
        public boolean disposed;

        Foo() {
        }

        public void start() {
            this.started = true;
        }

        public void stop() {
            this.stopped = true;
        }

        public void dispose() {
            this.disposed = true;
        }
    }

    public static class ContainerDependency {
        public ContainerDependency(PicoContainer container) {
            Assert.assertNotNull((Object)container);
        }
    }

    public static class ComponentF {
        public ComponentF(ComponentA a) {
            Assert.assertNotNull((Object)a);
        }
    }

    public static class ComponentE {
        public ComponentE(ComponentD d) {
            Assert.assertNotNull((Object)d);
        }
    }

    public static class ComponentD {
        public ComponentD(ComponentE e, ComponentB b) {
            Assert.assertNotNull((Object)e);
            Assert.assertNotNull((Object)b);
        }
    }

    public static class ComponentC {
    }

    public static class ComponentB {
    }

    public static class ComponentA {
        public final ComponentC c;

        public ComponentA(ComponentB b, ComponentC c) {
            this.c = c;
            Assert.assertNotNull((Object)b);
            Assert.assertNotNull((Object)c);
        }
    }

    public static class JMSService {
        public final String serverid;
        public final String path;

        public JMSService(String serverid, String path) {
            this.serverid = serverid;
            this.path = path;
        }
    }

    public static final class NeedsWashable {
        public final Washable washable;

        public NeedsWashable(Washable washable) {
            this.washable = washable;
        }
    }

    public static final class NeedsTouchable {
        public final Touchable touchable;

        public NeedsTouchable(Touchable touchable) {
            this.touchable = touchable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListAdder {
        public ListAdder(Collection<String> list) {
            list.add("something");
        }
    }
}

