/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.aggregate;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Function;
import java.util.function.Predicate;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.ClassFilter;
import org.pitest.classpath.ClassPath;
import org.pitest.classpath.CodeSource;
import org.pitest.classpath.DirectoryClassPathRoot;
import org.pitest.classpath.PathFilter;
import org.pitest.classpath.ProjectClassPaths;
import org.pitest.functional.FCollection;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.config.DefaultCodePathPredicate;
import org.pitest.mutationtest.config.DefaultDependencyPathPredicate;
import org.pitest.mutationtest.config.SettingsFactory;
import org.pitest.util.Glob;

class CodeSourceAggregator {
    private final Collection<File> compiledCodeDirectories;
    private final SettingsFactory settings;

    CodeSourceAggregator(SettingsFactory settings, Collection<File> compiledCodeDirectories) {
        this.settings = settings;
        this.compiledCodeDirectories = Collections.unmodifiableCollection(compiledCodeDirectories);
    }

    public CodeSource createCodeSource() {
        return this.settings.createCodeSource(this.createProjectClassPaths());
    }

    public ProjectClassPaths createProjectClassPaths() {
        ClassPath classPath = new ClassPath(this.compiledCodeDirectories);
        Predicate<String> classPredicate = this.createClassPredicate();
        DefaultCodePathPredicate pathPredicate = new DefaultCodePathPredicate();
        return new ProjectClassPaths(classPath, new ClassFilter(classPredicate, classPredicate), new PathFilter((Predicate)pathPredicate, Prelude.not((Predicate)new DefaultDependencyPathPredicate())));
    }

    private Predicate<String> createClassPredicate() {
        HashSet classes = new HashSet();
        for (File buildOutputDirectory : this.compiledCodeDirectories) {
            if (!buildOutputDirectory.exists()) continue;
            DirectoryClassPathRoot dcRoot = new DirectoryClassPathRoot(buildOutputDirectory);
            classes.addAll(FCollection.map((Iterable)dcRoot.classNames(), this.toPredicate()));
        }
        return Prelude.or((Iterable)FCollection.map(classes, (Function)Glob.toGlobPredicate()));
    }

    private Function<String, String> toPredicate() {
        return a -> ClassName.fromString((String)a).getPackage().asJavaName() + ".*";
    }
}

