/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.aggregate;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.pitest.aggregate.AggregationResult;
import org.pitest.aggregate.BlockCoverageDataLoader;
import org.pitest.aggregate.CodeSourceAggregator;
import org.pitest.aggregate.DataLoader;
import org.pitest.aggregate.MutationResultDataLoader;
import org.pitest.aggregate.ReportAggregationException;
import org.pitest.aggregate.ReportAggregatorResultListener;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.classpath.CodeSource;
import org.pitest.coverage.BlockCoverage;
import org.pitest.coverage.CoverageData;
import org.pitest.coverage.LineMap;
import org.pitest.coverage.ReportCoverage;
import org.pitest.coverage.analysis.LineMapper;
import org.pitest.mutationtest.ClassMutationResults;
import org.pitest.mutationtest.MutationMetaData;
import org.pitest.mutationtest.MutationResultListener;
import org.pitest.mutationtest.SourceLocator;
import org.pitest.mutationtest.build.CoverageTransformer;
import org.pitest.mutationtest.config.PluginServices;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.mutationtest.config.SettingsFactory;
import org.pitest.mutationtest.report.html.MutationHtmlReportListener;
import org.pitest.mutationtest.tooling.SmartSourceLocator;
import org.pitest.util.Log;
import org.pitest.util.ResultOutputStrategy;

public final class ReportAggregator {
    private final SettingsFactory settings;
    private final ResultOutputStrategy resultOutputStrategy;
    private final DataLoader<BlockCoverage> blockCoverageLoader;
    private final Set<File> mutationFiles;
    private final Collection<File> sourceCodeDirectories;
    private final CodeSourceAggregator codeSourceAggregator;
    private final Charset inputCharset;
    private final Charset outputCharset;

    private ReportAggregator(SettingsFactory settings, ResultOutputStrategy resultOutputStrategy, Set<File> lineCoverageFiles, Set<File> mutationFiles, Set<File> sourceCodeDirs, Set<File> compiledCodeDirs, Charset inputCharset, Charset outputCharset) {
        this.settings = settings;
        this.resultOutputStrategy = resultOutputStrategy;
        this.blockCoverageLoader = new BlockCoverageDataLoader(lineCoverageFiles);
        this.mutationFiles = mutationFiles;
        this.sourceCodeDirectories = Collections.unmodifiableCollection(new HashSet<File>(sourceCodeDirs));
        this.codeSourceAggregator = new CodeSourceAggregator(settings, new HashSet<File>(compiledCodeDirs));
        this.inputCharset = inputCharset;
        this.outputCharset = outputCharset;
    }

    public AggregationResult aggregateReport() throws ReportAggregationException {
        SmartSourceLocator sourceLocator = new SmartSourceLocator(this.asPaths(this.sourceCodeDirectories), this.inputCharset);
        boolean partialCoverage = this.scanForPartialCoverageFlag(this.mutationFiles);
        MutationResultListener mutationResultListener = this.createResultListener((SourceLocator)sourceLocator, Collections.emptySet(), partialCoverage);
        ReportAggregatorResultListener reportAggregatorResultListener = new ReportAggregatorResultListener();
        reportAggregatorResultListener.runStart();
        mutationResultListener.runStart();
        for (File file : this.mutationFiles) {
            sourceLocator.sourceRootHint(file.getParentFile().toPath());
            MutationResultDataLoader loader = new MutationResultDataLoader(Arrays.asList(file));
            MutationMetaData mutationMetaData = new MutationMetaData(new ArrayList(loader.loadData()));
            for (ClassMutationResults classResult : mutationMetaData.toClassResults()) {
                reportAggregatorResultListener.handleMutationResult(classResult);
                mutationResultListener.handleMutationResult(classResult);
            }
        }
        reportAggregatorResultListener.runEnd();
        mutationResultListener.runEnd();
        return reportAggregatorResultListener.result();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean scanForPartialCoverageFlag(Set<File> mutationFiles) {
        Iterator<File> iterator = mutationFiles.iterator();
        while (iterator.hasNext()) {
            File each = iterator.next();
            try {
                Stream<String> lines = Files.lines(each.toPath());
                Throwable throwable = null;
                try {
                    if (!lines.anyMatch(l -> l.contains("<mutations partial=\"false\""))) continue;
                    boolean bl = false;
                    return bl;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (lines == null) continue;
                    if (throwable != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    lines.close();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return true;
    }

    private MutationResultListener createResultListener(SourceLocator sourceLocator, Collection<String> mutatorNames, boolean partialCoverage) throws ReportAggregationException {
        CodeSource codeSource = this.codeSourceAggregator.createCodeSource();
        ReportCoverage coverageDatabase = this.calculateCoverage(codeSource);
        return new MutationHtmlReportListener(this.outputCharset, coverageDatabase, this.resultOutputStrategy, mutatorNames, partialCoverage, new SourceLocator[]{sourceLocator});
    }

    private Collection<Path> asPaths(Collection<File> files) {
        return files.stream().map(File::toPath).collect(Collectors.toList());
    }

    private ReportCoverage calculateCoverage(CodeSource codeSource) throws ReportAggregationException {
        try {
            Collection coverageData = this.blockCoverageLoader.loadData().stream().map(BlockCoverage::getBlock).collect(Collectors.toList());
            CoverageData cd = new CoverageData(codeSource, (LineMap)new LineMapper((ClassByteArraySource)codeSource));
            cd.loadBlockDataOnly(coverageData);
            return this.transformCoverage(cd);
        }
        catch (Exception e) {
            throw new ReportAggregationException(e.getMessage(), e);
        }
    }

    private ReportCoverage transformCoverage(CoverageData cd) {
        CoverageTransformer transformer = this.settings.createCoverageTransformer(this.codeSourceAggregator.createCodeSource());
        return transformer.transform((ReportCoverage)cd);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final Logger LOG = Log.getLogger();
        private ResultOutputStrategy resultOutputStrategy;
        private final Set<File> lineCoverageFiles = new HashSet<File>();
        private final Set<File> mutationResultsFiles = new HashSet<File>();
        private final Set<File> sourceCodeDirectories = new HashSet<File>();
        private final Set<File> compiledCodeDirectories = new HashSet<File>();
        private Charset inputCharset = Charset.defaultCharset();
        private Charset outputCharset = Charset.defaultCharset();

        public Builder inputCharSet(Charset inputCharset) {
            this.inputCharset = inputCharset;
            return this;
        }

        public Builder outputCharset(Charset outputCharset) {
            this.outputCharset = outputCharset;
            return this;
        }

        public Builder resultOutputStrategy(ResultOutputStrategy resultOutputStrategy) {
            this.resultOutputStrategy = resultOutputStrategy;
            return this;
        }

        public Builder lineCoverageFiles(List<File> lineCoverageFiles) {
            this.lineCoverageFiles.clear();
            for (File file : lineCoverageFiles) {
                this.addLineCoverageFile(file);
            }
            return this;
        }

        public Builder addLineCoverageFile(File lineCoverageFile) {
            this.validateFile(lineCoverageFile);
            if (lineCoverageFile.exists()) {
                this.lineCoverageFiles.add(lineCoverageFile);
            } else {
                LOG.info("ignoring absent line coverage file " + lineCoverageFile.getAbsolutePath());
            }
            return this;
        }

        public Builder mutationResultsFiles(List<File> mutationResultsFiles) {
            this.mutationResultsFiles.clear();
            for (File file : mutationResultsFiles) {
                this.addMutationResultsFile(file);
            }
            return this;
        }

        public Builder addMutationResultsFile(File mutationResultsFile) {
            this.validateFile(mutationResultsFile);
            if (mutationResultsFile.exists()) {
                this.mutationResultsFiles.add(mutationResultsFile);
            } else {
                LOG.info("ignoring absent mutation results file " + mutationResultsFile.getAbsolutePath());
            }
            return this;
        }

        public Builder sourceCodeDirectories(List<File> sourceCodeDirectories) {
            this.sourceCodeDirectories.clear();
            for (File file : sourceCodeDirectories) {
                this.addSourceCodeDirectory(file);
            }
            return this;
        }

        public Builder addSourceCodeDirectory(File sourceCodeDirectory) {
            this.validateDirectory(sourceCodeDirectory);
            if (sourceCodeDirectory.exists()) {
                this.sourceCodeDirectories.add(sourceCodeDirectory);
            } else {
                LOG.info("ignoring absent source code directory " + sourceCodeDirectory.getAbsolutePath());
            }
            return this;
        }

        public Builder compiledCodeDirectories(List<File> compiledCodeDirectories) {
            this.compiledCodeDirectories.clear();
            for (File file : compiledCodeDirectories) {
                this.addCompiledCodeDirectory(file);
            }
            return this;
        }

        public Builder addCompiledCodeDirectory(File compiledCodeDirectory) {
            this.validateDirectory(compiledCodeDirectory);
            if (compiledCodeDirectory.exists()) {
                this.compiledCodeDirectories.add(compiledCodeDirectory);
            } else {
                LOG.info("ignoring absent compiled code directory " + compiledCodeDirectory.getAbsolutePath());
            }
            return this;
        }

        public Set<File> getCompiledCodeDirectories() {
            return this.compiledCodeDirectories;
        }

        public Set<File> getLineCoverageFiles() {
            return this.lineCoverageFiles;
        }

        public Set<File> getMutationResultsFiles() {
            return this.mutationResultsFiles;
        }

        public Set<File> getSourceCodeDirectories() {
            return this.sourceCodeDirectories;
        }

        public Charset getInputCharSet() {
            return this.inputCharset;
        }

        public Charset getOutputCharSet() {
            return this.outputCharset;
        }

        public ReportAggregator build() {
            this.validateState();
            SettingsFactory settings = new SettingsFactory(new ReportOptions(), PluginServices.makeForContextLoader());
            return new ReportAggregator(settings, this.resultOutputStrategy, this.lineCoverageFiles, this.mutationResultsFiles, this.sourceCodeDirectories, this.compiledCodeDirectories, this.inputCharset, this.outputCharset);
        }

        private void validateState() {
            if (this.resultOutputStrategy == null) {
                throw new IllegalStateException("Failed to build: the resultOutputStrategy has not been set");
            }
            if (this.lineCoverageFiles.isEmpty()) {
                throw new IllegalStateException("Failed to build: no lineCoverageFiles have been set");
            }
            if (this.mutationResultsFiles.isEmpty()) {
                throw new IllegalStateException("Failed to build: no mutationResultsFiles have been set");
            }
            if (this.sourceCodeDirectories.isEmpty()) {
                throw new IllegalStateException("Failed to build: no sourceCodeDirectories have been set");
            }
            if (this.compiledCodeDirectories.isEmpty()) {
                throw new IllegalStateException("Failed to build: no compiledCodeDirectories have been set");
            }
        }

        private void validateFile(File file) {
            if (file == null) {
                throw new IllegalArgumentException("file is null");
            }
            if (file.exists() && !file.isFile()) {
                throw new IllegalArgumentException(file.getAbsolutePath() + "is not a file");
            }
        }

        private void validateDirectory(File directory) {
            if (directory == null) {
                throw new IllegalArgumentException("directory is null");
            }
            if (directory.exists() && !directory.isDirectory()) {
                throw new IllegalArgumentException(directory.getAbsolutePath() + " is not a directory");
            }
        }
    }
}

