/*
 * Decompiled with CFR 0.152.
 */
package pitest.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import pitest.fasterxml.jackson.core.JsonParser;
import pitest.fasterxml.jackson.databind.DeserializationConfig;
import pitest.fasterxml.jackson.databind.DeserializationContext;
import pitest.fasterxml.jackson.databind.JavaType;
import pitest.fasterxml.jackson.databind.deser.std.StdDeserializer;
import pitest.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import pitest.fasterxml.jackson.databind.type.LogicalType;
import pitest.fasterxml.jackson.databind.util.AccessPattern;

public abstract class StdScalarDeserializer<T>
extends StdDeserializer<T> {
    private static final long serialVersionUID = 1L;

    protected StdScalarDeserializer(Class<?> vc) {
        super(vc);
    }

    protected StdScalarDeserializer(JavaType valueType) {
        super(valueType);
    }

    protected StdScalarDeserializer(StdScalarDeserializer<?> src) {
        super(src);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.OtherScalar;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig config) {
        return Boolean.FALSE;
    }

    @Override
    public AccessPattern getNullAccessPattern() {
        return AccessPattern.ALWAYS_NULL;
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.CONSTANT;
    }

    @Override
    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromScalar(p, ctxt);
    }

    @Override
    public T deserialize(JsonParser p, DeserializationContext ctxt, T intoValue) throws IOException {
        ctxt.handleBadMerge(this);
        return this.deserialize(p, ctxt);
    }
}

