/*
 * Decompiled with CFR 0.152.
 */
package pitest.fasterxml.jackson.databind.ext;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import pitest.fasterxml.jackson.core.JsonGenerator;
import pitest.fasterxml.jackson.core.JsonToken;
import pitest.fasterxml.jackson.core.type.WritableTypeId;
import pitest.fasterxml.jackson.databind.JavaType;
import pitest.fasterxml.jackson.databind.JsonMappingException;
import pitest.fasterxml.jackson.databind.SerializerProvider;
import pitest.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import pitest.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import pitest.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import pitest.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import pitest.fasterxml.jackson.databind.jsontype.TypeSerializer;
import pitest.fasterxml.jackson.databind.ser.std.StdScalarSerializer;

@JacksonStdImpl
public class SqlBlobSerializer
extends StdScalarSerializer<Blob> {
    public SqlBlobSerializer() {
        super(Blob.class);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, Blob value) {
        return value == null;
    }

    @Override
    public void serialize(Blob value, JsonGenerator gen, SerializerProvider ctxt) throws IOException {
        this._writeValue(value, gen, ctxt);
    }

    @Override
    public void serializeWithType(Blob value, JsonGenerator gen, SerializerProvider ctxt, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId(value, JsonToken.VALUE_EMBEDDED_OBJECT));
        this._writeValue(value, gen, ctxt);
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    protected void _writeValue(Blob value, JsonGenerator gen, SerializerProvider ctxt) throws IOException {
        InputStream in = null;
        try {
            in = value.getBinaryStream();
        }
        catch (SQLException e) {
            ctxt.reportMappingProblem(e, "Failed to access `java.sql.Blob` value to write as binary value", new Object[0]);
        }
        gen.writeBinary(ctxt.getConfig().getBase64Variant(), in, -1);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

