/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.aggregate;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.ClassFilter;
import org.pitest.classpath.ClassPath;
import org.pitest.classpath.CodeSource;
import org.pitest.classpath.DirectoryClassPathRoot;
import org.pitest.classpath.PathFilter;
import org.pitest.classpath.ProjectClassPaths;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.predicate.Predicate;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.config.DefaultCodePathPredicate;
import org.pitest.mutationtest.config.DefaultDependencyPathPredicate;
import org.pitest.util.Glob;

class CodeSourceAggregator {
    private final Collection<File> compiledCodeDirectories;

    CodeSourceAggregator(Collection<File> compiledCodeDirectories) {
        this.compiledCodeDirectories = Collections.unmodifiableCollection(compiledCodeDirectories);
    }

    public CodeSource createCodeSource() {
        return new CodeSource(this.createProjectClassPaths());
    }

    private ProjectClassPaths createProjectClassPaths() {
        ClassPath classPath = new ClassPath(this.compiledCodeDirectories);
        Predicate<String> classPredicate = this.createClassPredicate();
        DefaultCodePathPredicate pathPredicate = new DefaultCodePathPredicate();
        return new ProjectClassPaths(classPath, new ClassFilter(classPredicate, classPredicate), new PathFilter((Predicate)pathPredicate, (Predicate)Prelude.not((F)new DefaultDependencyPathPredicate())));
    }

    private Predicate<String> createClassPredicate() {
        HashSet classes = new HashSet();
        for (File buildOutputDirectory : this.compiledCodeDirectories) {
            if (!buildOutputDirectory.exists()) continue;
            DirectoryClassPathRoot dcRoot = new DirectoryClassPathRoot(buildOutputDirectory);
            classes.addAll(FCollection.map((Iterable)dcRoot.classNames(), this.toPredicate()));
        }
        return Prelude.or((Iterable)FCollection.map(classes, (F)Glob.toGlobPredicate()));
    }

    private F<String, String> toPredicate() {
        return new F<String, String>(){

            public String apply(String a) {
                return ClassName.fromString((String)a).getPackage().asJavaName() + ".*";
            }
        };
    }
}

