/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.aggregate;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.pitest.aggregate.DataLoader;
import org.pitest.classinfo.ClassName;
import org.pitest.coverage.BlockCoverage;
import org.pitest.coverage.BlockLocation;
import org.pitest.mutationtest.engine.Location;

class BlockCoverageDataLoader
extends DataLoader<BlockCoverage> {
    private static final String BLOCK = "block";
    private static final String TESTS = "tests";
    private static final String TEST = "test";
    private static final String NAME = "name";
    private static final String METHOD = "method";
    private static final String CLASSNAME = "classname";
    private static final String NUMBER = "number";
    private static final String FIRST_INSN = "firstInstruction";
    private static final String LAST_INSN = "lastInstruction";
    private static final String OPEN_PAREN = "(";

    BlockCoverageDataLoader(Collection<File> filesToLoad) {
        super(filesToLoad);
    }

    @Override
    protected Set<BlockCoverage> mapToData(XMLEventReader doc) throws XMLStreamException {
        HashSet<BlockCoverage> data = new HashSet<BlockCoverage>();
        ArrayList<String> tests = new ArrayList<String>();
        StartElement enclosingNode = null;
        BlockLocation block = null;
        while (doc.hasNext()) {
            String nodeName;
            XMLEvent next = doc.peek();
            if (next.isStartElement()) {
                enclosingNode = next.asStartElement();
                nodeName = next.asStartElement().getName().getLocalPart();
                if (nodeName.equals(BLOCK)) {
                    block = this.toBlockLocation(enclosingNode);
                }
                if (nodeName.equals(TESTS)) {
                    tests = new ArrayList();
                }
                if (nodeName.equals(TEST)) {
                    tests.add(this.getAttributeValue(enclosingNode, NAME));
                }
            }
            if (next.isEndElement() && (nodeName = next.asEndElement().getName().getLocalPart()).equals(BLOCK)) {
                data.add(new BlockCoverage(block, tests.isEmpty() ? null : tests));
            }
            doc.next();
        }
        return data;
    }

    private BlockLocation toBlockLocation(StartElement enclosingNode) {
        ClassName className = ClassName.fromString((String)this.getAttributeValue(enclosingNode, CLASSNAME));
        String method = this.getAttributeValue(enclosingNode, METHOD);
        String methodName = method.substring(0, method.indexOf(OPEN_PAREN));
        int blockNum = this.getAttributeValueAsInt(enclosingNode, NUMBER);
        int firstInstruction = this.getAttributeValueAsInt(enclosingNode, FIRST_INSN);
        int lastInstruction = this.getAttributeValueAsInt(enclosingNode, LAST_INSN);
        String methodDesc = method.substring(method.indexOf(OPEN_PAREN));
        Location location = new Location(className, methodName, methodDesc);
        BlockLocation block = new BlockLocation(location, blockNum, firstInstruction, lastInstruction);
        return block;
    }

    private String getAttributeValue(StartElement enclosingNode, String attributeName) {
        Attribute attribute = enclosingNode.getAttributeByName(QName.valueOf(attributeName));
        return attribute == null ? null : attribute.getValue();
    }

    private int getAttributeValueAsInt(StartElement enclosingNode, String attributeName) {
        String value = this.getAttributeValue(enclosingNode, attributeName);
        return value == null ? 0 : Integer.parseInt(value);
    }
}

