/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.commandline;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.util.KeyValuePair;
import org.pitest.classpath.ClassPath;
import org.pitest.functional.FCollection;
import org.pitest.functional.Streams;
import org.pitest.mutationtest.commandline.CommaAwareArgsProcessor;
import org.pitest.mutationtest.commandline.ParseResult;
import org.pitest.mutationtest.config.ConfigOption;
import org.pitest.mutationtest.config.ExecutionMode;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.testapi.TestGroupConfig;
import org.pitest.util.Glob;
import org.pitest.util.Log;
import org.pitest.util.Unchecked;
import org.pitest.util.Verbosity;

public class OptionsParser {
    private final Predicate<String> dependencyFilter;
    private static final Logger LOG = Log.getLogger();
    private final OptionParser parser;
    private final ArgumentAcceptingOptionSpec<String> reportDirSpec;
    private final OptionSpec<String> targetClassesSpec;
    private final OptionSpec<String> targetTestsSpec;
    private final OptionSpec<String> avoidCallsSpec;
    private final OptionSpec<Integer> threadsSpec;
    private final OptionSpec<File> sourceDirSpec;
    private final OptionSpec<File> historyOutputSpec;
    private final OptionSpec<File> historyInputSpec;
    private final OptionSpec<String> mutators;
    private final OptionSpec<String> features;
    private final OptionSpec<String> argLine;
    private final OptionSpec<String> jvmArgs;
    private final CommaAwareArgsProcessor jvmArgsProcessor;
    private final OptionSpec<Float> timeoutFactorSpec;
    private final OptionSpec<Long> timeoutConstSpec;
    private final OptionSpec<String> excludedMethodsSpec;
    private final ArgumentAcceptingOptionSpec<Boolean> verboseSpec;
    private final ArgumentAcceptingOptionSpec<String> verbositySpec;
    private final OptionSpec<String> excludedClassesSpec;
    private final OptionSpec<String> excludedTestClassesSpec;
    private final OptionSpec<String> outputFormatSpec;
    private final OptionSpec<String> additionalClassPathSpec;
    private final OptionSpec<File> classPathFile;
    private final ArgumentAcceptingOptionSpec<Boolean> failWhenNoMutations;
    private final ArgumentAcceptingOptionSpec<Boolean> skipFailingTests;
    private final ArgumentAcceptingOptionSpec<String> codePaths;
    private final OptionSpec<String> excludedRunnersSpec;
    private final OptionSpec<String> excludedGroupsSpec;
    private final OptionSpec<String> includedGroupsSpec;
    private final OptionSpec<String> includedTestMethodsSpec;
    private final ArgumentAcceptingOptionSpec<Boolean> fullMutationMatrixSpec;
    private final OptionSpec<Integer> mutationUnitSizeSpec;
    private final ArgumentAcceptingOptionSpec<Boolean> timestampedReportsSpec;
    private final ArgumentAcceptingOptionSpec<Boolean> detectInlinedCode;
    private final ArgumentAcceptingOptionSpec<Integer> mutationThreshHoldSpec;
    private final ArgumentAcceptingOptionSpec<Integer> testStrengthThreshHoldSpec;
    private final ArgumentAcceptingOptionSpec<Integer> coverageThreshHoldSpec;
    private final ArgumentAcceptingOptionSpec<Integer> maxSurvivingSpec;
    private final OptionSpec<String> mutationEngine;
    private final ArgumentAcceptingOptionSpec<Boolean> exportLineCoverageSpec;
    private final OptionSpec<String> javaExecutable;
    private final OptionSpec<KeyValuePair> pluginPropertiesSpec;
    private final OptionSpec<String> testPluginSpec;
    private final ArgumentAcceptingOptionSpec<Boolean> includeLaunchClasspathSpec;
    private final ArgumentAcceptingOptionSpec<Boolean> useClasspathJarSpec;
    private final OptionSpec<File> projectBaseSpec;
    private final OptionSpec<String> inputEncoding;
    private final OptionSpec<String> outputEncoding;
    private final ArgumentAcceptingOptionSpec<Boolean> dryRunSpec;

    public OptionsParser(Predicate<String> dependencyFilter) {
        this.dependencyFilter = dependencyFilter;
        this.parser = new OptionParser();
        this.parser.acceptsAll(Arrays.asList("h", "?"), "show help");
        this.testPluginSpec = this.parserAccepts(ConfigOption.TEST_PLUGIN).withRequiredArg().ofType(String.class).defaultsTo("junit", (String[])new String[0]).describedAs("this parameter is ignored and will be removed in a future release");
        this.reportDirSpec = this.parserAccepts(ConfigOption.REPORT_DIR).withRequiredArg().describedAs("directory to create report folder in").required();
        this.targetClassesSpec = this.parserAccepts(ConfigOption.TARGET_CLASSES).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("comma separated list of filters to match against classes to test").required();
        this.avoidCallsSpec = this.parserAccepts(ConfigOption.AVOID_CALLS).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("comma separated list of packages to consider as untouchable logging calls");
        this.targetTestsSpec = this.parserAccepts(ConfigOption.TEST_FILTER).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("comma separated list of filters to match against tests to run");
        this.threadsSpec = this.parserAccepts(ConfigOption.THREADS).withRequiredArg().ofType(Integer.class).defaultsTo((Integer)ConfigOption.THREADS.getDefault(Integer.class), (Integer[])new Integer[0]).describedAs("number of threads to use for testing");
        this.parserAccepts(ConfigOption.MAX_MUTATIONS_PER_CLASS).withRequiredArg().ofType(Integer.class).defaultsTo((Integer)ConfigOption.MAX_MUTATIONS_PER_CLASS.getDefault(Integer.class), (Integer[])new Integer[0]).describedAs("No longer supported. Use CLASSLIMIT(limit[42]) feature instead");
        this.sourceDirSpec = this.parserAccepts(ConfigOption.SOURCE_DIR).withRequiredArg().ofType(File.class).withValuesSeparatedBy(',').describedAs("comma separated list of source directories").required();
        this.mutators = this.parserAccepts(ConfigOption.MUTATIONS).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("comma separated list of mutation operators");
        this.features = this.parserAccepts(ConfigOption.FEATURES).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("comma separated list of features to enable/disable.");
        this.argLine = this.parserAccepts(ConfigOption.ARG_LINE).withRequiredArg().describedAs("argline for child JVMs");
        this.jvmArgs = this.parserAccepts(ConfigOption.CHILD_JVM).withRequiredArg().describedAs("comma separated list of child JVM args");
        this.jvmArgsProcessor = new CommaAwareArgsProcessor(this.jvmArgs);
        this.detectInlinedCode = this.parserAccepts(ConfigOption.USE_INLINED_CODE_DETECTION).withOptionalArg().ofType(Boolean.class).defaultsTo((Boolean)ConfigOption.USE_INLINED_CODE_DETECTION.getDefault(Boolean.class), (Boolean[])new Boolean[0]).describedAs("whether or not to try and detect code inlined from finally blocks");
        this.timestampedReportsSpec = this.parserAccepts(ConfigOption.TIME_STAMPED_REPORTS).withOptionalArg().ofType(Boolean.class).defaultsTo((Boolean)ConfigOption.TIME_STAMPED_REPORTS.getDefault(Boolean.class), (Boolean[])new Boolean[0]).describedAs("whether or not to generated timestamped directories");
        this.timeoutFactorSpec = this.parserAccepts(ConfigOption.TIMEOUT_FACTOR).withOptionalArg().ofType(Float.class).describedAs("factor to apply to calculate maximum test duration").defaultsTo((Float)ConfigOption.TIMEOUT_FACTOR.getDefault(Float.class), (Float[])new Float[0]);
        this.timeoutConstSpec = this.parserAccepts(ConfigOption.TIMEOUT_CONST).withOptionalArg().ofType(Long.class).describedAs("constant to apply to calculate maximum test duration").defaultsTo((Long)ConfigOption.TIMEOUT_CONST.getDefault(Long.class), (Long[])new Long[0]);
        this.excludedMethodsSpec = this.parserAccepts(ConfigOption.EXCLUDED_METHOD).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("comma separated list of filters to match against methods to exclude from mutation analysis");
        this.excludedClassesSpec = this.parserAccepts(ConfigOption.EXCLUDED_CLASSES).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("comma separated list of globs for classes to exclude when mutating");
        this.excludedTestClassesSpec = this.parserAccepts(ConfigOption.EXCLUDED_TEST_CLASSES).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("comma separated list of globs of test classes to exclude");
        this.verboseSpec = this.parserAccepts(ConfigOption.VERBOSE).withOptionalArg().ofType(Boolean.class).defaultsTo((Boolean)ConfigOption.VERBOSE.getDefault(Boolean.class), (Boolean[])new Boolean[0]).describedAs("whether or not to generate verbose output");
        this.verbositySpec = this.parserAccepts(ConfigOption.VERBOSITY).withOptionalArg().ofType(String.class).defaultsTo("DEFAULT", (String[])new String[0]).describedAs("the verbosity of output");
        this.exportLineCoverageSpec = this.parserAccepts(ConfigOption.EXPORT_LINE_COVERAGE).withOptionalArg().ofType(Boolean.class).defaultsTo((Boolean)ConfigOption.EXPORT_LINE_COVERAGE.getDefault(Boolean.class), (Boolean[])new Boolean[0]).describedAs("whether or not to dump per test line coverage data to disk");
        this.useClasspathJarSpec = this.parserAccepts(ConfigOption.USE_CLASSPATH_JAR).withOptionalArg().ofType(Boolean.class).defaultsTo((Boolean)ConfigOption.USE_CLASSPATH_JAR.getDefault(Boolean.class), (Boolean[])new Boolean[0]).describedAs("support large classpaths by creating a classpath jar");
        this.includeLaunchClasspathSpec = this.parserAccepts(ConfigOption.INCLUDE_LAUNCH_CLASSPATH).withOptionalArg().ofType(Boolean.class).defaultsTo((Boolean)ConfigOption.INCLUDE_LAUNCH_CLASSPATH.getDefault(Boolean.class), (Boolean[])new Boolean[0]).describedAs("whether or not to analyse launch classpath");
        this.outputFormatSpec = this.parserAccepts(ConfigOption.OUTPUT_FORMATS).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("comma separated list of listeners to receive mutation results").defaultsTo("HTML", (String[])new String[0]);
        this.additionalClassPathSpec = this.parserAccepts(ConfigOption.CLASSPATH).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("coma separated list of additional classpath elements");
        this.classPathFile = this.parserAccepts(ConfigOption.CLASSPATH_FILE).withRequiredArg().ofType(File.class).describedAs("File with a list of additional classpath elements (one per line)");
        this.failWhenNoMutations = this.parserAccepts(ConfigOption.FAIL_WHEN_NOT_MUTATIONS).withOptionalArg().ofType(Boolean.class).defaultsTo((Boolean)ConfigOption.FAIL_WHEN_NOT_MUTATIONS.getDefault(Boolean.class), (Boolean[])new Boolean[0]).describedAs("whether to throw error if no mutations found");
        this.skipFailingTests = this.parserAccepts(ConfigOption.SKIP_FAILING_TESTS).withOptionalArg().ofType(Boolean.class).defaultsTo((Boolean)ConfigOption.SKIP_FAILING_TESTS.getDefault(Boolean.class), (Boolean[])new Boolean[0]).describedAs("whether to ignore failing tests when computing coverage");
        this.codePaths = this.parserAccepts(ConfigOption.CODE_PATHS).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("Globs identifying classpath roots containing mutable code");
        this.excludedRunnersSpec = this.parserAccepts(ConfigOption.EXCLUDED_RUNNERS).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("JUnit4 runners to exclude");
        this.includedGroupsSpec = this.parserAccepts(ConfigOption.INCLUDED_GROUPS).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("TestNG groups/JUnit categories to include");
        this.includedTestMethodsSpec = this.parserAccepts(ConfigOption.INCLUDED_TEST_METHODS).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("Test methods that should be included for challenging the mutants");
        this.excludedGroupsSpec = this.parserAccepts(ConfigOption.EXCLUDED_GROUPS).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("TestNG groups/JUnit categories to include");
        this.fullMutationMatrixSpec = this.parserAccepts(ConfigOption.FULL_MUTATION_MATRIX).withOptionalArg().ofType(Boolean.class).describedAs("Whether to create a full mutation matrix").defaultsTo((Boolean)ConfigOption.FULL_MUTATION_MATRIX.getDefault(Boolean.class), (Boolean[])new Boolean[0]);
        this.mutationUnitSizeSpec = this.parserAccepts(ConfigOption.MUTATION_UNIT_SIZE).withRequiredArg().ofType(Integer.class).describedAs("Maximum number of mutations to include within a single unit of analysis").defaultsTo((Integer)ConfigOption.MUTATION_UNIT_SIZE.getDefault(Integer.class), (Integer[])new Integer[0]);
        this.historyInputSpec = this.parserAccepts(ConfigOption.HISTORY_INPUT_LOCATION).withRequiredArg().ofType(File.class).describedAs("File to read history from for incremental analysis");
        this.historyOutputSpec = this.parserAccepts(ConfigOption.HISTORY_OUTPUT_LOCATION).withRequiredArg().ofType(File.class).describedAs("File to write history to for incremental analysis");
        this.mutationThreshHoldSpec = this.parserAccepts(ConfigOption.MUTATION_THRESHOLD).withRequiredArg().ofType(Integer.class).describedAs("Mutation score below which to throw an error").defaultsTo((Integer)ConfigOption.MUTATION_THRESHOLD.getDefault(Integer.class), (Integer[])new Integer[0]);
        this.testStrengthThreshHoldSpec = this.parserAccepts(ConfigOption.TEST_STRENGTH_THRESHOLD).withRequiredArg().ofType(Integer.class).describedAs("Test strength score below which to throw an error").defaultsTo((Integer)ConfigOption.TEST_STRENGTH_THRESHOLD.getDefault(Integer.class), (Integer[])new Integer[0]);
        this.maxSurvivingSpec = this.parserAccepts(ConfigOption.MAX_SURVIVING).withRequiredArg().ofType(Integer.class).describedAs("Maximum number of surviving mutants to allow without throwing an error").defaultsTo((Integer)ConfigOption.MAX_SURVIVING.getDefault(Integer.class), (Integer[])new Integer[0]);
        this.coverageThreshHoldSpec = this.parserAccepts(ConfigOption.COVERAGE_THRESHOLD).withRequiredArg().ofType(Integer.class).describedAs("Line coverage below which to throw an error").defaultsTo((Integer)ConfigOption.COVERAGE_THRESHOLD.getDefault(Integer.class), (Integer[])new Integer[0]);
        this.mutationEngine = this.parserAccepts(ConfigOption.MUTATION_ENGINE).withRequiredArg().ofType(String.class).describedAs("mutation engine to use").defaultsTo((String)ConfigOption.MUTATION_ENGINE.getDefault(String.class), (String[])new String[0]);
        this.javaExecutable = this.parserAccepts(ConfigOption.JVM_PATH).withRequiredArg().ofType(String.class).describedAs("path to java executable");
        this.inputEncoding = this.parserAccepts(ConfigOption.INPUT_ENCODING).withRequiredArg().ofType(String.class).describedAs("input encoding").defaultsTo((String)ConfigOption.INPUT_ENCODING.getDefault(String.class), (String[])new String[0]);
        this.outputEncoding = this.parserAccepts(ConfigOption.OUTPUT_ENCODING).withRequiredArg().ofType(String.class).describedAs("output encoding").defaultsTo((String)ConfigOption.OUTPUT_ENCODING.getDefault(String.class), (String[])new String[0]);
        this.pluginPropertiesSpec = this.parserAccepts(ConfigOption.PLUGIN_CONFIGURATION).withRequiredArg().ofType(KeyValuePair.class).describedAs("custom plugin properties");
        this.projectBaseSpec = this.parserAccepts(ConfigOption.PROJECT_BASE).withRequiredArg().ofType(File.class);
        this.dryRunSpec = this.parserAccepts(ConfigOption.DRY_RUN).withOptionalArg().ofType(Boolean.class).defaultsTo((Boolean)ConfigOption.VERBOSE.getDefault(Boolean.class), (Boolean[])new Boolean[0]).describedAs("enable or disable dry run mode");
    }

    private OptionSpecBuilder parserAccepts(ConfigOption option) {
        return this.parser.accepts(option.getParamName());
    }

    public ParseResult parse(String[] args) {
        ReportOptions data = new ReportOptions();
        try {
            OptionSet userArgs = this.parser.parse(args);
            return this.parseCommandLine(data, userArgs);
        }
        catch (OptionException uoe) {
            return new ParseResult(data, uoe.getLocalizedMessage());
        }
    }

    private ParseResult parseCommandLine(ReportOptions data, OptionSet userArgs) {
        data.setReportDir((String)this.reportDirSpec.value(userArgs));
        data.setTargetClasses(this.targetClassesSpec.values(userArgs));
        data.setTargetTests((Collection)Streams.asStream(this.targetTestsSpec.values(userArgs)).map(Glob.toGlobPredicate()).collect(Collectors.toList()));
        data.setSourceDirs(this.asPaths(this.sourceDirSpec.values(userArgs)));
        data.setMutators(this.mutators.values(userArgs));
        data.setFeatures(this.features.values(userArgs));
        data.setArgLine(this.argLine.value(userArgs));
        data.addChildJVMArgs(this.jvmArgsProcessor.values(userArgs));
        data.setFullMutationMatrix(this.booleanValue(this.fullMutationMatrixSpec, userArgs));
        data.setDetectInlinedCode(this.booleanValue(this.detectInlinedCode, userArgs));
        data.setIncludeLaunchClasspath(this.booleanValue(this.includeLaunchClasspathSpec, userArgs));
        data.setUseClasspathJar(this.booleanValue(this.useClasspathJarSpec, userArgs));
        data.setShouldCreateTimestampedReports(this.booleanValue(this.timestampedReportsSpec, userArgs));
        data.setNumberOfThreads(this.threadsSpec.value(userArgs).intValue());
        data.setTimeoutFactor(this.timeoutFactorSpec.value(userArgs).floatValue());
        data.setTimeoutConstant(this.timeoutConstSpec.value(userArgs).longValue());
        data.setLoggingClasses(this.avoidCallsSpec.values(userArgs));
        data.setExcludedMethods(this.excludedMethodsSpec.values(userArgs));
        data.setExcludedClasses(this.excludedClassesSpec.values(userArgs));
        data.setExcludedTestClasses((Collection)Streams.asStream(this.excludedTestClassesSpec.values(userArgs)).map(Glob.toGlobPredicate()).collect(Collectors.toList()));
        this.configureVerbosity(data, userArgs);
        data.addOutputFormats(this.outputFormatSpec.values(userArgs));
        data.setFailWhenNoMutations(this.booleanValue(this.failWhenNoMutations, userArgs));
        data.setSkipFailingTests(this.booleanValue(this.skipFailingTests, userArgs));
        data.setCodePaths(this.codePaths.values(userArgs));
        data.setMutationUnitSize(this.mutationUnitSizeSpec.value(userArgs).intValue());
        data.setHistoryInputLocation(this.historyInputSpec.value(userArgs));
        data.setHistoryOutputLocation(this.historyOutputSpec.value(userArgs));
        data.setMutationThreshold(((Integer)this.mutationThreshHoldSpec.value(userArgs)).intValue());
        data.setTestStrengthThreshold(((Integer)this.testStrengthThreshHoldSpec.value(userArgs)).intValue());
        data.setMaximumAllowedSurvivors(((Integer)this.maxSurvivingSpec.value(userArgs)).intValue());
        data.setCoverageThreshold(((Integer)this.coverageThreshHoldSpec.value(userArgs)).intValue());
        data.setMutationEngine(this.mutationEngine.value(userArgs));
        data.setFreeFormProperties(this.listToProperties(this.pluginPropertiesSpec.values(userArgs)));
        data.setExportLineCoverage(this.booleanValue(this.exportLineCoverageSpec, userArgs));
        this.setClassPath(userArgs, data);
        this.setTestGroups(userArgs, data);
        data.setExcludedRunners(this.excludedRunnersSpec.values(userArgs));
        data.setIncludedTestMethods(this.includedTestMethodsSpec.values(userArgs));
        data.setJavaExecutable(this.javaExecutable.value(userArgs));
        this.setEncoding(data, userArgs);
        this.configureExecutionMode(data, userArgs);
        if (userArgs.has(this.projectBaseSpec)) {
            data.setProjectBase(this.projectBaseSpec.value(userArgs).toPath());
        }
        if (userArgs.has("?")) {
            return new ParseResult(data, "See above for supported parameters.");
        }
        return new ParseResult(data, null);
    }

    private void setEncoding(ReportOptions data, OptionSet userArgs) {
        data.setInputEncoding(Charset.forName(this.inputEncoding.value(userArgs)));
        data.setOutputEncoding(Charset.forName(this.outputEncoding.value(userArgs)));
    }

    private void configureVerbosity(ReportOptions data, OptionSet userArgs) {
        if (this.booleanValue(this.verboseSpec, userArgs)) {
            data.setVerbosity(Verbosity.VERBOSE);
        } else {
            data.setVerbosity(Verbosity.fromString((String)((String)this.verbositySpec.value(userArgs))));
        }
    }

    private void configureExecutionMode(ReportOptions data, OptionSet userArgs) {
        if (this.booleanValue(this.dryRunSpec, userArgs)) {
            data.setExecutionMode(ExecutionMode.DRY_RUN);
        }
    }

    private void setClassPath(OptionSet userArgs, ReportOptions data) {
        ArrayList<String> elements = new ArrayList<String>();
        if (data.isIncludeLaunchClasspath()) {
            elements.addAll(ClassPath.getClassPathElementsAsPaths());
        } else {
            elements.addAll(FCollection.filter((Iterable)ClassPath.getClassPathElementsAsPaths(), this.dependencyFilter));
        }
        if (userArgs.has(this.classPathFile)) {
            try (BufferedReader classPathFileBR = new BufferedReader(new FileReader(this.classPathFile.value(userArgs).getAbsoluteFile()));){
                String element;
                while ((element = classPathFileBR.readLine()) != null) {
                    elements.add(element);
                }
            }
            catch (IOException ioe) {
                LOG.warning("Unable to read class path file:" + this.classPathFile.value(userArgs).getAbsolutePath() + " - " + ioe.getMessage());
            }
            data.setUseClasspathJar(true);
        }
        elements.addAll(this.additionalClassPathSpec.values(userArgs));
        data.setClassPathElements(elements);
    }

    private void setTestGroups(OptionSet userArgs, ReportOptions data) {
        TestGroupConfig conf = new TestGroupConfig(this.excludedGroupsSpec.values(userArgs), this.includedGroupsSpec.values(userArgs));
        data.setGroupConfig(conf);
    }

    private Properties listToProperties(List<KeyValuePair> kvps) {
        Properties p = new Properties();
        for (KeyValuePair kvp : kvps) {
            p.put(kvp.key, kvp.value);
        }
        return p;
    }

    private Collection<Path> asPaths(List<File> values) {
        return values.stream().map(File::toPath).collect(Collectors.toList());
    }

    public void printHelp() {
        try {
            this.parser.printHelpOn(System.out);
        }
        catch (IOException ex) {
            throw Unchecked.translateCheckedException((Throwable)ex);
        }
    }

    private boolean booleanValue(ArgumentAcceptingOptionSpec<Boolean> spec, OptionSet userArgs) {
        return userArgs.has(spec) && !userArgs.hasArgument(spec) || (Boolean)spec.value(userArgs) != false;
    }
}

